/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.poller.monitors;

import groovy.lang.GroovyClassLoader;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.codehaus.groovy.control.CompilationFailedException;
import org.junit.runner.Computer;
import org.junit.runner.JUnitCore;
import org.junit.runner.Result;
import org.junit.runner.notification.Failure;
import org.opennms.core.utils.TimeoutTracker;
import org.opennms.netmgt.junit.runner.SeleniumComputer;
import org.opennms.netmgt.poller.MonitoredService;
import org.opennms.netmgt.poller.PollStatus;
import org.opennms.netmgt.poller.support.AbstractServiceMonitor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SeleniumMonitor
extends AbstractServiceMonitor {
    private static final Logger LOG = LoggerFactory.getLogger(SeleniumMonitor.class);
    private final GroovyClassLoader m_gcl = new GroovyClassLoader();
    private static final int DEFAULT_SEQUENCE_RETRY = 0;
    private static final int DEFAULT_TIMEOUT = 3000;

    public PollStatus poll(MonitoredService svc, Map<String, Object> parameters) {
        PollStatus serviceStatus = PollStatus.unavailable((String)"Poll not completed yet");
        TimeoutTracker tracker = new TimeoutTracker(parameters, 0, 3000);
        tracker.reset();
        while (tracker.shouldRetry() && !serviceStatus.isAvailable()) {
            String reason;
            String seleniumTestFilename = this.getGroovyFilename(parameters);
            try {
                HashMap<String, Double> responseTimes = new HashMap<String, Double>();
                responseTimes.put("response-time", Double.NaN);
                tracker.startAttempt();
                Result result = this.runTest(this.getBaseUrl(parameters, svc), this.getTimeout(parameters), this.createGroovyClass(seleniumTestFilename));
                double responseTime = tracker.elapsedTimeInMillis();
                responseTimes.put("response-time", responseTime);
                if (result.wasSuccessful()) {
                    serviceStatus = PollStatus.available();
                    serviceStatus.setProperties(responseTimes);
                } else {
                    serviceStatus = PollStatus.unavailable((String)this.getFailureMessage(result, svc));
                }
            }
            catch (CompilationFailedException e) {
                serviceStatus = PollStatus.unavailable((String)("Selenium page sequence attempt on:" + svc.getIpAddr() + " failed : selenium-test compilation error " + e.getMessage()));
                reason = "Selenium sequence failed: CompilationFailedException" + e.getMessage();
                LOG.debug(reason, (Throwable)e);
                PollStatus.unavailable((String)reason);
            }
            catch (IOException e) {
                serviceStatus = PollStatus.unavailable((String)("Selenium page sequence attempt on " + svc.getIpAddr() + " failed: IOException occurred, failed to find selenium-test: " + seleniumTestFilename));
                reason = "Selenium sequence failed: IOException: " + e.getMessage();
                LOG.debug(reason, (Throwable)e);
                PollStatus.unavailable((String)reason);
            }
            catch (Exception e) {
                serviceStatus = PollStatus.unavailable((String)("Selenium page sequence attempt on " + svc.getIpAddr() + " failed:\n" + e.getMessage()));
                reason = "Selenium sequence failed: Exception: " + e.getMessage();
                LOG.debug(reason, (Throwable)e);
                PollStatus.unavailable((String)reason);
            }
            tracker.nextAttempt();
        }
        return serviceStatus;
    }

    private int getTimeout(Map<String, Object> parameters) {
        if (parameters.containsKey("timeout")) {
            return Integer.parseInt("" + parameters.get("timeout"));
        }
        return 3;
    }

    private String getBaseUrl(Map<String, Object> parameters, MonitoredService svc) {
        if (parameters.containsKey("base-url")) {
            Object baseUrl = (String)parameters.get("base-url");
            if (!((String)baseUrl).contains("http")) {
                baseUrl = "http://" + (String)baseUrl;
            }
            if (((String)baseUrl).contains("${ipAddr}")) {
                baseUrl = BaseUrlUtils.replaceIpAddr((String)baseUrl, svc.getIpAddr());
            }
            if (parameters.containsKey("port")) {
                String port = (String)parameters.get("port");
                baseUrl = (String)baseUrl + ":" + port;
            }
            return baseUrl;
        }
        return null;
    }

    private String getFailureMessage(Result result, MonitoredService svc) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("Failed: ");
        for (Failure failure : result.getFailures()) {
            stringBuilder.append(" " + failure.getMessage() + "\n");
        }
        String reason = "Selenium sequence failed: " + stringBuilder.toString();
        LOG.debug(reason);
        PollStatus.unavailable((String)reason);
        return stringBuilder.toString();
    }

    private Result runTest(String baseUrl, int timeoutInSeconds, Class<?> clazz) {
        return JUnitCore.runClasses((Computer)new SeleniumComputer(baseUrl, timeoutInSeconds), (Class[])new Class[]{clazz});
    }

    private String getGroovyFilename(Map<String, Object> parameters) {
        if (parameters.containsKey("selenium-test")) {
            return (String)parameters.get("selenium-test");
        }
        return "";
    }

    private Class<?> createGroovyClass(String filename) throws CompilationFailedException, IOException {
        String file = System.getProperty("opennms.home") + "/etc/selenium/" + filename;
        System.err.println("File name: " + file);
        return this.m_gcl.parseClass(new File(file));
    }

    public static class BaseUrlUtils {
        private static Pattern s_ipAddrPattern = Pattern.compile("\\$\\{ipAddr\\}");

        public static String replaceIpAddr(String baseUrl, String monSvcIpAddr) {
            if (!baseUrl.contains("${ipAddr}")) {
                return baseUrl;
            }
            String finalUrl = "";
            Matcher matcher = s_ipAddrPattern.matcher(baseUrl);
            finalUrl = matcher.replaceAll(monSvcIpAddr);
            return finalUrl;
        }
    }
}

