/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.enlinkd.generator.protocol;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.tuple.Pair;
import org.opennms.enlinkd.generator.TopologyContext;
import org.opennms.enlinkd.generator.TopologyGenerator;
import org.opennms.enlinkd.generator.TopologySettings;
import org.opennms.enlinkd.generator.protocol.Protocol;
import org.opennms.enlinkd.generator.topology.PairGenerator;
import org.opennms.netmgt.enlinkd.model.UserDefinedLink;
import org.opennms.netmgt.model.OnmsNode;

public class UserDefinedProtocol
extends Protocol {
    public static final String OWNER = TopologyGenerator.class.getCanonicalName();
    private final TopologyGenerator.Protocol protocol = TopologyGenerator.Protocol.userdefined;

    public UserDefinedProtocol(TopologySettings topologySettings, TopologyContext context) {
        super(topologySettings, context);
    }

    @Override
    public void createAndPersistProtocolSpecificEntities(List<OnmsNode> nodes) {
        List<UserDefinedLink> links = this.createLinks(nodes);
        this.context.getTopologyPersister().persist(links);
    }

    private List<UserDefinedLink> createLinks(List<OnmsNode> nodes) {
        PairGenerator<OnmsNode> pairs = this.createPairGenerator(nodes);
        ArrayList<UserDefinedLink> links = new ArrayList<UserDefinedLink>();
        for (int i = 0; i < this.topologySettings.getAmountLinks() / 2; ++i) {
            Pair<OnmsNode, OnmsNode> pair = pairs.next();
            OnmsNode sourceNode = (OnmsNode)pair.getLeft();
            OnmsNode targetNode = (OnmsNode)pair.getRight();
            UserDefinedLink udl = new UserDefinedLink();
            udl.setNodeIdA(sourceNode.getId());
            udl.setComponentLabelA(Integer.toString((Integer)this.nodeIfIndexes.get(sourceNode.getId())));
            udl.setNodeIdZ(targetNode.getId());
            udl.setComponentLabelZ(Integer.toString((Integer)this.nodeIfIndexes.get(sourceNode.getId())));
            udl.setOwner(OWNER);
            udl.setLinkId(Integer.toString(i));
            links.add(udl);
            this.context.currentProgress(String.format("Linked node %s with node %s", sourceNode.getLabel(), targetNode.getLabel()));
        }
        return links;
    }

    @Override
    public TopologyGenerator.Protocol getProtocol() {
        return this.protocol;
    }
}

