/*
 * Decompiled with CFR 0.152.
 */
package io.hawt.log.support;

import java.lang.reflect.Array;
import java.util.Arrays;

public class LruList<T> {
    private final Class<T> klass;
    private final int size;
    private T[] elements;
    private transient int start = 0;
    private transient int end = 0;
    private transient boolean full = false;
    private final int maxElements;

    public LruList(Class<T> klass, int size) {
        this.klass = klass;
        if (size <= 0) {
            throw new IllegalArgumentException("The size must be greater than 0");
        }
        this.size = size;
        this.elements = this.createArray(size);
        this.maxElements = this.elements.length;
    }

    public synchronized int size() {
        int size = 0;
        size = this.end < this.start ? this.maxElements - this.start + this.end : (this.end == this.start ? (this.full ? this.maxElements : 0) : this.end - this.start);
        return size;
    }

    public synchronized void clear() {
        this.start = 0;
        this.end = 0;
        this.elements = this.createArray(this.size);
    }

    public synchronized void add(T element) {
        T e;
        if (null == element) {
            throw new NullPointerException("Attempted to add null object to buffer");
        }
        if (this.size() == this.maxElements && null != (e = this.elements[this.start])) {
            this.elements[this.start++] = null;
            if (this.start >= this.maxElements) {
                this.start = 0;
            }
            this.full = false;
        }
        this.elements[this.end++] = element;
        if (this.end >= this.maxElements) {
            this.end = 0;
        }
        if (this.end == this.start) {
            this.full = true;
        }
    }

    public synchronized Iterable<T> getElements() {
        return this.getElements(this.size());
    }

    public synchronized Iterable<T> getElements(int number) {
        int s = this.size();
        int n = Math.min(Math.max(0, number), s);
        T[] e = this.createArray(n);
        for (int i = 0; i < n; ++i) {
            e[i] = this.elements[(i + s - n + this.start) % this.maxElements];
        }
        return Arrays.asList(e);
    }

    private T[] createArray(int size) {
        return (Object[])Array.newInstance(this.klass, size);
    }
}

