/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.features.uiextension.impl;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.List;
import org.apache.commons.io.IOUtils;
import org.opennms.features.apilayer.uiextension.UIExtensionRegistry;
import org.opennms.features.uiextension.api.UIExtensionService;
import org.opennms.integration.api.v1.ui.UIExtension;
import org.osgi.framework.Bundle;
import org.osgi.framework.FrameworkUtil;

public class UIExtensionServiceImpl
implements UIExtensionService {
    private static final String UI_PATH = "web/components";
    private final UIExtensionRegistry extensionRegistry;

    public UIExtensionServiceImpl(UIExtensionRegistry registry) {
        this.extensionRegistry = registry;
    }

    @Override
    public List<UIExtension> listPlugins() {
        return this.extensionRegistry.listExtensions();
    }

    @Override
    public String getExtensionJSFile(String id, String resourcePath) throws IOException {
        return this.readExtensionFile(id, resourcePath);
    }

    @Override
    public String getExtensionCSSFile(String id) throws IOException {
        UIExtension extension = this.extensionRegistry.getExtensionByID(id);
        return this.readExtensionFile(id, extension.getResourceRootPath() + "/style.css");
    }

    private String readExtensionFile(String id, String filePath) throws IOException {
        UIExtension extension = this.extensionRegistry.getExtensionByID(id);
        Bundle bundle = FrameworkUtil.getBundle((Class)extension.getExtensionClass());
        if (bundle == null) {
            return null;
        }
        URL url = bundle.getResource(filePath);
        if (url == null) {
            return null;
        }
        return new String(IOUtils.toByteArray((InputStream)url.openStream()));
    }
}

