/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.features.reporting.rest.internal;

import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import com.google.common.io.ByteStreams;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.nio.file.Paths;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.time.DateTimeException;
import java.time.Duration;
import java.time.ZoneId;
import java.time.temporal.ChronoUnit;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.TimeZone;
import java.util.stream.Collectors;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.StreamingOutput;
import javax.ws.rs.core.UriInfo;
import org.apache.commons.io.IOUtils;
import org.json.JSONArray;
import org.json.JSONObject;
import org.opennms.api.reporting.ReportException;
import org.opennms.api.reporting.ReportFormat;
import org.opennms.api.reporting.ReportMode;
import org.opennms.api.reporting.ReportParameterBuilder;
import org.opennms.api.reporting.parameter.ReportDateParm;
import org.opennms.api.reporting.parameter.ReportParameters;
import org.opennms.core.utils.WebSecurityUtils;
import org.opennms.features.reporting.rest.ReportRestService;
import org.opennms.features.reporting.rest.internal.ReportDetails;
import org.opennms.features.reporting.rest.internal.ReportDetailsBuilder;
import org.opennms.netmgt.dao.api.CategoryDao;
import org.opennms.netmgt.dao.api.ReportCatalogDao;
import org.opennms.netmgt.model.ReportCatalogEntry;
import org.opennms.reporting.core.DeliveryOptions;
import org.opennms.reporting.core.svclayer.DeliveryConfig;
import org.opennms.reporting.core.svclayer.ReportStoreService;
import org.opennms.reporting.core.svclayer.ReportWrapperService;
import org.opennms.reporting.core.svclayer.ScheduleConfig;
import org.opennms.web.svclayer.DatabaseReportListService;
import org.opennms.web.svclayer.SchedulerService;
import org.opennms.web.svclayer.dao.CategoryConfigDao;
import org.opennms.web.svclayer.model.DatabaseReportDescription;
import org.opennms.web.svclayer.model.TriggerDescription;
import org.opennms.web.svclayer.support.SchedulerContextException;
import org.opennms.web.svclayer.support.SchedulerException;
import org.opennms.web.utils.QueryParameters;
import org.opennms.web.utils.QueryParametersBuilder;
import org.opennms.web.utils.ResponseUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReportRestServiceImpl
implements ReportRestService {
    private static final Logger LOG = LoggerFactory.getLogger(ReportRestServiceImpl.class);
    private final DatabaseReportListService databaseReportListService;
    private final ReportWrapperService reportWrapperService;
    private final CategoryDao categoryDao;
    private final CategoryConfigDao categoryConfigDao;
    private final ReportStoreService reportStoreService;
    private final SchedulerService schedulerService;
    private final ReportCatalogDao reportCatalogDao;

    public ReportRestServiceImpl(DatabaseReportListService databaseReportListService, ReportWrapperService reportWrapperService, CategoryDao categoryDao, CategoryConfigDao categoryConfigDao, ReportStoreService reportStoreService, SchedulerService schedulerService, ReportCatalogDao reportCatalogDao) {
        this.databaseReportListService = Objects.requireNonNull(databaseReportListService);
        this.reportWrapperService = Objects.requireNonNull(reportWrapperService);
        this.categoryDao = Objects.requireNonNull(categoryDao);
        this.categoryConfigDao = Objects.requireNonNull(categoryConfigDao);
        this.reportStoreService = Objects.requireNonNull(reportStoreService);
        this.schedulerService = Objects.requireNonNull(schedulerService);
        this.reportCatalogDao = Objects.requireNonNull(reportCatalogDao);
    }

    @Override
    public Response listReports() {
        List activeRepositories = this.databaseReportListService.getActiveRepositories();
        List reportDescriptions = activeRepositories.stream().flatMap(repositoryDescriptor -> this.databaseReportListService.getReportsByRepositoryId(repositoryDescriptor.getId()).stream()).collect(Collectors.toList());
        if (reportDescriptions.isEmpty()) {
            return Response.noContent().build();
        }
        JSONArray jsonArray = new JSONArray();
        for (DatabaseReportDescription description : reportDescriptions) {
            JSONObject json = new JSONObject();
            json.put("id", (Object)description.getId().trim());
            json.put("name", (Object)description.getDisplayName().trim());
            json.put("description", (Object)(Strings.isNullOrEmpty((String)description.getDescription()) ? "" : description.getDescription().trim()));
            json.put("allowAccess", description.getAllowAccess());
            json.put("online", description.getIsOnline());
            json.put("repositoryId", (Object)description.getRepositoryId());
            jsonArray.put((Object)json);
        }
        return Response.ok((Object)jsonArray.toString()).type(MediaType.APPLICATION_JSON_TYPE).build();
    }

    @Override
    public Response getReportDetails(String reportId, String userId) {
        List formats = this.reportWrapperService.getFormats(reportId);
        ReportParameters parameters = this.reportWrapperService.getParameters(reportId);
        Collection categories = this.categoryConfigDao.findAll();
        List surveillanceCategories = this.categoryDao.findAll();
        ReportDetailsBuilder reportDetailsBuilder = new ReportDetailsBuilder().withReportId(reportId).withFormats(formats).withParameters(parameters).withCategories(categories).withSurveillanceCategories(surveillanceCategories).withDefaultTimezones();
        if (userId != null) {
            DeliveryOptions deliveryOptions = this.reportWrapperService.getDeliveryOptions(reportId, userId);
            reportDetailsBuilder.withDeliveryOptions(deliveryOptions);
        }
        JSONObject jsonObject = reportDetailsBuilder.build().toJson();
        return Response.ok((Object)jsonObject.toString()).type(MediaType.APPLICATION_JSON_TYPE).build();
    }

    @Override
    public Response scheduleReport(Map<String, Object> parameters) {
        try {
            ReportParameters reportParameters = this.parseParameters(parameters, ReportMode.SCHEDULED);
            DeliveryOptions deliveryOptions = this.parseDeliveryOptions(parameters);
            ScheduleConfig scheduleConfig = new ScheduleConfig(reportParameters, deliveryOptions, (String)parameters.get("cronExpression"));
            this.schedulerService.addCronTrigger(scheduleConfig);
        }
        catch (SchedulerContextException ex) {
            return ReportRestServiceImpl.createErrorResponse(Response.Status.BAD_REQUEST, this.createErrorObject(ex.getContext(), ex.getRawMessage()));
        }
        catch (SchedulerException ex) {
            return ReportRestServiceImpl.createErrorResponse(Response.Status.BAD_REQUEST, this.createErrorObject((Exception)((Object)ex)));
        }
        return Response.accepted().build();
    }

    @Override
    public Response deliverReport(Map<String, Object> parameters) {
        try {
            ReportParameters reportParameters = this.parseParameters(parameters, ReportMode.IMMEDIATE);
            DeliveryOptions deliveryOptions = this.parseDeliveryOptions(parameters);
            DeliveryConfig deliveryConfig = new DeliveryConfig(reportParameters, deliveryOptions);
            this.schedulerService.execute(deliveryConfig);
        }
        catch (SchedulerContextException ex) {
            return ReportRestServiceImpl.createErrorResponse(Response.Status.BAD_REQUEST, this.createErrorObject(ex.getContext(), ex.getRawMessage()));
        }
        catch (SchedulerException ex) {
            return ReportRestServiceImpl.createErrorResponse(Response.Status.BAD_REQUEST, this.createErrorObject((Exception)((Object)ex)));
        }
        return Response.accepted().build();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Response runReport(String reportId, Map<String, Object> inputParameters) {
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        try {
            ReportParameters parameters = this.parseParameters(inputParameters, ReportMode.IMMEDIATE);
            parameters.setReportId(reportId);
            this.reportWrapperService.runAndRender(parameters, ReportMode.IMMEDIATE, (OutputStream)outputStream);
            if (parameters.getFormat() == ReportFormat.PDF || parameters.getFormat() == ReportFormat.SVG) {
                Response response = Response.ok().type("application/pdf;charset=UTF-8").header("Content-disposition", (Object)"inline; filename=report.pdf").header("Pragma", (Object)"public").header("Cache-Control", (Object)"cache").header("Cache-Control", (Object)"must-revalidate").entity((Object)outputStream.toByteArray()).build();
                return response;
            }
            if (parameters.getFormat() == ReportFormat.CSV) {
                Response response = Response.ok().type("text/csv;charset=UTF-8").header("Content-disposition", (Object)"inline; filename=report.csv").header("Cache-Control", (Object)"cache").header("Cache-Control", (Object)"must-revalidate").entity((Object)outputStream.toByteArray()).build();
                return response;
            }
            Response response = ReportRestServiceImpl.createErrorResponse(Response.Status.BAD_REQUEST, this.createErrorObject("format", "Only PDF, SVG or CSV are supported"));
            return response;
        }
        catch (SchedulerContextException ex) {
            Response response = ReportRestServiceImpl.createErrorResponse(Response.Status.BAD_REQUEST, this.createErrorObject(ex.getContext(), ex.getRawMessage()));
            return response;
        }
        catch (ReportException ex) {
            Response response = ReportRestServiceImpl.createErrorResponse(Response.Status.BAD_REQUEST, this.createErrorObject((Exception)((Object)ex)));
            return response;
        }
        finally {
            IOUtils.closeQuietly((OutputStream)outputStream);
        }
    }

    @Override
    public Response listPersistedReports(UriInfo uriInfo) {
        QueryParameters queryParameters = QueryParametersBuilder.buildFrom((UriInfo)uriInfo);
        List persistedReports = this.reportStoreService.getPage(queryParameters.getOffset().intValue(), queryParameters.getLimit().intValue());
        if (persistedReports.isEmpty()) {
            return Response.noContent().build();
        }
        Map formatMap = this.reportStoreService.getFormatMap();
        JSONArray jsonArray = new JSONArray();
        for (ReportCatalogEntry eachEntry : persistedReports) {
            JSONObject jsonObject = new JSONObject((Object)eachEntry);
            List formats = (List)formatMap.get(eachEntry.getReportId());
            if (formats != null && !formats.isEmpty()) {
                jsonObject.put("formats", (Object)new JSONArray((Collection)formats));
            } else {
                String format = eachEntry.getLocation().substring(eachEntry.getLocation().lastIndexOf(".") + 1);
                JSONArray formatsArray = new JSONArray();
                formatsArray.put((Object)format.toUpperCase());
                jsonObject.put("formats", (Object)formatsArray);
            }
            jsonArray.put((Object)jsonObject);
        }
        return Response.ok().header("Content-Range", (Object)ResponseUtils.getContentRange((long)jsonArray.length(), (long)queryParameters.getOffset().intValue(), (long)this.reportStoreService.countAll())).entity((Object)jsonArray.toString()).type(MediaType.APPLICATION_JSON_TYPE).build();
    }

    @Override
    public Response deletePersistedReports() {
        Integer[] reportIdsToDelete = (Integer[])this.reportStoreService.getAll().stream().map(ReportCatalogEntry::getId).toArray(Integer[]::new);
        this.reportStoreService.delete(reportIdsToDelete);
        return Response.accepted().build();
    }

    @Override
    public Response deletePersistedReport(int id) {
        Optional<ReportCatalogEntry> any = this.reportStoreService.getAll().stream().filter(r -> r.getId() != null && r.getId() == id).findAny();
        if (any.isPresent()) {
            this.reportStoreService.delete(any.get().getId());
            return Response.accepted().build();
        }
        return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
    }

    @Override
    public Response listScheduledReports(UriInfo uriInfo) {
        List triggerDescriptions = this.schedulerService.getTriggerDescriptions();
        if (triggerDescriptions.isEmpty()) {
            return Response.noContent().build();
        }
        QueryParameters queryParameters = QueryParametersBuilder.buildFrom((UriInfo)uriInfo);
        List triggerDescriptionsForPage = queryParameters.getPage().apply(triggerDescriptions);
        JSONArray scheduledReports = new JSONArray();
        for (TriggerDescription eachDescription : triggerDescriptionsForPage) {
            scheduledReports.put((Object)new JSONObject((Object)eachDescription));
        }
        return Response.ok().header("Content-Range", (Object)ResponseUtils.getContentRange((long)scheduledReports.length(), (long)queryParameters.getOffset().intValue(), (long)triggerDescriptions.size())).entity((Object)scheduledReports.toString()).type(MediaType.APPLICATION_JSON_TYPE).build();
    }

    @Override
    public Response getSchedule(String triggerName) {
        Optional<TriggerDescription> any = this.schedulerService.getTriggerDescriptions().stream().filter(triggerDescription -> triggerDescription.getTriggerName().equals(triggerName)).findAny();
        if (any.isPresent()) {
            TriggerDescription triggerDescription2 = any.get();
            String reportId = triggerDescription2.getReportId();
            List formats = this.reportWrapperService.getFormats(reportId);
            Collection categories = this.categoryConfigDao.findAll();
            List surveillanceCategories = this.categoryDao.findAll();
            ReportParameters parameters = this.reportWrapperService.getParameters(reportId);
            ReportParameters persistedParameters = triggerDescription2.getReportParameters();
            parameters.apply(persistedParameters);
            ReportDetails reportDetails = new ReportDetailsBuilder().withReportId(triggerDescription2.getReportId()).withFormats(formats).withParameters(parameters).withCategories(categories).withSurveillanceCategories(surveillanceCategories).withDeliveryOptions(triggerDescription2.getDeliveryOptions()).withCronExpression(triggerDescription2.getCronExpression()).withDefaultTimezones().build();
            return Response.ok((Object)reportDetails.toJson().toString()).type(MediaType.APPLICATION_JSON_TYPE).build();
        }
        return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
    }

    @Override
    public Response updateSchedule(String triggerName, Map<String, Object> parameters) {
        Optional<TriggerDescription> any = this.schedulerService.getTriggerDescriptions().stream().filter(triggerDescription -> triggerDescription.getTriggerName().equals(triggerName)).findAny();
        if (any.isPresent()) {
            ReportParameters reportParameters = this.parseParameters(parameters, ReportMode.SCHEDULED);
            DeliveryOptions deliveryOptions = this.parseDeliveryOptions(parameters);
            ScheduleConfig scheduleConfig = new ScheduleConfig(reportParameters, deliveryOptions, (String)parameters.get("cronExpression"));
            try {
                this.schedulerService.updateCronTrigger(triggerName, scheduleConfig);
            }
            catch (SchedulerContextException ex) {
                return ReportRestServiceImpl.createErrorResponse(Response.Status.BAD_REQUEST, this.createErrorObject(ex.getContext(), ex.getRawMessage()));
            }
            catch (SchedulerException ex) {
                return ReportRestServiceImpl.createErrorResponse(Response.Status.BAD_REQUEST, this.createErrorObject((Exception)((Object)ex)));
            }
            return Response.accepted().build();
        }
        return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
    }

    private static Response createErrorResponse(Response.Status status, JSONObject errorObject) {
        Objects.requireNonNull(status);
        Objects.requireNonNull(errorObject);
        return Response.status((Response.Status)status).type(MediaType.APPLICATION_JSON_TYPE).entity((Object)errorObject.toString()).build();
    }

    @Override
    public Response deleteScheduledReports() {
        String[] triggersToDelete = (String[])this.schedulerService.getTriggerDescriptions().stream().map(TriggerDescription::getTriggerName).toArray(String[]::new);
        this.schedulerService.removeTriggers(triggersToDelete);
        return Response.accepted().build();
    }

    @Override
    public Response deleteScheduledReport(String triggerName) {
        if (this.schedulerService.exists(triggerName).booleanValue()) {
            this.schedulerService.removeTrigger(triggerName);
            return Response.accepted().build();
        }
        return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
    }

    @Override
    public Response downloadReport(String format, String locatorId) {
        boolean mustRender;
        if (Strings.isNullOrEmpty((String)locatorId)) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).type(MediaType.APPLICATION_JSON_TYPE).entity((Object)this.createErrorObject("entity", "Property 'locatorId' is null or empty").toString()).build();
        }
        Integer reportCatalogEntryId = WebSecurityUtils.safeParseInt((String)locatorId);
        ReportCatalogEntry reportCatalogEntry = (ReportCatalogEntry)this.reportCatalogDao.get((Serializable)reportCatalogEntryId);
        if (reportCatalogEntry == null) {
            return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
        }
        boolean bl = mustRender = reportCatalogEntry.getLocation().endsWith("jrprint") || reportCatalogEntry.getLocation().endsWith("xml");
        if (mustRender && Strings.isNullOrEmpty((String)format)) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).type(MediaType.APPLICATION_JSON_TYPE).entity((Object)this.createErrorObject("entity", "Property 'format' is null or empty").toString()).build();
        }
        try {
            String suffix = reportCatalogEntry.getLocation().substring(reportCatalogEntry.getLocation().lastIndexOf(".") + 1).toLowerCase();
            ReportFormat reportFormat = mustRender ? this.parseReportFormat(format) : this.parseReportFormat(suffix);
            Object filename = mustRender ? reportCatalogEntryId.toString() + "." + reportFormat.name().toLowerCase() : Paths.get(reportCatalogEntry.getLocation(), new String[0]).getFileName().toString();
            StreamingOutput streamingOutput = mustRender ? outputStream -> {
                this.reportStoreService.render(reportCatalogEntryId, reportFormat, outputStream);
                outputStream.flush();
            } : outputStream -> {
                try (FileInputStream input = new FileInputStream(new File(reportCatalogEntry.getLocation()));){
                    ByteStreams.copy((InputStream)input, (OutputStream)outputStream);
                }
                outputStream.flush();
            };
            Response.ResponseBuilder responseBuilder = Response.ok().header("Pragma", (Object)"public").header("Cache-Control", (Object)"cache").header("Cache-Control", (Object)"must-revalidate").entity((Object)streamingOutput);
            if (ReportFormat.PDF == reportFormat || ReportFormat.SVG == reportFormat) {
                return responseBuilder.type("application/pdf;charset=UTF-8").header("Content-disposition", (Object)("inline; filename=" + (String)filename)).build();
            }
            if (ReportFormat.HTML == reportFormat) {
                responseBuilder.type("text/html;charset=UTF-8").header("Content-disposition", (Object)("inline; filename=" + (String)filename));
            }
            if (ReportFormat.CSV == reportFormat) {
                responseBuilder.type("text/csv;charset=UTF-8").header("Content-disposition", (Object)("inline; filename=" + (String)filename));
            }
            return responseBuilder.build();
        }
        catch (NumberFormatException e) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).type(MediaType.APPLICATION_JSON_TYPE).entity((Object)this.createErrorObject(e).toString()).build();
        }
        catch (SchedulerContextException ex) {
            return ReportRestServiceImpl.createErrorResponse(Response.Status.BAD_REQUEST, this.createErrorObject(ex.getContext(), ex.getRawMessage()));
        }
    }

    private JSONObject createErrorObject(Exception exception) {
        return this.createErrorObject("entity", exception.getMessage());
    }

    private JSONObject createErrorObject(String context, String message) {
        JSONObject errorObject = new JSONObject().put("message", (Object)message).put("context", (Object)context);
        return errorObject;
    }

    ReportParameters parseParameters(Map<String, Object> inputParameters, ReportMode mode) {
        String reportId = (String)inputParameters.get("id");
        ReportParameters actualParameters = this.reportWrapperService.getParameters(reportId);
        ReportFormat reportFormat = this.parseReportFormat((String)inputParameters.get("format"));
        actualParameters.setReportId(reportId);
        actualParameters.setFormat(reportFormat);
        JSONObject jsonInputParameters = new JSONObject(inputParameters);
        ReportParameterBuilder reportParameterBuilder = new ReportParameterBuilder();
        JSONArray jsonParameters = jsonInputParameters.getJSONArray("parameters");
        for (int i = 0; i < jsonParameters.length(); ++i) {
            Object parameterValue;
            JSONObject jsonParameter = jsonParameters.getJSONObject(i);
            if (!jsonParameter.has("name") || !jsonParameter.has("type")) continue;
            String parameterName = jsonParameter.getString("name");
            String parameterType = jsonParameter.getString("type");
            Object object = parameterValue = jsonParameter.has("value") ? jsonParameter.get("value") : null;
            if (parameterType.equals("string")) {
                if (!(parameterValue instanceof String)) {
                    throw new SchedulerContextException(parameterName, "Provided value ''{0}'' is not a string.", new Object[]{parameterValue});
                }
                reportParameterBuilder.withString(parameterName, jsonParameter.getString("value"));
                continue;
            }
            if (parameterType.equals("double")) {
                Double doubleValue = ReportRestServiceImpl.parseDouble(parameterName, parameterValue);
                reportParameterBuilder.withDouble(parameterName, doubleValue);
                continue;
            }
            if (parameterType.equals("integer")) {
                Integer integerValue = ReportRestServiceImpl.parseInteger(parameterName, parameterValue);
                reportParameterBuilder.withInteger(parameterName, integerValue);
                continue;
            }
            if (parameterType.equals("float")) {
                Float floatValue = ReportRestServiceImpl.parseFloat(parameterName, parameterValue);
                reportParameterBuilder.withFloat(parameterName, floatValue);
                continue;
            }
            if (parameterType.equals("date")) {
                int hours = jsonParameter.has("hours") ? ReportRestServiceImpl.parseInteger(parameterName + "Hours", jsonParameter.get("hours")) : 0;
                int minutes = jsonParameter.has("minutes") ? ReportRestServiceImpl.parseInteger(parameterName + "Minutes", jsonParameter.get("minutes")) : 0;
                ReportDateParm actualDateParm = (ReportDateParm)actualParameters.getParameter(parameterName);
                if (actualDateParm.getUseAbsoluteDate().booleanValue() || mode == ReportMode.IMMEDIATE) {
                    if (!jsonParameter.has("date")) continue;
                    String dateString = jsonParameter.getString("date");
                    try {
                        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
                        TimeZone reportTimeZone = TimeZone.getTimeZone(this.getZoneFromParameters(jsonParameters));
                        sdf.setTimeZone(reportTimeZone);
                        LOG.debug("using time zone: {}", (Object)reportTimeZone);
                        Date parsedDate = sdf.parse(dateString);
                        LOG.debug("parsed date: {}", (Object)parsedDate);
                        Date adjusted = new Date(parsedDate.getTime() + Duration.of(hours, ChronoUnit.HOURS).toMillis() + Duration.of(minutes, ChronoUnit.MINUTES).toMillis());
                        LOG.debug("adjusted date: {}", (Object)adjusted);
                        reportParameterBuilder.withDate(parameterName, adjusted, hours, minutes, true);
                        continue;
                    }
                    catch (ParseException e) {
                        throw new SchedulerContextException(parameterName, "The provided value ''{0}'' cannot be parsed as a date. Expected format is yyyy-MM-dd", new Object[]{dateString});
                    }
                }
                String interval = jsonParameter.getString("interval");
                int count = jsonParameter.getInt("count");
                reportParameterBuilder.withDate(parameterName, interval, count, hours, minutes);
                continue;
            }
            if (parameterType.equals("timezone")) {
                ZoneId zoneId = ReportRestServiceImpl.parseTimezone(parameterName, jsonParameter.has("value") ? jsonParameter.getString("value") : "");
                reportParameterBuilder.withTimezone(parameterName, zoneId);
                continue;
            }
            throw new SchedulerContextException(parameterName, "Unknown type ''{0}''. Supported types are: ''{1}''", new Object[]{parameterType, Lists.newArrayList((Object[])new String[]{"string", "integer", "float", "double", "date"})});
        }
        ReportParameters mergeWithParameters = reportParameterBuilder.build();
        actualParameters.apply(mergeWithParameters);
        return actualParameters;
    }

    ZoneId getZoneFromParameters(JSONArray parameters) {
        ZoneId id = ZoneId.systemDefault();
        for (int i = 0; i < parameters.length(); ++i) {
            JSONObject parameter = parameters.getJSONObject(i);
            if (!parameter.has("name") || !parameter.has("type") || parameter.getString("type") != "timezone") continue;
            String name = parameter.getString("name");
            String value = parameter.has("value") ? parameter.getString("value") : "";
            id = ReportRestServiceImpl.parseTimezone(name, value);
        }
        return id;
    }

    private DeliveryOptions parseDeliveryOptions(Map<String, Object> parameters) {
        DeliveryOptions options = new DeliveryOptions();
        JSONObject jsonParameters = new JSONObject(parameters);
        JSONObject jsonOptions = jsonParameters.getJSONObject("deliveryOptions");
        options.setInstanceId(jsonOptions.getString("instanceId"));
        options.setSendMail(jsonOptions.getBoolean("sendMail"));
        if (options.isSendMail() && jsonOptions.has("mailTo")) {
            options.setMailTo(jsonOptions.getString("mailTo"));
        }
        if (jsonOptions.has("webhook")) {
            options.setWebhook(jsonOptions.getBoolean("webhook"));
        }
        if (options.isWebhook() && jsonOptions.has("webhookUrl")) {
            options.setWebhookUrl(jsonOptions.getString("webhookUrl"));
        }
        options.setPersist(jsonOptions.getBoolean("persist"));
        options.setFormat(this.parseReportFormat(jsonOptions.getString("format")));
        return options;
    }

    private ReportFormat parseReportFormat(String input) {
        if (Strings.isNullOrEmpty((String)input)) {
            throw new SchedulerContextException("format", "Please provide a value");
        }
        for (ReportFormat eachFormat : ReportFormat.values()) {
            if (!eachFormat.name().equalsIgnoreCase(input)) continue;
            return eachFormat;
        }
        throw new SchedulerContextException("format", "Provided format ''{0}'' is not supported", new Object[]{input});
    }

    private static Double parseDouble(String name, Object value) {
        if (value == null) {
            return null;
        }
        if (value instanceof String) {
            try {
                return Double.valueOf((String)value);
            }
            catch (NumberFormatException ex) {
                throw new SchedulerContextException(name, "Provided value ''{0}'' is not a floating number", new Object[]{value});
            }
        }
        if (value instanceof Number) {
            return ((Number)value).doubleValue();
        }
        throw new SchedulerContextException(name, "Provided value ''{0}'' must be of type string or double");
    }

    private static Integer parseInteger(String name, Object value) {
        if (value == null) {
            return null;
        }
        if (value instanceof String) {
            try {
                return Integer.valueOf((String)value);
            }
            catch (NumberFormatException ex) {
                throw new SchedulerContextException(name, "Provided value ''{0}'' is not an integer number", new Object[]{value});
            }
        }
        if (value instanceof Number) {
            return ((Number)value).intValue();
        }
        throw new SchedulerContextException(name, "Provided value ''{0}'' must be of type string or integer");
    }

    private static Float parseFloat(String name, Object value) {
        if (value == null) {
            return null;
        }
        if (value instanceof String) {
            try {
                return Float.valueOf((String)value);
            }
            catch (NumberFormatException ex) {
                throw new SchedulerContextException(name, "Provided value ''{0}'' is not a floating number", new Object[]{value});
            }
        }
        if (value instanceof Number) {
            return Float.valueOf(((Number)value).floatValue());
        }
        throw new SchedulerContextException(name, "Provided value ''{0}'' must be of type string or float");
    }

    private static ZoneId parseTimezone(String name, String timezoneValue) {
        try {
            return ZoneId.of(timezoneValue);
        }
        catch (DateTimeException e) {
            throw new SchedulerContextException(name, "Provided timezone ''{0}'' could not be parsed: ''{1}''.", new Object[]{timezoneValue, e.getMessage()});
        }
    }
}

