/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.export.pdf.classic;

import java.awt.Font;
import java.awt.font.TextAttribute;
import java.text.AttributedCharacterIterator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import net.sf.jasperreports.engine.JRPrintText;
import net.sf.jasperreports.engine.JRPropertiesUtil;
import net.sf.jasperreports.engine.export.AbstractPdfTextRenderer;
import net.sf.jasperreports.engine.export.PdfGlyphRenderer;
import net.sf.jasperreports.engine.fonts.AwtFontAttribute;
import net.sf.jasperreports.engine.util.JRStyledText;
import net.sf.jasperreports.export.pdf.PdfProducerContext;
import net.sf.jasperreports.export.pdf.classic.ClassicPdfProducer;
import net.sf.jasperreports.export.type.PdfVersionEnum;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.opennms.shaded.jasper.com.lowagie.text.pdf.BaseFont;

public class GlyphRendering {
    private static final Log log = LogFactory.getLog(GlyphRendering.class);
    private ClassicPdfProducer pdfProducer;
    private Set<Character.UnicodeBlock> glyphRendererBlocks;
    private boolean glyphRendererAddActualText;
    private Map<FontKey, Boolean> glyphRendererFonts;

    public GlyphRendering(ClassicPdfProducer pdfProducer) {
        this.pdfProducer = pdfProducer;
        this.glyphRendererFonts = new HashMap<FontKey, Boolean>();
        PdfProducerContext context = pdfProducer.getContext();
        this.glyphRendererAddActualText = context.getProperties().getBooleanProperty("net.sf.jasperreports.export.pdf.glyph.renderer.add.actual.text", false);
        if (this.glyphRendererAddActualText && !context.isTagged() && PdfGlyphRenderer.supported()) {
            context.setMinimalVersion(PdfVersionEnum.VERSION_1_5);
        }
    }

    protected void initGlyphRenderer() {
        this.glyphRendererBlocks = new HashSet<Character.UnicodeBlock>();
        PdfProducerContext context = this.pdfProducer.getContext();
        List<JRPropertiesUtil.PropertySuffix> props = context.getProperties().getAllProperties(context.getCurrentJasperPrint(), "net.sf.jasperreports.export.pdf.glyph.renderer.blocks.");
        for (JRPropertiesUtil.PropertySuffix prop : props) {
            String blocks = prop.getValue();
            for (String blockToken : blocks.split(",")) {
                Character.UnicodeBlock block = this.resolveUnicodeBlock(blockToken);
                if (block == null) continue;
                if (log.isDebugEnabled()) {
                    log.debug((Object)("glyph renderer block " + block));
                }
                this.glyphRendererBlocks.add(block);
            }
        }
    }

    protected Character.UnicodeBlock resolveUnicodeBlock(String name) {
        if (name.trim().isEmpty()) {
            return null;
        }
        try {
            return Character.UnicodeBlock.forName(name.trim());
        }
        catch (IllegalArgumentException e) {
            log.warn((Object)("Could not resolve \"" + name + "\" to a Unicode block"));
            return null;
        }
    }

    public AbstractPdfTextRenderer getGlyphTextRenderer(JRPrintText text, JRStyledText styledText, Locale textLocale, boolean awtIgnoreMissingFont, boolean defaultIndentFirstLine, boolean defaultJustifyLastLine) {
        if (this.toUseGlyphRenderer(text) && PdfGlyphRenderer.supported() && this.canUseGlyphRendering(text, styledText, textLocale, awtIgnoreMissingFont)) {
            PdfProducerContext context = this.pdfProducer.getContext();
            PdfGlyphRenderer textRenderer = new PdfGlyphRenderer(context.getJasperReportsContext(), awtIgnoreMissingFont, defaultIndentFirstLine, defaultJustifyLastLine, this.glyphRendererAddActualText);
            return textRenderer;
        }
        return null;
    }

    protected boolean canUseGlyphRendering(JRPrintText text, JRStyledText styledText, Locale locale, boolean awtIgnoreMissingFont) {
        AttributedCharacterIterator attributesIterator = styledText.getAttributedString().getIterator();
        int index = 0;
        while (index < styledText.length()) {
            FontKey fontKey = this.extractFontKey(attributesIterator.getAttributes(), locale);
            if (!fontKey.fontAttribute.hasAttribute()) {
                return false;
            }
            Boolean canUse = this.glyphRendererFonts.get(fontKey);
            if (canUse == null) {
                canUse = this.canUseGlyphRendering(fontKey, awtIgnoreMissingFont);
                this.glyphRendererFonts.put(fontKey, canUse);
            }
            if (!canUse.booleanValue()) {
                return false;
            }
            index = attributesIterator.getRunLimit();
            attributesIterator.setIndex(index);
        }
        return true;
    }

    protected FontKey extractFontKey(Map<AttributedCharacterIterator.Attribute, Object> attributes, Locale locale) {
        AwtFontAttribute fontAttribute = AwtFontAttribute.fromAttributes(attributes);
        Number posture = (Number)attributes.get(TextAttribute.POSTURE);
        boolean italic = TextAttribute.POSTURE_OBLIQUE.equals(posture);
        Number weight = (Number)attributes.get(TextAttribute.WEIGHT);
        boolean bold = TextAttribute.WEIGHT_BOLD.equals(weight);
        return new FontKey(fontAttribute, italic, bold, locale);
    }

    protected boolean canUseGlyphRendering(FontKey fontKey, boolean awtIgnoreMissingFont) {
        org.opennms.shaded.jasper.com.lowagie.text.Font pdfFont;
        BaseFont baseFont;
        HashMap<AttributedCharacterIterator.Attribute, Object> fontAttributes = new HashMap<AttributedCharacterIterator.Attribute, Object>();
        fontKey.fontAttribute.putAttributes(fontAttributes);
        fontAttributes.put(TextAttribute.SIZE, Float.valueOf(10.0f));
        int style = 0;
        if (fontKey.italic) {
            style |= 2;
            fontAttributes.put(TextAttribute.POSTURE, TextAttribute.POSTURE_OBLIQUE);
        }
        if (fontKey.bold) {
            style |= 1;
            fontAttributes.put(TextAttribute.WEIGHT, TextAttribute.WEIGHT_BOLD);
        }
        if ((baseFont = (pdfFont = this.pdfProducer.getFont(fontAttributes, fontKey.locale)).getBaseFont()).getFontType() != 3 || baseFont.isFontSpecific()) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("pdf font for " + fontKey + " has type " + baseFont.getFontType() + ", symbol " + baseFont.isFontSpecific() + ", cannot use glyph rendering"));
            }
            return false;
        }
        Font awtFont = this.pdfProducer.getContext().getFontUtil().getAwtFontFromBundles(fontKey.fontAttribute, style, 10.0f, fontKey.locale, awtIgnoreMissingFont);
        if (awtFont == null) {
            awtFont = new Font(fontAttributes);
        }
        String awtFontName = awtFont.getFontName();
        if (log.isDebugEnabled()) {
            log.debug((Object)(fontKey + " resolved to awt font " + awtFontName));
        }
        String[][] pdfFontNames = baseFont.getFullFontName();
        boolean nameMatch = false;
        for (String[] nameArray : pdfFontNames) {
            if (nameArray.length < 4) continue;
            if (log.isDebugEnabled()) {
                log.debug((Object)(fontKey + " resolved to pdf font " + nameArray[3]));
            }
            if (!awtFontName.equals(nameArray[3])) continue;
            nameMatch = true;
            break;
        }
        return nameMatch;
    }

    public boolean toUseGlyphRenderer(JRPrintText text) {
        String value = this.pdfProducer.getContext().getStyledTextUtil().getTruncatedText(text);
        if (value == null) {
            return false;
        }
        if (this.glyphRendererBlocks.isEmpty()) {
            return false;
        }
        int charCount = value.length();
        char[] chars = new char[charCount];
        value.getChars(0, charCount, chars, 0);
        for (char c : chars) {
            Character.UnicodeBlock block = Character.UnicodeBlock.of(c);
            if (!this.glyphRendererBlocks.contains(block)) continue;
            if (log.isTraceEnabled()) {
                log.trace((Object)("found character in block " + block + ", using the glyph renderer"));
            }
            return true;
        }
        return false;
    }

    protected static class FontKey {
        AwtFontAttribute fontAttribute;
        boolean italic;
        boolean bold;
        Locale locale;

        public FontKey(AwtFontAttribute fontAttribute, boolean italic, boolean bold, Locale locale) {
            this.fontAttribute = fontAttribute;
            this.italic = italic;
            this.bold = bold;
            this.locale = locale;
        }

        public int hashCode() {
            int hash = 43;
            hash = hash * 29 + this.fontAttribute.hashCode();
            hash = hash * 29 + (this.italic ? 1231 : 1237);
            hash = hash * 29 + (this.bold ? 1231 : 1237);
            hash = hash * 29 + (this.locale == null ? 0 : this.locale.hashCode());
            return hash;
        }

        public boolean equals(Object obj) {
            FontKey key = (FontKey)obj;
            return this.fontAttribute.equals(key.fontAttribute) && this.italic == key.italic && this.bold == key.bold && (this.locale == null ? key.locale == null : key.locale != null && this.locale.equals(key.locale));
        }

        public String toString() {
            return "{font: " + this.fontAttribute + ", italic: " + this.italic + ", bold: " + this.bold + "}";
        }
    }
}

