/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.export.pdf.classic;

import java.io.IOException;
import net.sf.jasperreports.engine.JRRuntimeException;
import net.sf.jasperreports.engine.export.type.PdfFieldTypeEnum;
import net.sf.jasperreports.export.pdf.PdfTextField;
import net.sf.jasperreports.export.pdf.classic.ClassicPdfField;
import net.sf.jasperreports.export.pdf.classic.ClassicPdfProducer;
import org.opennms.shaded.jasper.com.lowagie.text.DocumentException;
import org.opennms.shaded.jasper.com.lowagie.text.pdf.PdfFormField;
import org.opennms.shaded.jasper.com.lowagie.text.pdf.TextField;

public class ClassicPdfTextField
extends ClassicPdfField
implements PdfTextField {
    private TextField textField;
    private PdfFieldTypeEnum fieldType;

    public ClassicPdfTextField(ClassicPdfProducer pdfProducer, TextField textField, PdfFieldTypeEnum fieldType) {
        super(pdfProducer, textField);
        this.textField = textField;
        this.fieldType = fieldType;
    }

    @Override
    public void setEdit() {
        this.textField.setOptions(this.textField.getOptions() | 0x40000);
    }

    @Override
    public void setMultiline() {
        this.textField.setOptions(this.textField.getOptions() | 0x1000);
    }

    @Override
    public void add() {
        try {
            PdfFormField field = this.fieldType == PdfFieldTypeEnum.COMBO ? this.textField.getComboField() : (this.fieldType == PdfFieldTypeEnum.LIST ? this.textField.getListField() : this.textField.getTextField());
            this.pdfProducer.getPdfWriter().addAnnotation(field);
        }
        catch (IOException | DocumentException e) {
            throw new JRRuntimeException(e);
        }
    }
}

