/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.features.config.dao.impl.util;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.dataformat.yaml.YAMLFactory;
import io.swagger.v3.core.util.Json;
import io.swagger.v3.core.util.Yaml;
import io.swagger.v3.oas.models.Components;
import io.swagger.v3.oas.models.OpenAPI;
import io.swagger.v3.oas.models.Operation;
import io.swagger.v3.oas.models.PathItem;
import io.swagger.v3.oas.models.Paths;
import io.swagger.v3.oas.models.info.Info;
import io.swagger.v3.oas.models.media.ArraySchema;
import io.swagger.v3.oas.models.media.BooleanSchema;
import io.swagger.v3.oas.models.media.Content;
import io.swagger.v3.oas.models.media.DateSchema;
import io.swagger.v3.oas.models.media.DateTimeSchema;
import io.swagger.v3.oas.models.media.IntegerSchema;
import io.swagger.v3.oas.models.media.MediaType;
import io.swagger.v3.oas.models.media.NumberSchema;
import io.swagger.v3.oas.models.media.ObjectSchema;
import io.swagger.v3.oas.models.media.Schema;
import io.swagger.v3.oas.models.media.StringSchema;
import io.swagger.v3.oas.models.parameters.Parameter;
import io.swagger.v3.oas.models.parameters.PathParameter;
import io.swagger.v3.oas.models.parameters.QueryParameter;
import io.swagger.v3.oas.models.parameters.RequestBody;
import io.swagger.v3.oas.models.responses.ApiResponse;
import io.swagger.v3.oas.models.responses.ApiResponses;
import io.swagger.v3.oas.models.servers.Server;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.stream.Collectors;
import org.opennms.features.config.dao.api.ConfigItem;
import org.opennms.features.config.exception.SchemaConversionException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConfigSwaggerConverter {
    public static final String APPLICATION_JSON = "application/json";
    public static final String SCHEMA_PATH = "#/components/schemas/";
    public static final String REMOTE_REF_PATH = "/opennms/rest/cm/schema/";
    private final Logger LOG = LoggerFactory.getLogger(ConfigSwaggerConverter.class);
    private final Map<ConfigItem, Schema<?>> schemasByItem = new LinkedHashMap();
    private final Map<ConfigItem, String> pathsByItem = new LinkedHashMap<ConfigItem, String>();
    private final Map<String, PathItem> pathItemsByPath = new LinkedHashMap<String, PathItem>();
    private final OpenAPI openAPI = new OpenAPI();

    public String convertToString(ConfigItem item, String prefix, String acceptType) throws SchemaConversionException {
        OpenAPI openapi = this.convert(item, prefix);
        return this.convertOpenAPIToString(openapi, acceptType);
    }

    public String convertOpenAPIToString(OpenAPI openapi, String acceptType) throws SchemaConversionException {
        ObjectMapper objectMapper;
        try {
            objectMapper = APPLICATION_JSON.equals(acceptType) ? Json.mapper() : Yaml.mapper();
        }
        catch (Exception e) {
            this.LOG.warn("UNKNOWN MediaType: {} error: {} using media type = yaml instead.", (Object)acceptType, (Object)e.getMessage());
            objectMapper = new ObjectMapper((JsonFactory)new YAMLFactory());
        }
        objectMapper.setSerializationInclusion(JsonInclude.Include.NON_NULL);
        try {
            return objectMapper.writeValueAsString((Object)openapi);
        }
        catch (JsonProcessingException e) {
            throw new SchemaConversionException("Fail to convertOpenAPIToString. ", (Throwable)e);
        }
    }

    private Info genInfo() {
        Info info = new Info();
        info.setDescription("OpenNMS Data Model");
        info.setVersion("1.0.0");
        info.setTitle("OpenNMS Model");
        return info;
    }

    public static OpenAPI setupServers(OpenAPI openapi, List<String> urls) {
        List servers = urls.stream().map(url -> {
            Server server = new Server();
            server.setUrl(url);
            return server;
        }).collect(Collectors.toList());
        openapi.setServers(servers);
        return openapi;
    }

    public OpenAPI mergeAllPathsWithRemoteRef(Map<String, OpenAPI> openapiMap, String prefix) {
        OpenAPI allApi = new OpenAPI();
        allApi.setInfo(this.genInfo());
        allApi.setPaths(new Paths());
        openapiMap.forEach((configName, openapi) -> {
            Paths paths = openapi.getPaths();
            paths.forEach((name, path) -> {
                if (path.readOperations() == null) {
                    return;
                }
                path.readOperations().forEach(oper -> {
                    if (oper.getResponses() != null) {
                        oper.getResponses().forEach((resK, resV) -> {
                            if (resV.getContent() != null) {
                                resV.getContent().forEach((ck, cv) -> {
                                    if (cv.getSchema().get$ref() != null) {
                                        cv.getSchema().set$ref(prefix + "/schema/" + configName + cv.getSchema().get$ref());
                                    }
                                });
                            }
                        });
                    }
                    if (oper.getRequestBody() != null && oper.getRequestBody().getContent() != null) {
                        oper.getRequestBody().getContent().forEach((ck, cv) -> {
                            if (cv.getSchema().get$ref() != null) {
                                cv.getSchema().set$ref(prefix + "/schema/" + configName + cv.getSchema().get$ref());
                            }
                        });
                    }
                });
                allApi.getPaths().putIfAbsent(name, path);
            });
        });
        return allApi;
    }

    public OpenAPI convert(ConfigItem item, String prefix) {
        return this.convert(item, prefix, false);
    }

    public OpenAPI convert(ConfigItem item, String prefix, boolean isSingleConfig) {
        Components components = new Components();
        this.openAPI.setComponents(components);
        Info info = this.genInfo();
        this.openAPI.setInfo(info);
        this.walk(null, item, this::generateSchemasForItems);
        this.schemasByItem.forEach((k, v) -> {
            if (ConfigItem.Type.OBJECT.equals((Object)k.getType())) {
                components.addSchemas(v.getName(), v);
            }
        });
        if (prefix != null) {
            Paths paths = new Paths();
            this.openAPI.setPaths(paths);
            this.generatePathsForItems(item, prefix, null, isSingleConfig);
            this.pathItemsByPath.forEach((arg_0, arg_1) -> ((Paths)paths).addPathItem(arg_0, arg_1));
        }
        return this.openAPI;
    }

    private void generatePathsForItems(ConfigItem item, String prefix, String externalConfigName, boolean isSingleConfig) {
        String path = prefix;
        this.pathsByItem.put(item, path);
        Schema schemaForCurrentItem = new Schema();
        schemaForCurrentItem.setName(item.getName());
        schemaForCurrentItem.set$ref(this.generate$ref(item, externalConfigName));
        PathItem configNamePathItem = new PathItem();
        PathItem configIdPathItem = new PathItem();
        String tagName = this.getTagName(path, prefix);
        Content jsonObjectContent = new Content();
        MediaType mediaType = new MediaType();
        mediaType.schema(schemaForCurrentItem);
        jsonObjectContent.addMediaType(APPLICATION_JSON, mediaType);
        Content configIdContent = new Content();
        MediaType configIdMediaType = new MediaType();
        ArraySchema configIdParent = new ArraySchema();
        StringSchema configIdSchema = new StringSchema();
        configIdParent.setItems((Schema)configIdSchema);
        configIdMediaType.schema((Schema)configIdParent);
        configIdContent.addMediaType(APPLICATION_JSON, configIdMediaType);
        ArrayList<Parameter> parameters = new ArrayList<Parameter>();
        PathParameter configIdParam = new PathParameter();
        configIdParam.setName("configId");
        configIdParam.setRequired(Boolean.valueOf(true));
        configIdParam.setSchema((Schema)new StringSchema());
        parameters.add((Parameter)configIdParam);
        if (!isSingleConfig) {
            Operation post = this.generateOperation(tagName, "Add " + item.getName() + " configuration", "empty", parameters, jsonObjectContent, null);
            configIdPathItem.setPost(post);
        }
        ArrayList<Parameter> putParameters = new ArrayList<Parameter>();
        if (!isSingleConfig) {
            putParameters.addAll(parameters);
        }
        QueryParameter replaceParameter = new QueryParameter();
        replaceParameter.setName("replace");
        replaceParameter.setSchema((Schema)new BooleanSchema());
        replaceParameter.setDescription("Set to true for replace the whole config");
        putParameters.add((Parameter)replaceParameter);
        Operation put = this.generateOperation(tagName, "Overwrite " + item.getName() + " configuration", "OK", isSingleConfig ? null : putParameters, jsonObjectContent, null);
        configIdPathItem.setPut(put);
        Operation get = this.generateOperation(tagName, "Get " + item.getName() + " configuration", item.getName() + " configuration", isSingleConfig ? null : parameters, null, jsonObjectContent);
        configIdPathItem.setGet(get);
        Operation getConfigIds = this.generateOperation(tagName, "Get " + item.getName() + " configIds", "configIds", null, null, configIdContent);
        configNamePathItem.setGet(getConfigIds);
        if (!isSingleConfig) {
            Operation delete = this.generateOperation(tagName, "Delete " + item.getName() + " configuration", item.getName() + " configuration", parameters, null, null);
            configIdPathItem.setDelete(delete);
        }
        if (!isSingleConfig) {
            this.pathItemsByPath.put(path, configNamePathItem);
            this.pathItemsByPath.put(path + "/{configId}", configIdPathItem);
        } else {
            this.pathItemsByPath.put(path + "/default", configIdPathItem);
        }
    }

    private Operation generateOperation(String tagName, String summary, String description, List<Parameter> parameters, Content requestContent, Content responseContent) {
        Operation operation = new Operation();
        operation.tags(Arrays.asList(tagName));
        operation.summary(summary);
        if (parameters != null) {
            operation.parameters(parameters);
        }
        if (requestContent != null) {
            RequestBody requestBody = new RequestBody();
            requestBody.setContent(requestContent);
            operation.requestBody(requestBody);
        }
        ApiResponses apiResponses = new ApiResponses();
        ApiResponse apiResponse = new ApiResponse();
        if (responseContent != null) {
            apiResponse.setDescription(description);
            apiResponse.setContent(responseContent);
        } else {
            apiResponse.setDescription("empty");
        }
        apiResponses.addApiResponse("200", apiResponse);
        HashMap properties = new HashMap();
        StringSchema errorMessageSchema = new StringSchema();
        properties.put("message", (Schema<?>)errorMessageSchema);
        apiResponses.addApiResponse("400", this.getSimpleObjectResponse("Error message", properties));
        operation.responses(apiResponses);
        return operation;
    }

    private ApiResponse getSimpleObjectResponse(String description, Map<String, Schema<?>> properties) {
        ApiResponse messageResponse = new ApiResponse();
        messageResponse.setDescription(description);
        Content messageContent = new Content();
        messageResponse.setContent(messageContent);
        MediaType mediaType = new MediaType();
        messageContent.addMediaType(APPLICATION_JSON, mediaType);
        ObjectSchema parentSchema = new ObjectSchema();
        mediaType.schema((Schema)parentSchema);
        properties.forEach((arg_0, arg_1) -> ((ObjectSchema)parentSchema).addProperties(arg_0, arg_1));
        return messageResponse;
    }

    private String getTagName(String path, String prefix) {
        String relevantPath = path.replace(prefix, "");
        if (relevantPath.isEmpty()) {
            String[] prefixElements = path.split("/");
            return prefixElements[prefixElements.length - 1];
        }
        String[] pathElements = relevantPath.split("/");
        if (pathElements.length < 2) {
            return relevantPath;
        }
        return pathElements[1];
    }

    private void generateSchemasForItems(ConfigItem parent, ConfigItem item) {
        ObjectSchema schema;
        switch (item.getType()) {
            case OBJECT: {
                schema = new ObjectSchema();
                break;
            }
            case ARRAY: {
                schema = new ArraySchema();
                break;
            }
            case STRING: {
                schema = new StringSchema();
                break;
            }
            case NUMBER: {
                schema = new NumberSchema();
                break;
            }
            case INTEGER: {
                schema = new IntegerSchema();
                break;
            }
            case LONG: {
                schema = new NumberSchema();
                schema.setFormat("int64");
                break;
            }
            case BOOLEAN: {
                schema = new BooleanSchema();
                break;
            }
            case POSITIVE_INTEGER: {
                schema = new IntegerSchema();
                schema.setMinimum(new BigDecimal(1));
                break;
            }
            case NON_NEGATIVE_INTEGER: {
                schema = new IntegerSchema();
                schema.setMinimum(new BigDecimal(0));
                break;
            }
            case NEGATIVE_INTEGER: {
                schema = new IntegerSchema();
                schema.setMaximum(new BigDecimal(-1));
                break;
            }
            case DATE_TIME: {
                schema = new DateTimeSchema();
                break;
            }
            case DATE: {
                schema = new DateSchema();
                break;
            }
            default: {
                throw new SchemaConversionException("Unsupported type " + item);
            }
        }
        schema.setName(item.getName());
        if (item.getDocumentation() != null && !"".equals(item.getDocumentation().trim())) {
            schema.setDescription(item.getDocumentation());
        }
        if (item.getPattern() != null) {
            schema.setPattern(item.getPattern());
        }
        if (item.getMultipleOf() != null && (schema instanceof NumberSchema || schema instanceof IntegerSchema)) {
            schema.setMultipleOf(BigDecimal.valueOf(item.getMultipleOf()));
        }
        if (item.getMin() != null) {
            if (schema instanceof StringSchema) {
                schema.setMinLength(Integer.valueOf(Math.toIntExact(item.getMin())));
            } else if (schema instanceof ArraySchema) {
                schema.setMinItems(Integer.valueOf(Math.toIntExact(item.getMin())));
            } else {
                schema.setMinimum(BigDecimal.valueOf(item.getMin()));
            }
        }
        if (item.getMax() != null) {
            if (schema instanceof StringSchema) {
                schema.setMaxLength(Integer.valueOf(Math.toIntExact(item.getMax())));
            } else if (schema instanceof ArraySchema) {
                schema.setMaxItems(Integer.valueOf(Math.toIntExact(item.getMax())));
            } else {
                schema.setMaximum(BigDecimal.valueOf(item.getMax()));
            }
        }
        if (item.isMinExclusive()) {
            schema.setExclusiveMinimum(Boolean.valueOf(true));
        }
        if (item.isMaxExclusive()) {
            schema.setExclusiveMaximum(Boolean.valueOf(true));
        }
        if (item.getDefaultValue() != null) {
            schema.setDefault(item.getDefaultValue());
        }
        if (item.getEnumValues() != null) {
            if (schema instanceof StringSchema) {
                ((StringSchema)schema).setEnum(item.getEnumValues());
            } else if (schema instanceof IntegerSchema || schema instanceof NumberSchema) {
                try {
                    List tmp = item.getEnumValues().stream().map(BigDecimal::new).collect(Collectors.toList());
                    ((NumberSchema)schema).setEnum(tmp);
                }
                catch (NumberFormatException e) {
                    throw new SchemaConversionException("Fail to convert enum values to Number.", (Throwable)e);
                }
            }
        }
        if (parent != null) {
            Schema<?> schemaForParent = this.schemasByItem.get(parent);
            ObjectSchema schemaForCurrentItem = schema;
            if (ConfigItem.Type.OBJECT.equals((Object)item.getType())) {
                schemaForCurrentItem = new Schema();
                schemaForCurrentItem.setName(schema.getName());
                schemaForCurrentItem.set$ref(this.generate$ref(item));
            }
            if (ConfigItem.Type.ARRAY.equals((Object)parent.getType())) {
                ((ArraySchema)schemaForParent).setItems((Schema)schemaForCurrentItem);
            } else {
                schemaForParent.addProperties(schemaForCurrentItem.getName(), (Schema)schemaForCurrentItem);
                if (item.isRequired()) {
                    schemaForParent.addRequiredItem(schemaForCurrentItem.getName());
                }
            }
        }
        this.schemasByItem.put(item, (Schema<?>)schema);
    }

    private String generate$ref(ConfigItem item) {
        return this.generate$ref(item, null);
    }

    private String generate$ref(ConfigItem item, String configName) {
        if (configName != null) {
            return REMOTE_REF_PATH + configName + SCHEMA_PATH + item.getName();
        }
        return SCHEMA_PATH + item.getName();
    }

    public void walk(ConfigItem parent, ConfigItem item, BiConsumer<ConfigItem, ConfigItem> consumer) {
        consumer.accept(parent, item);
        for (ConfigItem childItem : item.getChildren()) {
            this.walk(item, childItem, consumer);
        }
    }
}

