/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.newts.persistence.cassandra;

import com.datastax.oss.driver.api.core.cql.AsyncResultSet;
import com.datastax.oss.driver.api.core.cql.Row;
import com.google.common.base.Function;
import com.google.common.base.Throwables;
import com.google.common.collect.Iterators;
import java.util.Collection;
import java.util.Iterator;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.atomic.AtomicReference;

public class ConcurrentResultWrapper
implements Iterator<Row> {
    private Iterator<Row> m_rowIter;

    public ConcurrentResultWrapper(Collection<CompletionStage<AsyncResultSet>> futures) {
        this.m_rowIter = Iterators.concat(this.getIterators(futures));
    }

    private Iterator<Iterator<Row>> getIterators(Collection<CompletionStage<AsyncResultSet>> futures) {
        return Iterators.transform(futures.iterator(), (Function)new Function<CompletionStage<AsyncResultSet>, Iterator<Row>>(){

            public Iterator<Row> apply(CompletionStage<AsyncResultSet> input) {
                try {
                    return ConcurrentResultWrapper.this.toBlockingIterator(input.toCompletableFuture().get());
                }
                catch (InterruptedException | ExecutionException e) {
                    throw Throwables.propagate((Throwable)e);
                }
            }
        });
    }

    public Iterator<Row> toBlockingIterator(final AsyncResultSet rs) {
        final AtomicReference currentPageRef = new AtomicReference(rs.currentPage().iterator());
        return new Iterator<Row>(){

            @Override
            public boolean hasNext() {
                Iterator currentPage = (Iterator)currentPageRef.get();
                if (!currentPage.hasNext() && rs.hasMorePages()) {
                    try {
                        currentPageRef.set(((AsyncResultSet)rs.fetchNextPage().toCompletableFuture().get()).currentPage().iterator());
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
                return currentPage.hasNext();
            }

            @Override
            public Row next() {
                return (Row)((Iterator)currentPageRef.get()).next();
            }
        };
    }

    @Override
    public boolean hasNext() {
        return this.m_rowIter.hasNext();
    }

    @Override
    public Row next() {
        return this.m_rowIter.next();
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }
}

