/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.collection;

import java.net.InetAddress;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.opennms.core.utils.InetAddressUtils;
import org.opennms.netmgt.collection.api.CollectionAgent;
import org.opennms.netmgt.collection.api.CollectionAgentFactory;
import org.opennms.netmgt.collection.api.CollectionSet;
import org.opennms.netmgt.collection.api.CollectionSetVisitor;
import org.opennms.netmgt.collection.api.PersisterFactory;
import org.opennms.netmgt.collection.api.ServiceParameters;
import org.opennms.netmgt.collection.dto.CollectionSetDTO;
import org.opennms.netmgt.collection.support.builder.CollectionSetBuilder;
import org.opennms.netmgt.collection.support.builder.DeferredGenericTypeResource;
import org.opennms.netmgt.collection.support.builder.GenericTypeResource;
import org.opennms.netmgt.collection.support.builder.InterfaceLevelResource;
import org.opennms.netmgt.collection.support.builder.NodeLevelResource;
import org.opennms.netmgt.collection.support.builder.Resource;
import org.opennms.netmgt.config.api.EventConfDao;
import org.opennms.netmgt.dao.api.IpInterfaceDao;
import org.opennms.netmgt.dao.api.SnmpInterfaceDao;
import org.opennms.netmgt.events.api.EventListener;
import org.opennms.netmgt.events.api.EventSubscriptionService;
import org.opennms.netmgt.events.api.model.IEvent;
import org.opennms.netmgt.events.api.model.IParm;
import org.opennms.netmgt.model.OnmsIpInterface;
import org.opennms.netmgt.model.OnmsSnmpInterface;
import org.opennms.netmgt.rrd.RrdRepository;
import org.opennms.netmgt.threshd.api.ThresholdInitializationException;
import org.opennms.netmgt.threshd.api.ThresholdingService;
import org.opennms.netmgt.threshd.api.ThresholdingSession;
import org.opennms.netmgt.xml.eventconf.CollectionGroup;
import org.opennms.netmgt.xml.eventconf.Event;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EventMetricsCollector
implements EventListener {
    private static final Logger LOG = LoggerFactory.getLogger(EventMetricsCollector.class);
    public static final int NAME_MAX_LENGTH = 19;
    public static final String NODE_SNMP = "nodeSnmp";
    public static final String INTERFACE_SNMP = "interfaceSnmp";
    private final EventSubscriptionService eventSubscriptionService;
    private final EventConfDao eventConfDao;
    private final PersisterFactory persisterFactory;
    private final IpInterfaceDao ipInterfaceDao;
    private final SnmpInterfaceDao snmpInterfaceDao;
    private final CollectionAgentFactory collectionAgentFactory;
    private final ThresholdingService thresholdingService;

    public EventMetricsCollector(EventConfDao eventConfDao, EventSubscriptionService eventSubscriptionService, PersisterFactory persisterFactory, IpInterfaceDao ipInterfaceDao, SnmpInterfaceDao snmpInterfaceDao, CollectionAgentFactory collectionAgentFactory, ThresholdingService thresholdingService) {
        this.eventConfDao = Objects.requireNonNull(eventConfDao);
        this.eventSubscriptionService = Objects.requireNonNull(eventSubscriptionService);
        this.persisterFactory = Objects.requireNonNull(persisterFactory);
        this.ipInterfaceDao = Objects.requireNonNull(ipInterfaceDao);
        this.snmpInterfaceDao = Objects.requireNonNull(snmpInterfaceDao);
        this.collectionAgentFactory = Objects.requireNonNull(collectionAgentFactory);
        this.thresholdingService = Objects.requireNonNull(thresholdingService);
    }

    public void start() {
        this.eventSubscriptionService.addEventListener((EventListener)this);
    }

    public void stop() {
        this.eventSubscriptionService.removeEventListener((EventListener)this);
    }

    public String getName() {
        return this.getClass().getSimpleName();
    }

    public void onEvent(IEvent e) {
        Event eventconf = this.eventConfDao.findByUei(e.getUei());
        if (eventconf == null || eventconf.getCollectionGroup() == null || eventconf.getCollectionGroup().isEmpty()) {
            return;
        }
        List collectionGroups = eventconf.getCollectionGroup();
        OnmsIpInterface iface = this.ipInterfaceDao.findByNodeIdAndIpAddress(Integer.valueOf(e.getNodeid().intValue()), InetAddressUtils.str((InetAddress)e.getInterfaceAddress()));
        CollectionAgent agent = this.collectionAgentFactory.createCollectionAgent(iface);
        for (CollectionGroup collectionGroup : collectionGroups) {
            CollectionSetBuilder collectionSetBuilder = this.createCollectionSetBuilder(collectionGroup, e, iface, agent);
            if (collectionSetBuilder == null) continue;
            if (collectionGroup.getRrd() != null) {
                CollectionSetDTO collectionSet = collectionSetBuilder.build();
                this.handleThresholding((CollectionSet)collectionSet, agent);
                collectionSet.visit(this.createRrdPersister(collectionGroup.getRrd()));
                continue;
            }
            LOG.warn("Missing rrd config. {}", (Object)collectionGroup);
        }
    }

    private void handleThresholding(CollectionSet collectionSet, CollectionAgent agent) {
        try {
            int nodeId = agent.getNodeId();
            String hostAddress = agent.getHostAddress();
            ThresholdingSession session = this.thresholdingService.createSession(nodeId, hostAddress, EventMetricsCollector.class.getSimpleName(), new ServiceParameters(Collections.emptyMap()));
            session.accept(collectionSet);
        }
        catch (NullPointerException | ThresholdInitializationException e) {
            LOG.warn("FAIL to initialize Thresholding. Error: {}", (Object)e.getMessage());
        }
    }

    private CollectionSetBuilder createCollectionSetBuilder(CollectionGroup collectionGroup, IEvent e, OnmsIpInterface iface, CollectionAgent agent) {
        String instanceName;
        NodeLevelResource resource;
        Objects.requireNonNull(collectionGroup);
        Objects.requireNonNull(e);
        Objects.requireNonNull(iface);
        Objects.requireNonNull(agent);
        NodeLevelResource nodeLevelResource = new NodeLevelResource(iface.getNodeId().intValue());
        CollectionSetBuilder collectionSetBuilder = new CollectionSetBuilder(agent).withTimestamp(new Date());
        String groupName = collectionGroup.getName();
        if (NODE_SNMP.equals(collectionGroup.getResourceType())) {
            resource = nodeLevelResource;
        } else if (INTERFACE_SNMP.equals(collectionGroup.getResourceType())) {
            instanceName = this.getInstanceName(collectionGroup, e);
            resource = new InterfaceLevelResource(nodeLevelResource, this.getInterfaceName(instanceName, iface));
        } else {
            instanceName = this.getInstanceName(collectionGroup, e);
            if (instanceName == null) {
                LOG.warn("Skip parm due to missing instance param {}. uei: {}", (Object)collectionGroup.getInstance(), (Object)e.getUei());
                return null;
            }
            resource = new DeferredGenericTypeResource(nodeLevelResource, collectionGroup.getResourceType(), instanceName);
            collectionSetBuilder.withStringAttribute((Resource)resource, collectionGroup.getName(), "instance", instanceName);
        }
        for (CollectionGroup.Collection collection : collectionGroup.getCollection()) {
            IParm parm = e.getParm(collection.getName());
            if (parm == null) continue;
            collectionSetBuilder = this.setupCollectionSet(collectionSetBuilder, (Resource)resource, groupName, collection, parm);
        }
        return collectionSetBuilder;
    }

    private String getInstanceName(CollectionGroup collectionGroup, IEvent e) {
        if (collectionGroup.getInstance() == null) {
            return null;
        }
        IParm instanceName = e.getParm(collectionGroup.getInstance());
        if (instanceName == null) {
            return null;
        }
        return instanceName.getValue().getContent();
    }

    private String getInterfaceName(String ifIndex, OnmsIpInterface iface) {
        OnmsSnmpInterface snmpInterface;
        try {
            snmpInterface = this.snmpInterfaceDao.findByNodeIdAndIfIndex(iface.getNodeId(), Integer.valueOf(Integer.parseInt(ifIndex)));
        }
        catch (NumberFormatException e) {
            snmpInterface = null;
        }
        if (snmpInterface != null) {
            return snmpInterface.getIfName();
        }
        return ifIndex != null ? ifIndex : InetAddressUtils.str((InetAddress)iface.getIpAddress());
    }

    private CollectionSetBuilder setupCollectionSet(CollectionSetBuilder collectionSet, Resource resource, String groupName, CollectionGroup.Collection collection, IParm parm) {
        Objects.requireNonNull(collection);
        Objects.requireNonNull(parm);
        String value = parm.getValue().getContent();
        try {
            switch (collection.getType()) {
                case GAUGE: {
                    return collectionSet.withGauge(resource, groupName, this.getCollectionName(collection), (Number)this.convertParamValue(collection, value));
                }
                case COUNTER: {
                    return collectionSet.withCounter(resource, groupName, this.getCollectionName(collection), (Number)this.convertParamValue(collection, value));
                }
                case STRING: {
                    return collectionSet.withStringAttribute(resource, groupName, this.getCollectionName(collection), value);
                }
            }
        }
        catch (NumberFormatException ex) {
            LOG.warn("Skip invalid value exist. value = {}", (Object)value);
        }
        return collectionSet;
    }

    private String getCollectionName(CollectionGroup.Collection collection) {
        String sanitized;
        String name = collection.getRename();
        if (name == null) {
            name = collection.getName();
        }
        return (sanitized = GenericTypeResource.sanitizeInstanceStrict((String)name)).length() > 19 ? sanitized.substring(0, 19) : sanitized;
    }

    private double convertParamValue(CollectionGroup.Collection collection, String value) throws NumberFormatException {
        Objects.requireNonNull(value);
        Objects.requireNonNull(collection);
        Optional<CollectionGroup.ParamValue> found = collection.getParamValue().stream().filter(p -> p.getName().equals(value)).findFirst();
        return found.isPresent() ? found.get().getValue() : Double.parseDouble(value);
    }

    private CollectionSetVisitor createRrdPersister(CollectionGroup.Rrd rrd) {
        RrdRepository repository = new RrdRepository();
        repository.setRrdBaseDir(rrd.getBaseDir());
        repository.setStep(rrd.getStep().intValue());
        repository.setHeartBeat(rrd.getHeartBeat());
        repository.setRraList(rrd.getRras());
        return this.persisterFactory.createPersister(new ServiceParameters(Collections.emptyMap()), repository);
    }
}

