/*
 * Decompiled with CFR 0.152.
 */
package net.jradius.webservice;

import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.net.SocketException;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.ByteBuffer;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.StringTokenizer;
import net.jradius.server.JRadiusEvent;
import net.jradius.server.ListenerRequest;
import net.jradius.server.TCPListener;
import net.jradius.webservice.OTPProxyRequest;
import net.jradius.webservice.WebServiceException;
import net.jradius.webservice.WebServiceRequest;
import net.jradius.webservice.WebServiceRequestObject;
import net.sf.ehcache.Cache;
import net.sf.ehcache.CacheException;
import net.sf.ehcache.CacheManager;
import net.sf.ehcache.Ehcache;
import net.sf.ehcache.Element;
import net.sf.ehcache.event.CacheEventListener;
import org.springframework.beans.factory.InitializingBean;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WebServiceListener
extends TCPListener
implements InitializingBean,
CacheEventListener {
    protected String cacheName = "ws-requests";
    protected Map requestMap;
    protected CacheManager cacheManager;
    protected Ehcache requestCache;
    protected Integer timeToLive;
    protected Integer idleTime;

    public JRadiusEvent parseRequest(ListenerRequest listenerRequest, ByteBuffer byteBuffer, InputStream inputStream) throws IOException, WebServiceException {
        DataInputStream reader = new DataInputStream(inputStream);
        WebServiceRequest request = new WebServiceRequest();
        String line = null;
        try {
            line = reader.readLine();
        }
        catch (SocketException e) {
            return null;
        }
        if (line == null) {
            throw new WebServiceException("Invalid relay request");
        }
        StringTokenizer tokens = new StringTokenizer(line);
        String method = tokens.nextToken();
        String uri = tokens.nextToken();
        String httpVersion = tokens.nextToken();
        if ("GET".equals(method)) {
            request.setMethod(1);
        } else if ("POST".equals(method)) {
            request.setMethod(2);
        } else if ("PUT".equals(method)) {
            request.setMethod(3);
        } else {
            throw new WebServiceException("Does not handle HTTP request method: " + method);
        }
        request.setHttpVersion(httpVersion);
        try {
            request.setUri(new URI(uri));
        }
        catch (URISyntaxException e) {
            throw new WebServiceException(e.getMessage());
        }
        Map<String, String> headers = this.getHeaders(reader);
        request.setHeaderMap(headers);
        String clen = headers.get("content-length");
        if (clen != null) {
            request.setContent(this.getContent(reader, Integer.parseInt(clen)));
        }
        return request;
    }

    private Map<String, String> getHeaders(DataInputStream reader) throws IOException {
        String[] parts;
        String line;
        LinkedHashMap<String, String> map = new LinkedHashMap<String, String>();
        while ((line = reader.readLine().trim()) != null && line.length() > 0 && (parts = line.split(":", 2)) != null && parts.length == 2) {
            map.put(parts[0].toLowerCase().trim(), parts[1].trim());
        }
        return map;
    }

    private byte[] getContent(DataInputStream reader, int clen) throws IOException {
        byte[] buf = new byte[clen];
        reader.readFully(buf);
        return buf;
    }

    public void remove(OTPProxyRequest request) {
        request.interrupt();
        if (this.requestMap != null) {
            this.requestMap.remove(request.getOtpName());
        } else {
            this.requestCache.remove((Serializable)((Object)request.getOtpName()));
        }
    }

    public void put(WebServiceRequestObject obj) {
        if (this.requestMap != null) {
            this.requestMap.put(obj.getKey(), obj);
        } else {
            this.requestCache.put(new Element((Serializable)((Object)obj.getKey()), (Serializable)obj));
        }
    }

    public WebServiceRequestObject get(String username) {
        if (this.requestMap != null) {
            return (WebServiceRequestObject)this.requestMap.get(username);
        }
        Element e = this.requestCache.get((Serializable)((Object)username));
        return e == null ? null : (WebServiceRequestObject)e.getValue();
    }

    private void deleteElement(Element e) {
        if (e == null) {
            return;
        }
        WebServiceRequestObject o = (WebServiceRequestObject)e.getValue();
        if (o == null) {
            return;
        }
        o.delete();
    }

    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }

    public void dispose() {
    }

    public void notifyElementEvicted(Ehcache cache, Element element) {
        this.deleteElement(element);
    }

    public void notifyElementExpired(Ehcache cache, Element element) {
        this.deleteElement(element);
    }

    public void notifyElementPut(Ehcache cache, Element element) throws CacheException {
    }

    public void notifyElementRemoved(Ehcache cache, Element element) throws CacheException {
        this.deleteElement(element);
    }

    public void notifyElementUpdated(Ehcache cache, Element element) throws CacheException {
    }

    public void notifyRemoveAll(Ehcache cache) {
    }

    public void afterPropertiesSet() throws Exception {
        if (this.idleTime == null) {
            this.idleTime = new Integer(120);
        }
        if (this.timeToLive == null) {
            this.timeToLive = new Integer(180);
        }
        if (this.requestMap != null) {
            return;
        }
        if (this.requestCache == null) {
            if (this.cacheManager == null) {
                throw new RuntimeException("cacheManager required");
            }
            this.requestCache = this.cacheManager.getCache(this.cacheName);
            if (this.requestCache == null) {
                this.requestCache = new Cache(this.cacheName, 2000, true, false, (long)this.timeToLive.intValue(), (long)this.idleTime.intValue());
                this.cacheManager.addCache(this.requestCache);
            }
        }
        this.requestCache.getCacheEventNotificationService().registerListener((CacheEventListener)this);
    }

    public CacheManager getCacheManager() {
        return this.cacheManager;
    }

    public void setCacheManager(CacheManager cacheManager) {
        this.cacheManager = cacheManager;
    }

    public String getCacheName() {
        return this.cacheName;
    }

    public void setCacheName(String cacheName) {
        this.cacheName = cacheName;
    }

    public Integer getIdleTime() {
        return this.idleTime;
    }

    public void setIdleTime(Integer idleTime) {
        this.idleTime = idleTime;
    }

    public Ehcache getRequestCache() {
        return this.requestCache;
    }

    public void setRequestCache(Ehcache requestCache) {
        this.requestCache = requestCache;
    }

    public Integer getTimeToLive() {
        return this.timeToLive;
    }

    public void setTimeToLive(Integer timeToLive) {
        this.timeToLive = timeToLive;
    }

    public Map getRequestMap() {
        return this.requestMap;
    }

    public void setRequestMap(Map requestMap) {
        this.requestMap = requestMap;
    }
}

