/*
 * Decompiled with CFR 0.152.
 */
package net.jradius.standard;

import java.util.LinkedList;
import net.jradius.exception.StandardViolatedException;
import net.jradius.packet.AccountingRequest;
import net.jradius.packet.RadiusPacket;
import net.jradius.standard.RadiusStandard;

public class IRAPStandard
extends RadiusStandard {
    static final long[] requiredAccessRequest = new long[]{1L, 4L, 5L, 61L, 32L, 30L, 31L};
    static final long[] requiredUAMAccessRequest = new long[]{2L};
    static final long[] requiredEAPAccessRequest = new long[]{79L, 80L};
    static final long[] requiredEAPAccessChallenge = new long[]{79L, 80L};
    static final long[] requiredEAPAccessReject = new long[]{79L, 80L};
    static final long[] requiredAccessAccept = new long[]{1L};
    static final long[] requiredEAPAccessAccept = new long[]{79L, 80L, 29L, 20381713L, 20381712L};
    static final long[] requiredAccountingRequest = new long[]{1L, 4L, 5L, 61L, 32L, 40L, 41L, 44L, 8L, 30L, 31L};
    static final long[] requiredAccountingInterimRequest = new long[]{42L, 43L, 47L, 48L, 46L};
    static final long[] requiredAccountingStopRequest = new long[]{49L};
    private boolean IEEE8021XRequired = false;

    public String getName() {
        return "IRAP";
    }

    public void checkPacket(RadiusPacket p, long[] ignore) throws StandardViolatedException {
        LinkedList missing = new LinkedList();
        boolean testAs8021X = false;
        testAs8021X = this.isIEEE8021XRequired() ? true : p.findAttribute(79L) != null;
        block0 : switch (p.getCode()) {
            case 1: {
                IRAPStandard.checkMissing((RadiusPacket)p, missing, (long[])requiredAccessRequest, (long[])ignore);
                IRAPStandard.checkMissing((RadiusPacket)p, missing, (long[])(testAs8021X ? requiredEAPAccessRequest : requiredUAMAccessRequest), (long[])ignore);
                break;
            }
            case 11: {
                if (!testAs8021X) break;
                IRAPStandard.checkMissing((RadiusPacket)p, missing, (long[])requiredEAPAccessChallenge, (long[])ignore);
                break;
            }
            case 2: {
                IRAPStandard.checkMissing((RadiusPacket)p, missing, (long[])requiredAccessAccept, (long[])ignore);
                if (!testAs8021X) break;
                IRAPStandard.checkMissing((RadiusPacket)p, missing, (long[])requiredEAPAccessAccept, (long[])ignore);
                break;
            }
            case 4: {
                IRAPStandard.checkMissing((RadiusPacket)p, missing, (long[])requiredAccountingRequest, (long[])ignore);
                switch (((AccountingRequest)p).getAccountingStatusType()) {
                    case 1: {
                        break block0;
                    }
                    case 2: {
                        IRAPStandard.checkMissing((RadiusPacket)p, missing, (long[])requiredAccountingStopRequest, (long[])ignore);
                    }
                    case 3: {
                        IRAPStandard.checkMissing((RadiusPacket)p, missing, (long[])requiredAccountingInterimRequest, (long[])ignore);
                    }
                }
            }
        }
        if (!missing.isEmpty()) {
            throw new StandardViolatedException(((Object)((Object)this)).getClass(), missing);
        }
    }

    public boolean isIEEE8021XRequired() {
        return this.IEEE8021XRequired;
    }

    public void setIEEE8021XRequired(boolean required) {
        this.IEEE8021XRequired = required;
    }
}

