/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.driver.api.core.type.codec;

import com.datastax.oss.driver.api.core.ProtocolVersion;
import com.datastax.oss.driver.api.core.type.DataType;
import com.datastax.oss.driver.api.core.type.codec.TypeCodec;
import com.datastax.oss.driver.api.core.type.reflect.GenericType;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.nio.ByteBuffer;
import java.util.Objects;

public abstract class MappingCodec<InnerT, OuterT>
implements TypeCodec<OuterT> {
    protected final TypeCodec<InnerT> innerCodec;
    protected final GenericType<OuterT> outerJavaType;

    protected MappingCodec(@NonNull TypeCodec<InnerT> innerCodec, @NonNull GenericType<OuterT> outerJavaType) {
        this.innerCodec = Objects.requireNonNull(innerCodec, "innerCodec cannot be null");
        this.outerJavaType = Objects.requireNonNull(outerJavaType, "outerJavaType cannot be null");
    }

    @Override
    @NonNull
    public GenericType<OuterT> getJavaType() {
        return this.outerJavaType;
    }

    public GenericType<InnerT> getInnerJavaType() {
        return this.innerCodec.getJavaType();
    }

    @Override
    @NonNull
    public DataType getCqlType() {
        return this.innerCodec.getCqlType();
    }

    @Override
    public ByteBuffer encode(OuterT value, @NonNull ProtocolVersion protocolVersion) {
        return this.innerCodec.encode(this.outerToInner(value), protocolVersion);
    }

    @Override
    public OuterT decode(ByteBuffer bytes, @NonNull ProtocolVersion protocolVersion) {
        return this.innerToOuter(this.innerCodec.decode(bytes, protocolVersion));
    }

    @Override
    @NonNull
    public String format(OuterT value) {
        return this.innerCodec.format(this.outerToInner(value));
    }

    @Override
    public OuterT parse(String value) {
        return this.innerToOuter(this.innerCodec.parse(value));
    }

    @Nullable
    protected abstract OuterT innerToOuter(@Nullable InnerT var1);

    @Nullable
    protected abstract InnerT outerToInner(@Nullable OuterT var1);
}

