/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.provision.service.vmware;

import com.google.common.base.Strings;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.ExecutionException;
import org.opennms.core.mate.api.Interpolator;
import org.opennms.core.mate.api.Scope;
import org.opennms.core.mate.api.SecureCredentialsVaultScope;
import org.opennms.core.spring.BeanUtils;
import org.opennms.core.utils.url.GenericURLConnection;
import org.opennms.core.xml.XmlHandler;
import org.opennms.features.scv.api.SecureCredentialsVault;
import org.opennms.netmgt.config.vmware.VmwareServer;
import org.opennms.netmgt.dao.vmware.VmwareConfigDao;
import org.opennms.netmgt.provision.persist.LocationAwareRequisitionClient;
import org.opennms.netmgt.provision.persist.requisition.Requisition;
import org.opennms.netmgt.provision.service.vmware.VmwareImportRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VmwareRequisitionUrlConnection
extends GenericURLConnection {
    private static final Logger logger = LoggerFactory.getLogger(VmwareRequisitionUrlConnection.class);
    private static LocationAwareRequisitionClient s_requisitionProviderClient;
    private static SecureCredentialsVault s_secureCredentialsVault;
    private static VmwareConfigDao s_vmwareConfigDao;
    private final Map<String, String> parameters = new TreeMap<String, String>();
    private static final XmlHandler<Requisition> s_xmlHandler;

    public VmwareRequisitionUrlConnection(URL url) {
        super(url);
        logger.debug("Initializing URL Connection for host {}", (Object)url.getHost());
        this.parameters.put("host", url.getHost());
        this.parameters.put("path", url.getPath());
        if (url.getUserInfo() != null && !url.getUserInfo().isEmpty()) {
            logger.warn("Old user credentials handling scheme detected. I'm gonna use it but you'd better adapt your URL to the new query parameter scheme 'vmware://<vcenter_server_fqdn>?username=<username>;password=<password>;....'");
            this.parameters.put("username", this.getUsername());
            this.parameters.put("password", this.getPassword());
        }
        this.parameters.putAll(this.getQueryArgs());
        if (VmwareRequisitionUrlConnection.getVmwareConfigDao() == null) {
            logger.error("vmwareConfigDao should be a non-null value.");
        } else {
            Map<String, VmwareServer> serverMap = VmwareRequisitionUrlConnection.getVmwareConfigDao().getServerMap();
            if (serverMap == null) {
                logger.error("Error getting vmware-config.xml's server map.");
            } else {
                VmwareServer vmwareServer = serverMap.get(this.parameters.get("host"));
                if (vmwareServer == null) {
                    logger.error("Error getting credentials for VMware management server '{}'.", (Object)this.parameters.get("host"));
                } else {
                    SecureCredentialsVaultScope scvScope = new SecureCredentialsVaultScope(VmwareRequisitionUrlConnection.getSecureCredentialsVault());
                    this.parameters.put("username", Interpolator.interpolate((String)vmwareServer.getUsername(), (Scope)scvScope).output);
                    this.parameters.put("password", Interpolator.interpolate((String)vmwareServer.getPassword(), (Scope)scvScope).output);
                }
            }
        }
        if (Strings.isNullOrEmpty((String)this.parameters.get("username")) || Strings.isNullOrEmpty((String)this.parameters.get("password"))) {
            logger.error("Error getting username/password for VMware management server '{}'.", (Object)this.parameters.get("host"));
            throw new IllegalArgumentException("Username and password must not be empty or null");
        }
    }

    public void connect() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public InputStream getInputStream() throws IOException {
        try {
            String requisitionXml;
            Requisition requisition = (Requisition)VmwareRequisitionUrlConnection.getClient().requisition().withRequisitionProviderType("vmware").withParameters(this.parameters).execute().get();
            if (requisition == null) {
                throw new IOException(String.format("Invalid (null) requisition was returned by the provider for type '%s'", "vmware"));
            }
            XmlHandler<Requisition> xmlHandler = s_xmlHandler;
            synchronized (xmlHandler) {
                requisitionXml = s_xmlHandler.marshal((Object)requisition);
            }
            return new ByteArrayInputStream(requisitionXml.getBytes());
        }
        catch (InterruptedException | ExecutionException e) {
            throw new IOException(e);
        }
    }

    private static LocationAwareRequisitionClient getClient() {
        if (s_requisitionProviderClient == null) {
            s_requisitionProviderClient = (LocationAwareRequisitionClient)BeanUtils.getBean((String)"daoContext", (String)"locationAwareRequisitionClient", LocationAwareRequisitionClient.class);
        }
        return s_requisitionProviderClient;
    }

    private static VmwareConfigDao getVmwareConfigDao() {
        if (s_vmwareConfigDao == null) {
            s_vmwareConfigDao = (VmwareConfigDao)BeanUtils.getBean((String)"daoContext", (String)"vmwareConfigDao", VmwareConfigDao.class);
        }
        return s_vmwareConfigDao;
    }

    private static SecureCredentialsVault getSecureCredentialsVault() {
        if (s_secureCredentialsVault == null) {
            s_secureCredentialsVault = (SecureCredentialsVault)BeanUtils.getBean((String)"jceksScvContext", (String)"jceksSecureCredentialsVault", SecureCredentialsVault.class);
        }
        return s_secureCredentialsVault;
    }

    public static void setRequisitionProviderClient(LocationAwareRequisitionClient s_requisitionProviderClient) {
        VmwareRequisitionUrlConnection.s_requisitionProviderClient = s_requisitionProviderClient;
    }

    public static void setSecureCredentialsVault(SecureCredentialsVault s_secureCredentialsVault) {
        VmwareRequisitionUrlConnection.s_secureCredentialsVault = s_secureCredentialsVault;
    }

    public static void setVmwareConfigDao(VmwareConfigDao s_vmwareConfigDao) {
        VmwareRequisitionUrlConnection.s_vmwareConfigDao = s_vmwareConfigDao;
    }

    public VmwareImportRequest getImportRequest() {
        return new VmwareImportRequest(this.parameters);
    }

    static {
        s_xmlHandler = new XmlHandler(Requisition.class);
    }
}

