/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.http.proxy.impl;

import java.util.EventListener;
import javax.servlet.ServletContext;
import javax.servlet.ServletContextEvent;
import javax.servlet.ServletContextListener;
import javax.servlet.annotation.WebListener;
import org.apache.felix.http.proxy.AbstractProxyListener;
import org.apache.felix.http.proxy.impl.EventDispatcherTracker;
import org.osgi.framework.BundleContext;
import org.osgi.framework.InvalidSyntaxException;

@WebListener
public class ProxyServletContextListener
implements ServletContextListener {
    private volatile ServletContext servletContext;
    private volatile EventDispatcherTracker eventDispatcherTracker;

    public void contextInitialized(ServletContextEvent sce) {
        this.servletContext = sce.getServletContext();
        this.servletContext.addListener((EventListener)((Object)new AbstractProxyListener(){

            @Override
            protected void stopTracking() {
                ProxyServletContextListener.this.stopTracking();
            }

            @Override
            protected void startTracking(Object bundleContextAttr) {
                ProxyServletContextListener.this.startTracking(bundleContextAttr);
            }

            @Override
            protected EventDispatcherTracker getEventDispatcherTracker() {
                return ProxyServletContextListener.this.eventDispatcherTracker;
            }
        }));
    }

    private void stopTracking() {
        if (this.eventDispatcherTracker != null) {
            this.eventDispatcherTracker.close();
            this.eventDispatcherTracker = null;
        }
    }

    protected void startTracking(Object bundleContextAttr) {
        if (bundleContextAttr instanceof BundleContext) {
            try {
                BundleContext bundleContext = (BundleContext)bundleContextAttr;
                this.eventDispatcherTracker = new EventDispatcherTracker(bundleContext);
                this.eventDispatcherTracker.open();
            }
            catch (InvalidSyntaxException invalidSyntaxException) {
                // empty catch block
            }
        }
    }

    public void contextDestroyed(ServletContextEvent sce) {
        this.stopTracking();
        this.servletContext = null;
    }
}

