/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.snmpinterfacepoller.pollable;

import java.util.HashSet;
import java.util.Set;

public enum SnmpInterfaceStatus {
    INVALID(0, "Invalid"),
    UP(1, "Up"),
    DOWN(2, "Down"),
    TESTING(3, "Testing"),
    UNKNOWN(4, "Unknown"),
    DORMANT(5, "Dormant"),
    NOT_PRESENT(6, "Not Present"),
    LOWER_LAYER_DOWN(7, "Lower Layer Down");

    public final int m_mibValue;
    public final String m_label;

    private SnmpInterfaceStatus(int mibValue, String label) {
        this.m_mibValue = mibValue;
        this.m_label = label;
    }

    public int getMibValue() {
        return this.m_mibValue;
    }

    public String getLabel() {
        return this.m_label;
    }

    public static SnmpInterfaceStatus statusFromMibValue(int mibValue) {
        switch (mibValue) {
            case 1: {
                return UP;
            }
            case 2: {
                return DOWN;
            }
            case 3: {
                return TESTING;
            }
            case 4: {
                return UNKNOWN;
            }
            case 5: {
                return DORMANT;
            }
            case 6: {
                return NOT_PRESENT;
            }
            case 7: {
                return LOWER_LAYER_DOWN;
            }
        }
        return INVALID;
    }

    public static String labelFromMibValue(int mibValue) {
        return SnmpInterfaceStatus.statusFromMibValue(mibValue).getLabel();
    }

    public static Set<SnmpInterfaceStatus> getStatuses(int[] statuses) {
        HashSet<SnmpInterfaceStatus> ret = new HashSet<SnmpInterfaceStatus>(statuses.length);
        for (int s : statuses) {
            ret.add(SnmpInterfaceStatus.statusFromMibValue(s));
        }
        return ret;
    }
}

