/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.scriptd;

import java.io.IOException;
import java.lang.reflect.UndeclaredThrowableException;
import org.opennms.core.spring.BeanUtils;
import org.opennms.netmgt.config.ScriptdConfigFactory;
import org.opennms.netmgt.daemon.AbstractServiceDaemon;
import org.opennms.netmgt.dao.api.NodeDao;
import org.opennms.netmgt.dao.api.SessionUtils;
import org.opennms.netmgt.events.api.annotations.EventHandler;
import org.opennms.netmgt.events.api.annotations.EventListener;
import org.opennms.netmgt.events.api.model.IEvent;
import org.opennms.netmgt.scriptd.Executor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.access.BeanFactoryReference;

@EventListener(name="scriptd")
public final class Scriptd
extends AbstractServiceDaemon {
    private static final Logger LOG = LoggerFactory.getLogger(Scriptd.class);
    public static final String NAME = "scriptd";
    private static final Scriptd m_singleton = new Scriptd();
    private Executor m_executor = null;

    private Scriptd() {
        super(NAME);
    }

    protected void onInit() {
        ScriptdConfigFactory aFactory = null;
        try {
            ScriptdConfigFactory.reload();
            aFactory = ScriptdConfigFactory.getInstance();
        }
        catch (IOException ex) {
            LOG.error("Failed to load scriptd configuration", (Throwable)ex);
            throw new UndeclaredThrowableException(ex);
        }
        BeanFactoryReference bf = BeanUtils.getBeanFactory((String)"daoContext");
        NodeDao nodeDao = (NodeDao)BeanUtils.getBean((BeanFactoryReference)bf, (String)"nodeDao", NodeDao.class);
        SessionUtils sessionUtils = (SessionUtils)BeanUtils.getBean((BeanFactoryReference)bf, (String)"sessionUtils", SessionUtils.class);
        this.m_executor = new Executor(aFactory, nodeDao, sessionUtils);
    }

    protected void onStart() {
        if (this.m_executor == null) {
            this.init();
        }
        this.m_executor.start();
        LOG.info("Scriptd started");
    }

    protected void onStop() {
        try {
            if (this.m_executor != null) {
                this.m_executor.stop();
            }
        }
        catch (Throwable e) {
            LOG.warn("Unexpected throwable when stopping Scriptd", e);
        }
        this.m_executor = null;
        LOG.info("Scriptd stopped");
    }

    public static Scriptd getInstance() {
        return m_singleton;
    }

    @EventHandler(uei="uei.opennms.org/internal/reloadDaemonConfig")
    public void handleReloadConfigEvent(IEvent event) {
        if (Executor.isReloadConfigEvent(event)) {
            this.m_executor.doReload();
        }
    }
}

