/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.scriptd;

import java.io.Serializable;
import java.lang.reflect.UndeclaredThrowableException;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import org.apache.bsf.BSFException;
import org.apache.bsf.BSFManager;
import org.opennms.core.concurrent.LogPreservingThreadFactory;
import org.opennms.netmgt.config.ScriptdConfigFactory;
import org.opennms.netmgt.config.scriptd.Engine;
import org.opennms.netmgt.config.scriptd.EventScript;
import org.opennms.netmgt.config.scriptd.ReloadScript;
import org.opennms.netmgt.config.scriptd.StartScript;
import org.opennms.netmgt.config.scriptd.StopScript;
import org.opennms.netmgt.config.scriptd.Uei;
import org.opennms.netmgt.dao.api.NodeDao;
import org.opennms.netmgt.dao.api.SessionUtils;
import org.opennms.netmgt.events.api.model.IEvent;
import org.opennms.netmgt.events.api.model.IParm;
import org.opennms.netmgt.events.api.model.IScript;
import org.opennms.netmgt.model.OnmsNode;
import org.opennms.netmgt.scriptd.BroadcastEventProcessor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Executor {
    private static final Logger LOG = LoggerFactory.getLogger(Executor.class);
    private final Set<EventScript> m_eventScripts = new CopyOnWriteArraySet<EventScript>();
    private final Map<String, Set<EventScript>> m_eventScriptMap = new ConcurrentHashMap<String, Set<EventScript>>();
    private final NodeDao m_nodeDao;
    private BSFManager m_scriptManager = null;
    private ExecutorService m_executorService;
    private BroadcastEventProcessor m_broadcastEventProcessor;
    private ScriptdConfigFactory m_config;
    private SessionUtils m_sessionUtils;

    Executor(ScriptdConfigFactory config, NodeDao nodeDao, SessionUtils sessionUtils) {
        this.m_config = config;
        this.m_nodeDao = nodeDao;
        this.m_sessionUtils = sessionUtils;
        this.loadConfig();
    }

    private void loadConfig() {
        this.m_eventScripts.clear();
        this.m_eventScriptMap.clear();
        for (EventScript script : this.m_config.getEventScripts()) {
            List ueis = script.getUeis();
            if (ueis.isEmpty()) {
                this.m_eventScripts.add(script);
                continue;
            }
            for (Uei uei : ueis) {
                String ueiName = uei.getName();
                Set<EventScript> list = this.m_eventScriptMap.get(ueiName);
                if (list == null) {
                    list = new CopyOnWriteArraySet<EventScript>();
                    list.add(script);
                    this.m_eventScriptMap.put(ueiName, list);
                    continue;
                }
                list.add(script);
            }
        }
    }

    public void addTask(IEvent event) {
        this.m_executorService.execute(new ScriptdRunnable(event));
    }

    protected void doReload() {
        try {
            ScriptdConfigFactory.reload();
            this.m_config = ScriptdConfigFactory.getInstance();
            this.registerEventProcessor();
            this.loadConfig();
            for (ReloadScript script : this.m_config.getReloadScripts()) {
                Optional scriptContent = script.getContent();
                if (scriptContent.isPresent()) {
                    try {
                        this.m_scriptManager.exec(script.getLanguage(), "", 0, 0, scriptContent.get());
                    }
                    catch (BSFException e) {
                        LOG.error("Reload script[{}] failed.", (Object)script, (Object)e);
                    }
                    continue;
                }
                LOG.warn("Reload Script does not have script contents: {}", (Object)script);
            }
            LOG.debug("Scriptd configuration reloaded");
        }
        catch (Exception e) {
            LOG.error("Unable to reload Scriptd configuration", (Throwable)e);
        }
    }

    private void executeEventScripts(IEvent m_event) {
        IScript[] attachedScripts = m_event.getScript();
        Set<EventScript> mapScripts = null;
        try {
            mapScripts = this.m_eventScriptMap.get(m_event.getUei());
        }
        catch (Throwable e) {
            LOG.warn("Unexpected exception: " + e.getMessage(), e);
        }
        if (attachedScripts.length > 0 || mapScripts != null || this.m_eventScripts.size() > 0) {
            LOG.debug("Executing scripts for: {}", (Object)m_event.getUei());
            this.m_scriptManager.registerBean("event", (Object)m_event);
            OnmsNode node = null;
            if (m_event.hasNodeid()) {
                Long nodeLong = m_event.getNodeid();
                Integer nodeInt = nodeLong.intValue();
                node = (OnmsNode)this.m_nodeDao.get((Serializable)nodeInt);
                this.m_scriptManager.registerBean("node", (Object)node);
            }
            LOG.debug("Executing attached scripts");
            if (attachedScripts.length > 0) {
                for (IScript script : attachedScripts) {
                    try {
                        this.m_scriptManager.exec(script.getLanguage(), "", 0, 0, (Object)script.getContent());
                    }
                    catch (BSFException e) {
                        LOG.error("Attached script [{}] execution failed", (Object)script, (Object)e);
                    }
                }
            }
            LOG.debug("Executing mapped scripts");
            if (mapScripts != null) {
                for (EventScript script : mapScripts) {
                    if (script.getContent().isPresent()) {
                        try {
                            this.m_scriptManager.exec(script.getLanguage(), "", 0, 0, script.getContent().get());
                        }
                        catch (BSFException e) {
                            LOG.error("UEI-specific event handler script execution failed: {}", (Object)m_event.getUei(), (Object)e);
                        }
                        continue;
                    }
                    LOG.warn("UEI-specific event handler script missing contents: {}", (Object)script);
                }
            }
            LOG.debug("Executing global scripts");
            for (EventScript script : this.m_eventScripts) {
                if (script.getContent().isPresent()) {
                    try {
                        this.m_scriptManager.exec(script.getLanguage(), "", 0, 0, script.getContent().get());
                    }
                    catch (BSFException e) {
                        LOG.error("Non-UEI-specific event handler script execution failed : " + script, (Throwable)e);
                    }
                    continue;
                }
                LOG.warn("Non-UEI-specific event handler script missing contents: {}", (Object)script);
            }
            if (node != null) {
                this.m_scriptManager.unregisterBean("node");
            }
            this.m_scriptManager.unregisterBean("event");
            LOG.debug("Finished executing scripts for: {}", (Object)m_event.getUei());
        }
    }

    protected static boolean isReloadConfigEvent(IEvent event) {
        boolean isTarget = false;
        if ("uei.opennms.org/internal/reloadDaemonConfig".equals(event.getUei())) {
            List parmCollection = event.getParmCollection();
            for (IParm parm : parmCollection) {
                if (!"daemonName".equals(parm.getParmName()) || !"scriptd".equalsIgnoreCase(parm.getValue().getContent())) continue;
                isTarget = true;
                break;
            }
        } else if ("uei.opennms.org/internal/reloadScriptConfig".equals(event.getUei())) {
            isTarget = true;
        }
        return isTarget;
    }

    public synchronized void start() {
        for (Engine engine : this.m_config.getEngines()) {
            LOG.debug("Registering engine: {}", (Object)engine.getLanguage());
            String[] extensions = null;
            if (engine.getExtensions().isPresent()) {
                StringTokenizer st = new StringTokenizer((String)engine.getExtensions().get());
                extensions = new String[st.countTokens()];
                int j = 0;
                while (st.hasMoreTokens()) {
                    extensions[j++] = st.nextToken();
                }
            }
            BSFManager.registerScriptingEngine((String)engine.getLanguage(), (String)engine.getClassName(), extensions);
        }
        this.m_scriptManager = new BSFManager();
        this.m_scriptManager.registerBean("log", (Object)LOG);
        for (StartScript startScript : this.m_config.getStartScripts()) {
            if (startScript.getContent().isPresent()) {
                try {
                    this.m_scriptManager.exec(startScript.getLanguage(), "", 0, 0, startScript.getContent().get());
                }
                catch (BSFException e) {
                    LOG.error("Start script failed: " + startScript, (Throwable)e);
                }
                continue;
            }
            LOG.warn("Start script has no script content: " + startScript);
        }
        this.m_executorService = Executors.newFixedThreadPool(1, (ThreadFactory)new LogPreservingThreadFactory("Scriptd-Executor", 1));
        this.registerEventProcessor();
        LOG.debug("Scriptd executor started");
    }

    protected void registerEventProcessor() {
        if (this.m_broadcastEventProcessor != null) {
            this.m_broadcastEventProcessor.close();
        }
        try {
            this.m_broadcastEventProcessor = new BroadcastEventProcessor(this);
        }
        catch (Exception e) {
            LOG.error("Failed to setup event reader", (Throwable)e);
            throw new UndeclaredThrowableException(e);
        }
    }

    public synchronized void stop() {
        if (this.m_broadcastEventProcessor != null) {
            this.m_broadcastEventProcessor.close();
        }
        this.m_broadcastEventProcessor = null;
        this.m_executorService.shutdown();
        for (StopScript stopScript : this.m_config.getStopScripts()) {
            if (stopScript.getContent().isPresent()) {
                try {
                    this.m_scriptManager.exec(stopScript.getLanguage(), "", 0, 0, stopScript.getContent().get());
                }
                catch (BSFException e) {
                    LOG.error("Stop script failed: " + stopScript, (Throwable)e);
                }
                continue;
            }
            LOG.warn("Stop script has no script contents: " + stopScript);
        }
        LOG.debug("Scriptd executor stopped");
    }

    private class ScriptdRunnable
    implements Runnable {
        private final IEvent m_event;

        public ScriptdRunnable(IEvent event) {
            this.m_event = event;
        }

        @Override
        public void run() {
            if (Executor.isReloadConfigEvent(this.m_event)) {
                return;
            }
            if (Executor.this.m_config.getTransactional().booleanValue()) {
                Executor.this.m_sessionUtils.withReadOnlyTransaction(() -> {
                    Executor.this.executeEventScripts(this.m_event);
                    return null;
                });
            } else {
                Executor.this.executeEventScripts(this.m_event);
            }
        }
    }
}

