/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.poller.monitors;

import java.net.InetAddress;
import java.util.HashMap;
import java.util.Map;
import org.opennms.core.utils.InetAddressUtils;
import org.opennms.core.utils.ParameterMap;
import org.opennms.netmgt.poller.MonitoredService;
import org.opennms.netmgt.poller.PollStatus;
import org.opennms.netmgt.poller.monitors.SnmpMonitorStrategy;
import org.opennms.netmgt.snmp.SnmpAgentConfig;
import org.opennms.netmgt.snmp.SnmpObjId;
import org.opennms.netmgt.snmp.SnmpUtils;
import org.opennms.netmgt.snmp.SnmpValue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class BgpSessionMonitor
extends SnmpMonitorStrategy {
    public static final Logger LOG = LoggerFactory.getLogger(BgpSessionMonitor.class);
    private static final String BGP_BASE_OID_DEFAULT = ".1.3.6.1.2.1.15";
    private static final String BGP_PEER_STATE_OID_SUFFIX = ".3.1.2";
    private static final String BGP_PEER_ADMIN_STATE_OID_SUFFIX = ".3.1.3";
    private static final String BGP_PEER_REMOTEAS_SUFFIX = ".3.1.9";
    private static final String BGP_PEER_LAST_ERROR_SUFFIX = ".3.1.14";
    private static final String BGP_PEER_FSM_EST_TIME_SUFFIX = ".3.1.16";

    public PollStatus poll(MonitoredService svc, Map<String, Object> parameters) {
        BgpOids bgpOids = new BgpOids(parameters);
        Object returnValue = "";
        PollStatus status = PollStatus.unavailable();
        InetAddress ipaddr = svc.getAddress();
        String adminStateMsg = "N/A";
        String peerStateMsg = "N/A";
        String remoteAsMsg = "N/A";
        String lastErrorMsg = "N/A";
        String estTimeMsg = "N/A";
        SnmpAgentConfig agentConfig = this.getAgentConfig(svc, parameters);
        String hostAddress = InetAddressUtils.str((InetAddress)ipaddr);
        LOG.debug("poll: setting SNMP peer attribute for interface {}", (Object)hostAddress);
        String bgpPeerIp = ParameterMap.getKeyedString(parameters, (String)"bgpPeerIp", null);
        if (bgpPeerIp == null) {
            LOG.warn("poll: No BGP-Peer IP Defined! ");
            return status;
        }
        agentConfig.setTimeout(ParameterMap.getKeyedInteger(parameters, (String)"timeout", (int)agentConfig.getTimeout()));
        agentConfig.setRetries(ParameterMap.getKeyedInteger(parameters, (String)"retry", (int)ParameterMap.getKeyedInteger(parameters, (String)"retries", (int)agentConfig.getRetries())));
        agentConfig.setPort(ParameterMap.getKeyedInteger(parameters, (String)"port", (int)agentConfig.getPort()));
        try {
            LOG.debug("poll: SnmpAgentConfig address: {}", (Object)agentConfig);
            SnmpObjId bgpPeerStateSnmpObject = SnmpObjId.get((String)(bgpOids.bgpPeerStateOid + "." + bgpPeerIp));
            SnmpValue bgpPeerState = SnmpUtils.get((SnmpAgentConfig)agentConfig, (SnmpObjId)bgpPeerStateSnmpObject);
            if (bgpPeerState == null) {
                LOG.warn("No BGP peer state received!");
                return status;
            }
            LOG.debug("poll: bgpPeerState: {}", (Object)bgpPeerState);
            peerStateMsg = this.resolvePeerState(bgpPeerState.toInt());
            if (bgpPeerState.toInt() == BGP_PEER_STATE.ESTABLISHED.value()) {
                LOG.debug("poll: bgpPeerState: {}", (Object)BGP_PEER_STATE.ESTABLISHED.name());
                return PollStatus.available();
            }
            SnmpObjId bgpPeerAdminStateSnmpObject = SnmpObjId.get((String)(bgpOids.bgpPeerAdminStateOid + "." + bgpPeerIp));
            SnmpValue bgpPeerAdminState = SnmpUtils.get((SnmpAgentConfig)agentConfig, (SnmpObjId)bgpPeerAdminStateSnmpObject);
            if (bgpPeerAdminState == null) {
                LOG.warn("Cannot receive bgpAdminState");
            } else {
                LOG.debug("poll: bgpPeerAdminState: {}", (Object)bgpPeerAdminState);
                adminStateMsg = this.resolveAdminState(bgpPeerAdminState.toInt());
            }
            SnmpObjId bgpPeerRemoteAsSnmpObject = SnmpObjId.get((String)(bgpOids.bgpPeerRemoteAsOid + "." + bgpPeerIp));
            SnmpValue bgpPeerRemoteAs = SnmpUtils.get((SnmpAgentConfig)agentConfig, (SnmpObjId)bgpPeerRemoteAsSnmpObject);
            if (bgpPeerRemoteAs == null) {
                LOG.warn("Cannot receive bgpPeerRemoteAs");
            } else {
                LOG.debug("poll: bgpPeerRemoteAs: {}", (Object)bgpPeerRemoteAs);
                remoteAsMsg = bgpPeerRemoteAs.toString();
            }
            SnmpObjId bgpPeerLastErrorSnmpObject = SnmpObjId.get((String)(bgpOids.bgpPeerLastErrorOid + "." + bgpPeerIp));
            SnmpValue bgpPeerLastError = SnmpUtils.get((SnmpAgentConfig)agentConfig, (SnmpObjId)bgpPeerLastErrorSnmpObject);
            if (bgpPeerLastError == null) {
                LOG.warn("Cannot receive bgpPeerLastError");
            } else {
                LOG.debug("poll: bgpPeerLastError: {}", (Object)bgpPeerLastError);
                lastErrorMsg = this.resolveBgpErrorCode(bgpPeerLastError.toHexString());
            }
            SnmpObjId bgpPeerFsmEstTimeSnmpObject = SnmpObjId.get((String)(bgpOids.bgpPeerFsmEstTimeOid + "." + bgpPeerIp));
            SnmpValue bgpPeerFsmEstTime = SnmpUtils.get((SnmpAgentConfig)agentConfig, (SnmpObjId)bgpPeerFsmEstTimeSnmpObject);
            if (bgpPeerFsmEstTime == null) {
                LOG.warn("Cannot receive bgpPeerFsmEstTime");
            } else {
                LOG.debug("poll: bgpPeerFsmEsmTime: {}", (Object)bgpPeerFsmEstTime);
                estTimeMsg = bgpPeerFsmEstTime.toString();
            }
            returnValue = "BGP Session state to AS-" + remoteAsMsg + " via " + bgpPeerIp + " is " + peerStateMsg + "! Last peer error message is " + lastErrorMsg + ". BGP admin state is " + adminStateMsg + ". BGP Session established time: " + estTimeMsg;
            status = PollStatus.unavailable((String)returnValue);
        }
        catch (NullPointerException e) {
            String reason = "Unexpected error during SNMP poll of interface " + hostAddress;
            LOG.debug(reason, (Throwable)e);
            status = PollStatus.unavailable(reason);
        }
        catch (NumberFormatException e) {
            String reason = "Number operator used on a non-number " + e.getMessage();
            LOG.debug(reason);
            status = PollStatus.unavailable(reason);
        }
        catch (IllegalArgumentException e) {
            String reason = "Invalid SNMP Criteria: " + e.getMessage();
            LOG.debug(reason);
            status = PollStatus.unavailable(reason);
        }
        catch (Throwable t) {
            String reason = "Unexpected exception during SNMP poll of interface " + hostAddress;
            LOG.debug(reason, t);
            status = PollStatus.unavailable(reason);
        }
        return status;
    }

    private String resolveBgpErrorCode(String bgpCode) {
        String clearCode = "unknown error";
        HashMap<String, String> codeMap = new HashMap<String, String>();
        codeMap.put("0100", "Message Header Error");
        codeMap.put("0101", "Message Header Error - Connection Not Synchronized");
        codeMap.put("0102", "Message Header Error - Bad Message Length");
        codeMap.put("0103", "Message Header Error - Bad Message Type");
        codeMap.put("0200", "OPEN Message Error");
        codeMap.put("0201", "OPEN Message Error - Unsupported Version Number");
        codeMap.put("0202", "OPEN Message Error - Bad Peer AS");
        codeMap.put("0203", "OPEN Message Error - Bad BGP Identifier");
        codeMap.put("0204", "OPEN Message Error - Unsupported Optional Parameter");
        codeMap.put("0205", "OPEN Message Error (deprecated)");
        codeMap.put("0206", "OPEN Message Error - Unacceptable Hold Time");
        codeMap.put("0300", "UPDATE Message Error");
        codeMap.put("0301", "UPDATE Message Error - Malformed Attribute List");
        codeMap.put("0302", "UPDATE Message Error - Unrecognized Well-known Attribute");
        codeMap.put("0303", "UPDATE Message Error - Missing Well-known Attribute");
        codeMap.put("0304", "UPDATE Message Error - Attribute Flags Error");
        codeMap.put("0305", "UPDATE Message Error - Attribute Length Error");
        codeMap.put("0306", "UPDATE Message Error - Invalid ORIGIN Attribute");
        codeMap.put("0307", "UPDATE Message Error (deprecated)");
        codeMap.put("0308", "UPDATE Message Error - Invalid NEXT_HOP Attribute");
        codeMap.put("0309", "UPDATE Message Error - Optional Attribute Error");
        codeMap.put("030A", "UPDATE Message Error - Invalid Network Field");
        codeMap.put("030B", "UPDATE Message Error - Malformed AS_PATH");
        codeMap.put("0400", "Hold Timer Expired");
        codeMap.put("0500", "Finite State Machine Error");
        codeMap.put("0600", "Cease");
        codeMap.put("0601", "Cease - Maximum Number of Prefixes Reached");
        codeMap.put("0602", "Cease - Administrative Shutdown");
        codeMap.put("0603", "Cease - Peer De-configured");
        codeMap.put("0604", "Cease - Administrative Reset");
        codeMap.put("0605", "Cease - Connection Rejected");
        codeMap.put("0606", "Cease - Other Configuration Change");
        codeMap.put("0607", "Cease - Connection Collision Resolution");
        codeMap.put("0608", "Cease - Out of Resources");
        if (codeMap.containsKey(bgpCode)) {
            clearCode = (String)codeMap.get(bgpCode);
        }
        return clearCode;
    }

    private String resolveAdminState(int sc) {
        String name = "UNKNOWN";
        if (BGP_PEER_ADMIN_STATE.STOP.value() == sc) {
            name = BGP_PEER_ADMIN_STATE.STOP.name();
        }
        if (BGP_PEER_ADMIN_STATE.START.value() == sc) {
            name = BGP_PEER_ADMIN_STATE.START.name();
        }
        return name;
    }

    private String resolvePeerState(int sc) {
        String name = "UNKNOWN";
        if (BGP_PEER_STATE.IDLE.value() == sc) {
            name = BGP_PEER_STATE.IDLE.name();
        }
        if (BGP_PEER_STATE.CONNECT.value() == sc) {
            name = BGP_PEER_STATE.CONNECT.name();
        }
        if (BGP_PEER_STATE.ACTIVE.value() == sc) {
            name = BGP_PEER_STATE.ACTIVE.name();
        }
        if (BGP_PEER_STATE.OPEN_SENT.value() == sc) {
            name = BGP_PEER_STATE.OPEN_SENT.name();
        }
        if (BGP_PEER_STATE.OPEN_CONFIRM.value() == sc) {
            name = BGP_PEER_STATE.OPEN_CONFIRM.name();
        }
        if (BGP_PEER_STATE.ESTABLISHED.value() == sc) {
            name = BGP_PEER_STATE.ESTABLISHED.name();
        }
        return name;
    }

    private static enum BGP_PEER_ADMIN_STATE {
        STOP(1),
        START(2);

        private final int state;

        private BGP_PEER_ADMIN_STATE(int s) {
            this.state = s;
        }

        private int value() {
            return this.state;
        }
    }

    private static enum BGP_PEER_STATE {
        IDLE(1),
        CONNECT(2),
        ACTIVE(3),
        OPEN_SENT(4),
        OPEN_CONFIRM(5),
        ESTABLISHED(6);

        private final int state;

        private BGP_PEER_STATE(int s) {
            this.state = s;
        }

        private int value() {
            return this.state;
        }
    }

    static class BgpOids {
        final String bgpBaseOid;
        final String bgpPeerStateOid;
        final String bgpPeerAdminStateOid;
        final String bgpPeerRemoteAsOid;
        final String bgpPeerLastErrorOid;
        final String bgpPeerFsmEstTimeOid;

        public BgpOids(Map<String, Object> parameters) {
            this.bgpBaseOid = ParameterMap.getKeyedString(parameters, (String)"bgpBaseOid", (String)BgpSessionMonitor.BGP_BASE_OID_DEFAULT);
            this.bgpPeerStateOid = ParameterMap.getKeyedString(parameters, (String)"bgpPeerStateOid", (String)(this.bgpBaseOid + BgpSessionMonitor.BGP_PEER_STATE_OID_SUFFIX));
            this.bgpPeerAdminStateOid = ParameterMap.getKeyedString(parameters, (String)"bgpPeerAdminStateOid", (String)(this.bgpBaseOid + BgpSessionMonitor.BGP_PEER_ADMIN_STATE_OID_SUFFIX));
            this.bgpPeerRemoteAsOid = ParameterMap.getKeyedString(parameters, (String)"bgpPeerRemoteAsOid", (String)(this.bgpBaseOid + BgpSessionMonitor.BGP_PEER_REMOTEAS_SUFFIX));
            this.bgpPeerLastErrorOid = ParameterMap.getKeyedString(parameters, (String)"bgpPeerLastErrorOid", (String)(this.bgpBaseOid + BgpSessionMonitor.BGP_PEER_LAST_ERROR_SUFFIX));
            this.bgpPeerFsmEstTimeOid = ParameterMap.getKeyedString(parameters, (String)"bgpPeerFsmEstTimeOid", (String)(this.bgpBaseOid + BgpSessionMonitor.BGP_PEER_FSM_EST_TIME_SUFFIX));
        }
    }
}

