/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.flows.processing.impl;

import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.io.Closeable;
import java.io.File;
import java.io.Serializable;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.opennms.integration.api.v1.flows.Flow;
import org.opennms.netmgt.collection.api.CollectionAgent;
import org.opennms.netmgt.collection.api.CollectionAgentFactory;
import org.opennms.netmgt.collection.api.CollectionSet;
import org.opennms.netmgt.collection.api.CollectionSetVisitor;
import org.opennms.netmgt.collection.api.PersisterFactory;
import org.opennms.netmgt.collection.api.ServiceParameters;
import org.opennms.netmgt.collection.dto.CollectionSetDTO;
import org.opennms.netmgt.collection.support.builder.CollectionSetBuilder;
import org.opennms.netmgt.collection.support.builder.DeferredGenericTypeResource;
import org.opennms.netmgt.collection.support.builder.NodeLevelResource;
import org.opennms.netmgt.collection.support.builder.Resource;
import org.opennms.netmgt.dao.api.DistPollerDao;
import org.opennms.netmgt.dao.api.IpInterfaceDao;
import org.opennms.netmgt.dao.api.SessionUtils;
import org.opennms.netmgt.dao.api.SnmpInterfaceDao;
import org.opennms.netmgt.filter.api.FilterDao;
import org.opennms.netmgt.flows.classification.ClassificationEngine;
import org.opennms.netmgt.flows.classification.ClassificationRuleProvider;
import org.opennms.netmgt.flows.classification.FilterService;
import org.opennms.netmgt.flows.classification.persistence.api.Rule;
import org.opennms.netmgt.flows.processing.ProcessingOptions;
import org.opennms.netmgt.flows.processing.enrichment.EnrichedFlow;
import org.opennms.netmgt.model.OnmsIpInterface;
import org.opennms.netmgt.model.OnmsSnmpInterface;
import org.opennms.netmgt.rrd.RrdRepository;
import org.opennms.netmgt.telemetry.config.api.PackageDefinition;
import org.opennms.netmgt.threshd.api.ThresholdInitializationException;
import org.opennms.netmgt.threshd.api.ThresholdingService;
import org.opennms.netmgt.threshd.api.ThresholdingSession;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FlowThresholdingImpl
implements Closeable,
ClassificationEngine.ClassificationRulesReloadedListener {
    private static final Logger LOG = LoggerFactory.getLogger(FlowThresholdingImpl.class);
    public static final String NAME = "flowThreshold";
    public static final String SERVICE_NAME = "Flow-Threshold";
    public static final String RESOURCE_TYPE_NAME = "flowApp";
    public static final String RESOURCE_GROUP = "application";
    private final ThresholdingService thresholdingService;
    private final CollectionAgentFactory collectionAgentFactory;
    private final PersisterFactory persisterFactory;
    private final IpInterfaceDao ipInterfaceDao;
    private final SnmpInterfaceDao snmpInterfaceDao;
    private final FilterDao filterDao;
    private final SessionUtils sessionUtils;
    public final long systemIdHash;
    private final ConcurrentMap<ExporterKey, Session> sessions = Maps.newConcurrentMap();
    private long stepSizeMs = 0L;
    private volatile long idleTimeoutMs = 900000L;
    private Timer timer;
    private FilterService filterService;
    private ClassificationEngine classificationEngine;
    private List<Rule> classificationRuleList;
    private ReentrantReadWriteLock classificationRuleListReadWriteLock = new ReentrantReadWriteLock();

    public FlowThresholdingImpl(ThresholdingService thresholdingService, CollectionAgentFactory collectionAgentFactory, PersisterFactory persisterFactory, IpInterfaceDao ipInterfaceDao, DistPollerDao distPollerDao, SnmpInterfaceDao snmpInterfaceDao, FilterDao filterDao, SessionUtils sessionUtils, FilterService filterService, ClassificationRuleProvider classificationRuleProvider, ClassificationEngine classificationEngine) {
        this.thresholdingService = Objects.requireNonNull(thresholdingService);
        this.collectionAgentFactory = Objects.requireNonNull(collectionAgentFactory);
        this.persisterFactory = Objects.requireNonNull(persisterFactory);
        this.systemIdHash = (long)distPollerDao.whoami().getId().hashCode() << 32;
        this.ipInterfaceDao = Objects.requireNonNull(ipInterfaceDao);
        this.snmpInterfaceDao = Objects.requireNonNull(snmpInterfaceDao);
        this.filterDao = Objects.requireNonNull(filterDao);
        this.sessionUtils = Objects.requireNonNull(sessionUtils);
        this.filterService = Objects.requireNonNull(filterService);
        this.classificationRuleList = classificationRuleProvider.getRules();
        this.classificationEngine = Objects.requireNonNull(classificationEngine);
        this.classificationEngine.addClassificationRulesReloadedListener((ClassificationEngine.ClassificationRulesReloadedListener)this);
    }

    public void classificationRulesReloaded(List<Rule> classificationRuleList) {
        ReentrantReadWriteLock.WriteLock writeLock = this.classificationRuleListReadWriteLock.writeLock();
        writeLock.lock();
        try {
            this.classificationRuleList = classificationRuleList;
        }
        finally {
            writeLock.unlock();
        }
        LOG.debug("Classification rules reloaded. Marking sessions as dirty.");
        for (Session session : this.sessions.values()) {
            session.updateApplicationList(this.getListOfApplicationsToPersist(session.exporterIpAddress));
        }
    }

    public long getStepSizeMs() {
        return this.stepSizeMs;
    }

    public void setStepSizeMs(long stepSizeMs) {
        if (this.timer != null) {
            this.timer.cancel();
            this.timer = null;
            LOG.debug("Timer task stopped.");
        }
        this.stepSizeMs = stepSizeMs;
        if (this.stepSizeMs == 0L) {
            return;
        }
        this.timer = new Timer("Flow-Threshold-Timer", true);
        this.timer.schedule(new TimerTask(){

            @Override
            public void run() {
                try {
                    FlowThresholdingImpl.this.runTimerTask();
                }
                catch (Throwable ex) {
                    LOG.error("Thresholding timer bailed", ex);
                }
            }
        }, this.stepSizeMs, this.stepSizeMs);
        LOG.debug("Timer task re-scheduled (stepSizeMs={}ms, idleTimeoutMs={}ms).", (Object)this.stepSizeMs, (Object)this.idleTimeoutMs);
    }

    public long getIdleTimeoutMs() {
        return this.idleTimeoutMs;
    }

    public void setIdleTimeoutMs(long idleTimeoutMs) {
        this.idleTimeoutMs = idleTimeoutMs;
    }

    public void runTimerTask() {
        Date timerTaskDate = new Date();
        ArrayList idleSessions = Lists.newArrayList();
        LOG.debug("Running Timer task for {} session(s)...", (Object)this.sessions.entrySet().size());
        for (Map.Entry entry : this.sessions.entrySet()) {
            ExporterKey exporterKey = (ExporterKey)entry.getKey();
            Session session = (Session)entry.getValue();
            LOG.debug("Processing session={} for exporterKey={}...", (Object)session, (Object)exporterKey);
            if (session.lastUpdate != null && session.lastUpdate.isBefore(Instant.now().minus(this.idleTimeoutMs, ChronoUnit.MILLIS))) {
                idleSessions.add(exporterKey);
                continue;
            }
            OnmsIpInterface iface = (OnmsIpInterface)this.ipInterfaceDao.get((Serializable)Integer.valueOf(exporterKey.interfaceId));
            NodeLevelResource nodeResource = new NodeLevelResource(iface.getNodeId().intValue());
            for (Map.Entry<IndexKey, Map<String, AtomicLong>> indexEntry : session.indexKeyMap.entrySet()) {
                for (Map.Entry<String, AtomicLong> applicationEntry : indexEntry.getValue().entrySet()) {
                    try {
                        String ifName = this.getIfNameForNodeIdAndIfIndex(session.collectionAgent.getNodeId(), indexEntry.getKey().iface);
                        DeferredGenericTypeResource appResource = new DeferredGenericTypeResource(nodeResource, RESOURCE_TYPE_NAME, String.format("%s:%s", ifName, applicationEntry.getKey()));
                        CollectionSetDTO collectionSet = new CollectionSetBuilder(session.collectionAgent).withTimestamp(timerTaskDate).withSequenceNumber(Long.valueOf(session.sequenceNumber.getAndIncrement())).withCounter((Resource)appResource, RESOURCE_GROUP, indexEntry.getKey().direction == Flow.Direction.INGRESS ? "bytesIn" : "bytesOut", (Number)applicationEntry.getValue().get()).withStringAttribute((Resource)appResource, RESOURCE_GROUP, RESOURCE_GROUP, applicationEntry.getKey()).withStringAttribute((Resource)appResource, RESOURCE_GROUP, "ifName", ifName).build();
                        if (session.thresholding) {
                            LOG.trace("Checking thresholds for collection-set value={}, ifName={}, application={}, ds={}", new Object[]{applicationEntry.getValue().get(), ifName, applicationEntry.getKey(), indexEntry.getKey().direction == Flow.Direction.INGRESS ? "bytesIn" : "bytesOut"});
                            session.thresholdingSession.accept((CollectionSet)collectionSet);
                        }
                        if (!session.dataCollection) continue;
                        LOG.trace("Persisting data for collection-set value={}, ifName={}, application={}, ds={}", new Object[]{applicationEntry.getValue().get(), ifName, applicationEntry.getKey(), indexEntry.getKey().direction == Flow.Direction.INGRESS ? "bytesIn" : "bytesOut"});
                        RrdRepository repository = new RrdRepository();
                        repository.setStep(session.packageDefinition.getRrd().getStep().intValue());
                        repository.setHeartBeat(repository.getStep() * 2);
                        repository.setRraList(session.packageDefinition.getRrd().getRras());
                        repository.setRrdBaseDir(new File(session.packageDefinition.getRrd().getBaseDir()));
                        collectionSet.visit((CollectionSetVisitor)this.persisterFactory.createPersister(new ServiceParameters(Collections.emptyMap()), repository, false, false, true));
                    }
                    catch (ThresholdInitializationException e) {
                        LOG.warn("Error initializing thresholding session", (Throwable)e);
                    }
                }
            }
        }
        for (ExporterKey exporterKey : idleSessions) {
            LOG.debug("Dropping session for exporterKey={}", (Object)exporterKey);
            this.sessions.remove(exporterKey);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Set<String> getListOfApplicationsToPersist(String exporterIpAddress) {
        ReentrantReadWriteLock.ReadLock readLock = this.classificationRuleListReadWriteLock.readLock();
        readLock.lock();
        try {
            Set<String> set = this.classificationRuleList.stream().filter(r -> r.getExporterFilter() == null || this.filterService.matches(exporterIpAddress, r.getExporterFilter())).map(r -> r.getName()).collect(Collectors.toSet());
            return set;
        }
        finally {
            readLock.unlock();
        }
    }

    private String getIfNameForNodeIdAndIfIndex(int nodeId, int ifIndex) {
        OnmsSnmpInterface snmpInterface = this.snmpInterfaceDao.findByNodeIdAndIfIndex(Integer.valueOf(nodeId), Integer.valueOf(ifIndex));
        if (snmpInterface != null && !Strings.isNullOrEmpty((String)snmpInterface.getIfName())) {
            return snmpInterface.getIfName();
        }
        return Integer.toString(ifIndex);
    }

    public void threshold(List<EnrichedFlow> documents, ProcessingOptions options) throws ExecutionException, ThresholdInitializationException {
        if (!options.applicationThresholding && !options.applicationDataCollection) {
            return;
        }
        Instant now = Instant.now();
        for (EnrichedFlow document : documents) {
            if (document.getExporterNodeInfo() == null || Strings.isNullOrEmpty((String)document.getApplication())) continue;
            ExporterKey exporterKey = new ExporterKey(document.getExporterNodeInfo().getInterfaceId());
            Session session = this.sessions.computeIfAbsent(exporterKey, key -> (Session)this.sessionUtils.withTransaction(() -> {
                ThresholdingSession thresholdingSession;
                LOG.debug("Accepting session for exporterKey={}", (Object)exporterKey);
                OnmsIpInterface iface = (OnmsIpInterface)this.ipInterfaceDao.get((Serializable)Integer.valueOf(exporterKey.interfaceId));
                CollectionAgent collectionAgent = this.collectionAgentFactory.createCollectionAgent(iface);
                try {
                    thresholdingSession = this.thresholdingService.createSession(iface.getNodeId().intValue(), collectionAgent.getHostAddress(), SERVICE_NAME, new ServiceParameters(Collections.emptyMap()));
                }
                catch (ThresholdInitializationException e) {
                    throw new RuntimeException("Error initializing thresholding session", e);
                }
                PackageDefinition packageDefinition = null;
                for (PackageDefinition packageDefinition2 : options.packages) {
                    if (packageDefinition2.getFilterRule() != null && !this.filterDao.isValid(collectionAgent.getHostAddress(), packageDefinition2.getFilterRule())) continue;
                    packageDefinition = packageDefinition2;
                    break;
                }
                return new Session(thresholdingSession, collectionAgent, this.systemIdHash, options.applicationThresholding, options.applicationDataCollection, packageDefinition, collectionAgent.getHostAddress(), this.getListOfApplicationsToPersist(collectionAgent.getHostAddress()));
            }));
            session.process(now, document);
        }
    }

    public Set<ExporterKey> getExporterKeys() {
        return Collections.unmodifiableSet(this.sessions.keySet());
    }

    public Collection<Session> getSessions() {
        return Collections.unmodifiableCollection(this.sessions.values());
    }

    @Override
    public void close() {
        this.classificationEngine.removeClassificationRulesReloadedListener((ClassificationEngine.ClassificationRulesReloadedListener)this);
        if (this.timer != null) {
            this.timer.cancel();
            this.timer = null;
        }
        this.sessions.clear();
    }

    public static class ExporterKey {
        public final int interfaceId;

        public ExporterKey(int interfaceId) {
            this.interfaceId = interfaceId;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof ExporterKey)) {
                return false;
            }
            ExporterKey that = (ExporterKey)o;
            return Objects.equals(this.interfaceId, that.interfaceId);
        }

        public int hashCode() {
            return Objects.hash(this.interfaceId);
        }

        public String toString() {
            return "ExporterKey{interfaceId=" + this.interfaceId + "}";
        }
    }

    public static class IndexKey {
        public final int iface;
        public final Flow.Direction direction;

        public IndexKey(int iface, Flow.Direction direction) {
            this.iface = iface;
            this.direction = direction;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof IndexKey)) {
                return false;
            }
            IndexKey that = (IndexKey)o;
            return Objects.equals(this.iface, that.iface) && Objects.equals(this.direction, that.direction);
        }

        public int hashCode() {
            return Objects.hash(this.iface, this.direction);
        }

        public String toString() {
            return "IndexKey{iface=" + this.iface + ", direction=" + this.direction + "}";
        }
    }

    public static class Session {
        private static final Logger LOG = LoggerFactory.getLogger(Session.class);
        public final Map<IndexKey, Map<String, AtomicLong>> indexKeyMap = Maps.newConcurrentMap();
        public final boolean thresholding;
        public final boolean dataCollection;
        public final PackageDefinition packageDefinition;
        public final ThresholdingSession thresholdingSession;
        public final CollectionAgent collectionAgent;
        private volatile Instant lastUpdate = null;
        private final AtomicLong sequenceNumber;
        private final String exporterIpAddress;
        private ReentrantReadWriteLock applicationsReadWriteLock = new ReentrantReadWriteLock();
        private Set<String> applications;

        private Session(ThresholdingSession thresholdingSession, CollectionAgent collectionAgent, long systemIdHash, boolean thresholding, boolean dataCollection, PackageDefinition packageDefinition, String exporterIpAddress, Set<String> applicationsToPersist) {
            this.sequenceNumber = new AtomicLong(systemIdHash | (long)ThreadLocalRandom.current().nextInt());
            this.thresholdingSession = Objects.requireNonNull(thresholdingSession);
            this.collectionAgent = Objects.requireNonNull(collectionAgent);
            this.thresholding = thresholding;
            this.dataCollection = dataCollection;
            this.packageDefinition = packageDefinition;
            this.exporterIpAddress = exporterIpAddress;
            this.updateApplicationList(applicationsToPersist);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void updateApplicationList(Set<String> applications) {
            ReentrantReadWriteLock.WriteLock writeLock = this.applicationsReadWriteLock.writeLock();
            writeLock.lock();
            try {
                this.applications = applications;
                LOG.debug("Found {} matching applications for exporter {}", (Object)this.applications.size(), (Object)this.exporterIpAddress);
                for (IndexKey indexKey : this.indexKeyMap.keySet()) {
                    int beforeAdd = this.indexKeyMap.get(indexKey).size();
                    for (String application : this.applications) {
                        this.indexKeyMap.get(indexKey).computeIfAbsent(application, a -> new AtomicLong(0L));
                    }
                    int afterAddBeforePurge = this.indexKeyMap.get(indexKey).size();
                    LOG.debug("Added {} applications for {}/{}/{}", new Object[]{afterAddBeforePurge - beforeAdd, this.exporterIpAddress, indexKey.iface, indexKey.direction});
                    this.indexKeyMap.get(indexKey).keySet().retainAll(applications);
                    int afterPurge = this.indexKeyMap.get(indexKey).size();
                    LOG.debug("Removed {} applications for {}/{}/{}", new Object[]{afterAddBeforePurge - afterPurge, this.exporterIpAddress, indexKey.iface, indexKey.direction});
                }
            }
            finally {
                writeLock.unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void addValue(IndexKey indexKey, String application, long bytes) {
            if (!this.indexKeyMap.containsKey(indexKey)) {
                ReentrantReadWriteLock.ReadLock readLock = this.applicationsReadWriteLock.readLock();
                readLock.lock();
                try {
                    this.indexKeyMap.put(indexKey, this.applications.stream().collect(Collectors.toConcurrentMap(Function.identity(), e -> new AtomicLong(0L))));
                }
                finally {
                    readLock.unlock();
                }
            }
            this.indexKeyMap.get(indexKey).get(application).addAndGet(bytes);
        }

        public void process(Instant now, EnrichedFlow document) {
            IndexKey indexKey;
            if (document.getInputSnmp() != null && document.getInputSnmp() != 0 && (document.getDirection() == Flow.Direction.INGRESS || document.getDirection() == Flow.Direction.UNKNOWN)) {
                indexKey = new IndexKey(document.getInputSnmp(), Flow.Direction.INGRESS);
                this.addValue(indexKey, document.getApplication(), document.getBytes());
            }
            if (document.getOutputSnmp() != null && document.getOutputSnmp() != 0 && (document.getDirection() == Flow.Direction.EGRESS || document.getDirection() == Flow.Direction.UNKNOWN)) {
                indexKey = new IndexKey(document.getOutputSnmp(), Flow.Direction.EGRESS);
                this.addValue(indexKey, document.getApplication(), document.getBytes());
            }
            this.lastUpdate = now;
        }

        public Instant getLastUpdate() {
            return this.lastUpdate;
        }

        public String toString() {
            return "Session{thresholding=" + this.thresholding + ", dataCollection=" + this.dataCollection + ", lastUpdate=" + this.lastUpdate + ", sequenceNumber=" + this.sequenceNumber + ", exporterIpAddress=" + this.exporterIpAddress + "}";
        }
    }
}

