/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.flows.rest.internal;

import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import com.google.common.collect.Table;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.ws.rs.BadRequestException;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import org.apache.commons.collections.CollectionUtils;
import org.opennms.netmgt.dao.api.NodeDao;
import org.opennms.netmgt.dao.api.SessionUtils;
import org.opennms.netmgt.dao.api.SnmpInterfaceDao;
import org.opennms.netmgt.flows.api.Conversation;
import org.opennms.netmgt.flows.api.Directional;
import org.opennms.netmgt.flows.api.FlowQueryService;
import org.opennms.netmgt.flows.api.Host;
import org.opennms.netmgt.flows.api.LimitedCardinalityField;
import org.opennms.netmgt.flows.api.TrafficSummary;
import org.opennms.netmgt.flows.filter.api.DscpFilter;
import org.opennms.netmgt.flows.filter.api.ExporterNodeFilter;
import org.opennms.netmgt.flows.filter.api.Filter;
import org.opennms.netmgt.flows.filter.api.NodeCriteria;
import org.opennms.netmgt.flows.filter.api.SnmpInterfaceIdFilter;
import org.opennms.netmgt.flows.filter.api.TimeRangeFilter;
import org.opennms.netmgt.flows.rest.FlowRestService;
import org.opennms.netmgt.flows.rest.model.FlowGraphUrlInfo;
import org.opennms.netmgt.flows.rest.model.FlowNodeDetails;
import org.opennms.netmgt.flows.rest.model.FlowNodeSummary;
import org.opennms.netmgt.flows.rest.model.FlowSeriesColumn;
import org.opennms.netmgt.flows.rest.model.FlowSeriesResponse;
import org.opennms.netmgt.flows.rest.model.FlowSnmpInterface;
import org.opennms.netmgt.flows.rest.model.FlowSummaryResponse;
import org.opennms.netmgt.model.OnmsCategory;

public class FlowRestServiceImpl
implements FlowRestService {
    private final FlowQueryService flowQueryService;
    private final NodeDao nodeDao;
    private final SnmpInterfaceDao snmpInterfaceDao;
    private final SessionUtils sessionUtils;
    private String flowGraphUrl;
    private static Map<String, Supplier<Stream<Integer>>> DSCP_VALUE_SUPPLIER = new HashMap<String, Supplier<Stream<Integer>>>(){
        {
            int p = 0;
            while (p < 8) {
                int finalP = p++;
                this.put("P" + finalP, () -> Stream.of(finalP * 8, finalP * 8 + 2, finalP * 8 + 4, finalP * 8 + 6));
            }
            for (int c = 0; c < 8; ++c) {
                int finalC = c;
                this.put("CS" + finalC, () -> Stream.of(Integer.valueOf(finalC * 8)));
                if (finalC < 1 || finalC > 4) continue;
                int d = 1;
                while (d <= 3) {
                    int finalD = d++;
                    this.put("AF" + finalC + finalD, () -> Stream.of(Integer.valueOf(finalC * 8 + finalD * 2)));
                }
            }
            this.put("LE", () -> Stream.of(Integer.valueOf(1)));
            this.put("EF", () -> Stream.of(Integer.valueOf(46)));
        }
    };

    public FlowRestServiceImpl(FlowQueryService flowQueryService, NodeDao nodeDao, SnmpInterfaceDao snmpInterfaceDao, SessionUtils sessionUtils) {
        this.flowQueryService = Objects.requireNonNull(flowQueryService);
        this.nodeDao = Objects.requireNonNull(nodeDao);
        this.snmpInterfaceDao = Objects.requireNonNull(snmpInterfaceDao);
        this.sessionUtils = Objects.requireNonNull(sessionUtils);
    }

    public Long getFlowCount(UriInfo uriInfo) {
        return (Long)FlowRestServiceImpl.waitForFuture(this.flowQueryService.getFlowCount(FlowRestServiceImpl.getFiltersFromQueryString((MultivaluedMap<String, String>)uriInfo.getQueryParameters())));
    }

    public List<FlowNodeSummary> getFlowExporters() {
        return ((Stream)this.sessionUtils.withReadOnlyTransaction(() -> this.nodeDao.findAllHavingFlows().stream())).map(n -> new FlowNodeSummary(n.getId(), n.getForeignId(), n.getForeignSource(), n.getLabel(), n.getCategories().stream().map(OnmsCategory::getName).collect(Collectors.toList()))).sorted(Comparator.comparingInt(FlowNodeSummary::getId)).collect(Collectors.toList());
    }

    public FlowNodeDetails getFlowExporter(Integer nodeId) {
        List ifaces = ((List)this.sessionUtils.withReadOnlyTransaction(() -> this.snmpInterfaceDao.findAllHavingFlows(nodeId))).stream().map(iface -> new FlowSnmpInterface(iface.getIfIndex(), iface.getIfName(), iface.getIfAlias(), iface.getIfDescr())).collect(Collectors.toList());
        return new FlowNodeDetails(nodeId.intValue(), ifaces);
    }

    private List<Integer> getFieldValues(LimitedCardinalityField field, UriInfo uriInfo) {
        List<Filter> filters = FlowRestServiceImpl.getFiltersFromQueryString((MultivaluedMap<String, String>)uriInfo.getQueryParameters());
        return ((List)FlowRestServiceImpl.waitForFuture(this.flowQueryService.getFieldValues(field, filters))).stream().map(Integer::valueOf).sorted().collect(Collectors.toList());
    }

    private FlowSummaryResponse getFieldSummaries(LimitedCardinalityField field, UriInfo uriInfo) {
        List<Filter> filters = FlowRestServiceImpl.getFiltersFromQueryString((MultivaluedMap<String, String>)uriInfo.getQueryParameters());
        TimeRangeFilter timeRangeFilter = FlowRestServiceImpl.getRequiredTimeRangeFilter(filters);
        FlowSummaryResponse response = new FlowSummaryResponse();
        response.setStart(timeRangeFilter.getStart());
        response.setEnd(timeRangeFilter.getEnd());
        List summary = (List)FlowRestServiceImpl.waitForFuture(this.flowQueryService.getFieldSummaries(field, filters));
        this.defaultSummaryResponseConsumer(field.name(), Object::toString).apply(response).accept(summary);
        return response;
    }

    private FlowSeriesResponse getFieldSeries(LimitedCardinalityField field, long step, UriInfo uriInfo) {
        List<Filter> filters = FlowRestServiceImpl.getFiltersFromQueryString((MultivaluedMap<String, String>)uriInfo.getQueryParameters());
        TimeRangeFilter timeRangeFilter = FlowRestServiceImpl.getRequiredTimeRangeFilter(filters);
        FlowSeriesResponse response = new FlowSeriesResponse();
        response.setStart(timeRangeFilter.getStart());
        response.setEnd(timeRangeFilter.getEnd());
        Table series = (Table)FlowRestServiceImpl.waitForFuture(this.flowQueryService.getFieldSeries(field, step, filters));
        this.defaultSeriesReponseConsumer(Object::toString).apply(response).accept((Table<Directional<String>, Long, Double>)series);
        FlowRestServiceImpl.populateResponseFromTable(series, response);
        return response;
    }

    public List<Integer> getDscpValues(UriInfo uriInfo) {
        return this.getFieldValues(LimitedCardinalityField.DSCP, uriInfo);
    }

    public FlowSummaryResponse getDscpSummaries(UriInfo uriInfo) {
        return this.getFieldSummaries(LimitedCardinalityField.DSCP, uriInfo);
    }

    public FlowSeriesResponse getDscpSeries(long step, UriInfo uriInfo) {
        return this.getFieldSeries(LimitedCardinalityField.DSCP, step, uriInfo);
    }

    public List<String> getApplications(String matchingPrefix, long limit, UriInfo uriInfo) {
        List<Filter> filters = FlowRestServiceImpl.getFiltersFromQueryString((MultivaluedMap<String, String>)uriInfo.getQueryParameters());
        return (List)FlowRestServiceImpl.waitForFuture(this.flowQueryService.getApplications(matchingPrefix, limit, filters));
    }

    public FlowSummaryResponse getApplicationSummary(Integer N, Set<String> applications, boolean includeOther, UriInfo uriInfo) {
        return this.getSummary(N, applications, uriInfo, "application", filters -> this.flowQueryService.getTopNApplicationSummaries(N.intValue(), includeOther, filters), filters -> this.flowQueryService.getApplicationSummaries(applications, includeOther, filters), this.defaultSummaryResponseConsumer("Application", Function.identity()));
    }

    public FlowSeriesResponse getApplicationSeries(long step, Integer N, Set<String> applications, boolean includeOther, UriInfo uriInfo) {
        return this.getSeries(N, applications, uriInfo, "application", filters -> this.flowQueryService.getTopNApplicationSeries(N.intValue(), step, includeOther, filters), filters -> this.flowQueryService.getApplicationSeries(applications, step, includeOther, filters), this.defaultSeriesReponseConsumer(Function.identity()));
    }

    public List<String> getHosts(String regex, long limit, UriInfo uriInfo) {
        List<Filter> filters = FlowRestServiceImpl.getFiltersFromQueryString((MultivaluedMap<String, String>)uriInfo.getQueryParameters());
        return (List)FlowRestServiceImpl.waitForFuture(this.flowQueryService.getHosts(regex, limit, filters));
    }

    public FlowSummaryResponse getHostSummary(Integer N, Set<String> hosts, boolean includeOther, UriInfo uriInfo) {
        HostnameMode hostnameMode = FlowRestServiceImpl.getHostnameModeFromQueryString((MultivaluedMap<String, String>)uriInfo.getQueryParameters());
        return this.getSummary(N, hosts, uriInfo, "host", filters -> this.flowQueryService.getTopNHostSummaries(N.intValue(), includeOther, filters), filters -> this.flowQueryService.getHostSummaries(hosts, includeOther, filters), this.defaultSummaryResponseConsumer("Host", hostnameMode::buildDisplayName));
    }

    public FlowSeriesResponse getHostSeries(long step, Integer N, Set<String> hosts, boolean includeOther, UriInfo uriInfo) {
        HostnameMode hostnameMode = FlowRestServiceImpl.getHostnameModeFromQueryString((MultivaluedMap<String, String>)uriInfo.getQueryParameters());
        return this.getSeries(N, hosts, uriInfo, "host", filters -> this.flowQueryService.getTopNHostSeries(N.intValue(), step, includeOther, filters), filters -> this.flowQueryService.getHostSeries(hosts, step, includeOther, filters), this.defaultSeriesReponseConsumer(hostnameMode::buildDisplayName));
    }

    public List<String> getConversations(String locationPattern, String protocolPattern, String lowerIPPattern, String upperIPPattern, String applicationPattern, long limit, UriInfo uriInfo) {
        List<Filter> filters = FlowRestServiceImpl.getFiltersFromQueryString((MultivaluedMap<String, String>)uriInfo.getQueryParameters());
        return (List)FlowRestServiceImpl.waitForFuture(this.flowQueryService.getConversations(locationPattern, protocolPattern, lowerIPPattern, upperIPPattern, applicationPattern, limit, filters));
    }

    public FlowSummaryResponse getConversationSummary(Integer N, Set<String> conversations, boolean includeOther, UriInfo uriInfo) {
        HostnameMode hostnameMode = FlowRestServiceImpl.getHostnameModeFromQueryString((MultivaluedMap<String, String>)uriInfo.getQueryParameters());
        return this.getSummary(N, conversations, uriInfo, "conversation", filters -> this.flowQueryService.getTopNConversationSummaries(N.intValue(), includeOther, filters), filters -> this.flowQueryService.getConversationSummaries(conversations, includeOther, filters), response -> summary -> {
            response.setHeaders((List)Lists.newArrayList((Object[])new String[]{"Location", "Protocol", "Source", "Dest.", "Application", "Bytes In", "Bytes Out", "ECN"}));
            response.setRows(summary.stream().map(sum -> {
                Conversation conversation = (Conversation)sum.getEntity();
                return Lists.newArrayList((Object[])new Object[]{conversation.getLocation(), conversation.getProtocol(), hostnameMode.buildDisplayName(conversation.getLowerHost()), hostnameMode.buildDisplayName(conversation.getUpperHost()), conversation.getApplication(), sum.getBytesIn(), sum.getBytesOut(), sum.ecnInfo()});
            }).collect(Collectors.toList()));
        });
    }

    public FlowSeriesResponse getConversationSeries(long step, Integer N, Set<String> conversations, boolean includeOther, UriInfo uriInfo) {
        HostnameMode hostnameMode = FlowRestServiceImpl.getHostnameModeFromQueryString((MultivaluedMap<String, String>)uriInfo.getQueryParameters());
        return this.getSeries(N, conversations, uriInfo, "conversation", filters -> this.flowQueryService.getTopNConversationSeries(N.intValue(), step, includeOther, filters), filters -> this.flowQueryService.getConversationSeries(conversations, step, includeOther, filters), response -> series -> response.setColumns(series.rowKeySet().stream().map(d -> {
            Conversation conversation = (Conversation)d.getValue();
            String applicationTag = conversation.getApplication() != null ? String.format(" : %s", conversation.getApplication()) : "";
            FlowSeriesColumn column = new FlowSeriesColumn();
            column.setLabel(String.format("%s <-> %s%s", hostnameMode.buildDisplayName(conversation.getLowerHost()), hostnameMode.buildDisplayName(conversation.getUpperHost()), applicationTag));
            column.setIngress(d.isIngress());
            return column;
        }).collect(Collectors.toList())));
    }

    public FlowGraphUrlInfo getFlowGraphUrlInfo(UriInfo uriInfo) {
        if (Strings.isNullOrEmpty((String)this.flowGraphUrl)) {
            return null;
        }
        long flowCount = (Long)FlowRestServiceImpl.waitForFuture(this.flowQueryService.getFlowCount(FlowRestServiceImpl.getFiltersFromQueryString((MultivaluedMap<String, String>)uriInfo.getQueryParameters())));
        FlowGraphUrlInfo graphUrlInfo = new FlowGraphUrlInfo();
        MultivaluedMap queryParams = uriInfo.getQueryParameters();
        String flowUrl = this.getFlowGraphUrl();
        String formattedGraphUrl = flowUrl.replaceAll("\\$nodeId", FlowRestServiceImpl.getFirstNonNull((MultivaluedMap<String, String>)queryParams, "exporterNode")).replaceAll("\\$ifIndex", FlowRestServiceImpl.getFirstNonNull((MultivaluedMap<String, String>)queryParams, "ifIndex")).replaceAll("\\$start", FlowRestServiceImpl.getFirstNonNull((MultivaluedMap<String, String>)queryParams, "start")).replaceAll("\\$end", FlowRestServiceImpl.getFirstNonNull((MultivaluedMap<String, String>)queryParams, "end"));
        graphUrlInfo.setFlowGraphUrl(formattedGraphUrl);
        graphUrlInfo.setFlowCount(flowCount);
        return graphUrlInfo;
    }

    public String getFlowGraphUrl() {
        return this.flowGraphUrl;
    }

    public void setFlowGraphUrl(String flowGraphUrl) {
        this.flowGraphUrl = flowGraphUrl;
    }

    private void withValidationAndFilters(Integer N, Set<String> entities, String entitiesLabel, UriInfo uriInfo, BiConsumer<List<Filter>, TimeRangeFilter> filterConsumer) {
        FlowRestServiceImpl.validateNOrSetQueryParameters(N, entities, entitiesLabel);
        List<Filter> filters = FlowRestServiceImpl.getFiltersFromQueryString((MultivaluedMap<String, String>)uriInfo.getQueryParameters());
        TimeRangeFilter timeRangeFilter = FlowRestServiceImpl.getRequiredTimeRangeFilter(filters);
        filterConsumer.accept(filters, timeRangeFilter);
    }

    private <T> FlowSummaryResponse getSummary(Integer N, Set<String> entities, UriInfo uriInfo, String entitiesLabel, Function<List<Filter>, CompletableFuture<List<TrafficSummary<T>>>> topNSummaryProviderFunction, Function<List<Filter>, CompletableFuture<List<TrafficSummary<T>>>> specificEntitiesSummaryProviderFunction, Function<FlowSummaryResponse, Consumer<List<TrafficSummary<T>>>> responseConsumer) {
        FlowSummaryResponse response = new FlowSummaryResponse();
        this.withValidationAndFilters(N, entities, entitiesLabel, uriInfo, (filters, timeRangeFilter) -> {
            List summary = N != null ? (List)FlowRestServiceImpl.waitForFuture((CompletableFuture)topNSummaryProviderFunction.apply((List<Filter>)filters)) : (List)FlowRestServiceImpl.waitForFuture((CompletableFuture)specificEntitiesSummaryProviderFunction.apply((List<Filter>)filters));
            response.setStart(timeRangeFilter.getStart());
            response.setEnd(timeRangeFilter.getEnd());
            ((Consumer)responseConsumer.apply(response)).accept(summary);
        });
        return response;
    }

    private <T> FlowSeriesResponse getSeries(Integer N, Set<String> entities, UriInfo uriInfo, String entitiesLabel, Function<List<Filter>, CompletableFuture<Table<Directional<T>, Long, Double>>> topNSeriesFutureFunction, Function<List<Filter>, CompletableFuture<Table<Directional<T>, Long, Double>>> specificEntitiesSeriesFutureFunction, Function<FlowSeriesResponse, Consumer<Table<Directional<T>, Long, Double>>> seriesResponseConsumer) {
        FlowSeriesResponse response = new FlowSeriesResponse();
        this.withValidationAndFilters(N, entities, entitiesLabel, uriInfo, (filters, timeRangeFilter) -> {
            Table series = N != null ? (Table)FlowRestServiceImpl.waitForFuture((CompletableFuture)topNSeriesFutureFunction.apply((List<Filter>)filters)) : (Table)FlowRestServiceImpl.waitForFuture((CompletableFuture)specificEntitiesSeriesFutureFunction.apply((List<Filter>)filters));
            response.setStart(timeRangeFilter.getStart());
            response.setEnd(timeRangeFilter.getEnd());
            ((Consumer)seriesResponseConsumer.apply(response)).accept(series);
            FlowRestServiceImpl.populateResponseFromTable(series, response);
        });
        return response;
    }

    private <K> Function<FlowSummaryResponse, Consumer<List<TrafficSummary<K>>>> defaultSummaryResponseConsumer(String entitiesHeader, Function<K, String> entityLabel) {
        return response -> summary -> {
            response.setHeaders((List)Lists.newArrayList((Object[])new String[]{entitiesHeader, "Bytes In", "Bytes Out", "ECN"}));
            response.setRows(summary.stream().map(sum -> Lists.newArrayList((Object[])new Object[]{entityLabel.apply(sum.getEntity()), sum.getBytesIn(), sum.getBytesOut(), sum.ecnInfo()})).collect(Collectors.toList()));
        };
    }

    private <K> Function<FlowSeriesResponse, Consumer<Table<Directional<K>, Long, Double>>> defaultSeriesReponseConsumer(Function<K, String> entityLabel) {
        return response -> series -> response.setColumns(series.rowKeySet().stream().map(d -> {
            FlowSeriesColumn column = new FlowSeriesColumn();
            column.setLabel((String)entityLabel.apply(d.getValue()));
            column.setIngress(d.isIngress());
            return column;
        }).collect(Collectors.toList()));
    }

    protected static List<Filter> getFiltersFromQueryString(MultivaluedMap<String, String> queryParams) {
        List dscpStr;
        String exporterNodeCriteria;
        ArrayList<Filter> filters = new ArrayList<Filter>();
        String start = (String)queryParams.getFirst((Object)"start");
        long startMs = start != null ? Long.parseLong(start) : -TimeUnit.HOURS.toMillis(4L);
        String end = (String)queryParams.getFirst((Object)"end");
        long endMs = end != null ? Long.parseLong(end) : System.currentTimeMillis();
        endMs = FlowRestServiceImpl.getEffectiveEnd(endMs);
        startMs = FlowRestServiceImpl.getEffectiveStart(startMs, endMs);
        filters.add((Filter)new TimeRangeFilter(startMs, endMs));
        String ifIndexStr = (String)queryParams.getFirst((Object)"ifIndex");
        if (ifIndexStr != null) {
            int ifIndex = Integer.parseInt(ifIndexStr);
            filters.add((Filter)new SnmpInterfaceIdFilter(ifIndex));
        }
        if ((exporterNodeCriteria = (String)queryParams.getFirst((Object)"exporterNode")) != null) {
            try {
                filters.add((Filter)new ExporterNodeFilter(new NodeCriteria(exporterNodeCriteria)));
            }
            catch (IllegalArgumentException e) {
                throw new BadRequestException("Invalid node criteria: " + exporterNodeCriteria);
            }
        }
        if (CollectionUtils.isNotEmpty((Collection)(dscpStr = (List)queryParams.get((Object)"dscp")))) {
            filters.add((Filter)new DscpFilter(dscpStr.stream().flatMap(str -> {
                Supplier<Stream<Integer>> s = DSCP_VALUE_SUPPLIER.get(str.toUpperCase());
                return s != null ? s.get() : Stream.of(Integer.valueOf(Integer.parseInt(str)));
            }).distinct().collect(Collectors.toList())));
        }
        return filters;
    }

    private static TimeRangeFilter getRequiredTimeRangeFilter(Collection<Filter> filters) {
        Optional<TimeRangeFilter> filter = filters.stream().filter(f -> f instanceof TimeRangeFilter).map(f -> (TimeRangeFilter)f).findFirst();
        if (!filter.isPresent()) {
            throw new BadRequestException("Time range is required.");
        }
        return filter.get();
    }

    private static long getEffectiveStart(long start, long effectiveEnd) {
        long effectiveStart = start >= 0L ? start : effectiveEnd + start;
        effectiveStart = Math.max(effectiveStart, 0L);
        return effectiveStart;
    }

    private static long getEffectiveEnd(long end) {
        return end > 0L ? end : new Date().getTime();
    }

    private static HostnameMode getHostnameModeFromQueryString(MultivaluedMap<String, String> queryParams) {
        String hostname_mode;
        switch (hostname_mode = Strings.nullToEmpty((String)((String)queryParams.getFirst((Object)"hostname_mode"))).toLowerCase()) {
            case "hide": {
                return HostnameMode.HIDE;
            }
            case "append": {
                return HostnameMode.APPEND;
            }
        }
        return HostnameMode.REPLACE;
    }

    private static <T> T waitForFuture(CompletableFuture<T> future) {
        try {
            return future.get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw new WebApplicationException("Failed to execute query: " + e.getMessage(), (Throwable)e);
        }
    }

    private static void populateResponseFromTable(Table<?, Long, Double> table, FlowSeriesResponse response) {
        List timestamps = table.columnKeySet().stream().sorted(Comparator.naturalOrder()).collect(Collectors.toList());
        LinkedList values = new LinkedList();
        for (Object rowKey : table.rowKeySet()) {
            ArrayList<Double> column = new ArrayList<Double>(timestamps.size());
            for (Long ts : timestamps) {
                Double val = (Double)table.get(rowKey, (Object)ts);
                if (val == null) {
                    val = Double.NaN;
                }
                column.add(val);
            }
            values.add(column);
        }
        response.setTimestamps(timestamps);
        response.setValues(values);
    }

    private static String getFirstNonNull(MultivaluedMap<String, String> map, String key) {
        String value = (String)map.getFirst((Object)key);
        return value != null ? value : "";
    }

    private static boolean isNullOrEmptyOrContainsNullOrEmpty(Collection<String> collection) {
        return collection == null || collection.isEmpty() || collection.contains(null) || collection.contains("");
    }

    private static void validateNOrSetQueryParameters(Integer N, Collection<String> collection, String collectionName) {
        if (N == null && FlowRestServiceImpl.isNullOrEmptyOrContainsNullOrEmpty(collection)) {
            throw new WebApplicationException(Response.status((Response.Status)Response.Status.BAD_REQUEST).type("text/plain").entity((Object)String.format("One of 'N' or '%s' query parameters must be present", collectionName)).build());
        }
        if (N != null && !FlowRestServiceImpl.isNullOrEmptyOrContainsNullOrEmpty(collection)) {
            throw new WebApplicationException(Response.status((Response.Status)Response.Status.BAD_REQUEST).type("text/plain").entity((Object)String.format("Only one of 'N' or '%s' query parameters should be set", collectionName)).build());
        }
    }

    static enum HostnameMode {
        HIDE{

            @Override
            public String buildDisplayName(Host host) {
                return host.getIp();
            }
        }
        ,
        APPEND{

            @Override
            public String buildDisplayName(Host host) {
                return host.getHostname().map(name -> String.format("%s [%s]", host.getIp(), name)).orElse(host.getIp());
            }
        }
        ,
        REPLACE{

            @Override
            public String buildDisplayName(Host host) {
                return host.getHostname().orElse(host.getIp());
            }
        };


        public abstract String buildDisplayName(Host var1);
    }
}

