/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.jicmp.jna;

import com.sun.jna.LastErrorException;
import com.sun.jna.Native;
import com.sun.jna.Pointer;
import com.sun.jna.ptr.IntByReference;
import java.io.IOException;
import java.net.UnknownHostException;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import org.opennms.jicmp.jna.NativeDatagramPacket;
import org.opennms.jicmp.jna.NativeDatagramSocket;
import org.opennms.jicmp.jna.sun_sockaddr_in6;

public class SunV6NativeSocket
extends NativeDatagramSocket {
    private static final int IPV6_TCLASS = 38;
    private final int m_sock;

    public SunV6NativeSocket(int family, int type, int protocol, int listenPort) throws Exception {
        this.m_sock = this.socket(family, type, protocol);
        sun_sockaddr_in6 in_addr = new sun_sockaddr_in6(listenPort);
        this.bind(this.m_sock, in_addr, in_addr.size());
    }

    public native int bind(int var1, sun_sockaddr_in6 var2, int var3) throws LastErrorException;

    public native int socket(int var1, int var2, int var3) throws LastErrorException;

    @Override
    public native int setsockopt(int var1, int var2, int var3, Pointer var4, int var5);

    public native int sendto(int var1, Buffer var2, int var3, int var4, sun_sockaddr_in6 var5, int var6) throws LastErrorException;

    public native int recvfrom(int var1, Buffer var2, int var3, int var4, sun_sockaddr_in6 var5, int[] var6) throws LastErrorException;

    public native int close(int var1) throws LastErrorException;

    @Override
    public void setTrafficClass(int tc) throws LastErrorException {
        IntByReference tc_ptr = new IntByReference(tc);
        try {
            this.setsockopt(this.getSock(), 41, 38, tc_ptr.getPointer(), Native.POINTER_SIZE);
        }
        catch (LastErrorException e) {
            throw new RuntimeException("setsockopt: " + this.strerror(e.getErrorCode()));
        }
    }

    @Override
    public void allowFragmentation(boolean frag) throws IOException {
        this.allowFragmentation(41, 62, frag);
    }

    @Override
    public int receive(NativeDatagramPacket p) throws UnknownHostException {
        sun_sockaddr_in6 in_addr = new sun_sockaddr_in6();
        int[] szRef = new int[]{in_addr.size()};
        ByteBuffer buf = p.getContent();
        int n = this.recvfrom(this.getSock(), buf, buf.capacity(), 0, in_addr, szRef);
        p.setLength(n);
        p.setAddress(in_addr.getAddress());
        p.setPort(in_addr.getPort());
        return n;
    }

    @Override
    public int send(NativeDatagramPacket p) {
        ByteBuffer buf = p.getContent();
        sun_sockaddr_in6 destAddr = new sun_sockaddr_in6(p.getAddress(), p.getPort());
        return this.sendto(this.getSock(), buf, buf.remaining(), 0, destAddr, destAddr.size());
    }

    @Override
    public void close() {
        this.close(this.getSock());
    }

    @Override
    public int getSock() {
        return this.m_sock;
    }

    static {
        Native.register((String)null);
    }
}

