/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.events.api;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.opennms.netmgt.events.api.EventDatabaseConstants;
import org.opennms.netmgt.xml.event.Event;
import org.opennms.netmgt.xml.event.Parm;
import org.opennms.netmgt.xml.event.Value;

public abstract class EventParameterUtils {
    public static String format(Event event) {
        if (event == null || event.getParmCollection() == null || event.getParmCollection().size() == 0) {
            return null;
        }
        boolean first = true;
        StringBuilder parmbuf = new StringBuilder();
        for (Parm parm : event.getParmCollection()) {
            if (parm.getParmName() == null || parm.getValue() == null || parm.getValue().getContent() == null) continue;
            if (!first) {
                parmbuf.append(';');
            }
            parmbuf.append(EventParameterUtils.format(parm));
            first = false;
        }
        return parmbuf.toString();
    }

    public static String format(Parm parm) {
        Value pValue = parm.getValue();
        String type = pValue.getType();
        String encoding = pValue.getEncoding();
        String tmp = EventDatabaseConstants.escape(parm.getParmName(), '=');
        String name = EventDatabaseConstants.escape(tmp, ';');
        tmp = EventDatabaseConstants.escape(pValue.getContent(), '=');
        String value = EventDatabaseConstants.escape(tmp, ';');
        String empty = "";
        name = name != null ? name.trim() : empty;
        value = value != null ? value.trim() : empty;
        type = type != null ? type.trim() : empty;
        encoding = encoding != null ? encoding.trim() : empty;
        StringBuilder buf = new StringBuilder();
        buf.append(name);
        buf.append('=');
        buf.append(value);
        buf.append('(');
        buf.append(type);
        buf.append(',');
        buf.append(encoding);
        buf.append(')');
        return buf.toString();
    }

    public static List<Parm> decode(String eventparms) {
        if (eventparms == null) {
            return null;
        }
        ArrayList<Parm> parms = new ArrayList<Parm>();
        String[] paramslistString = eventparms.split(Character.toString(';'));
        if (paramslistString != null) {
            for (int i = 0; i < paramslistString.length; ++i) {
                String[] paramEncoded = paramslistString[i].split(Character.toString('='));
                if (paramEncoded == null || paramEncoded.length != 2) continue;
                Parm parm = new Parm();
                parm.setParmName(paramEncoded[0]);
                Value value = new Value();
                int startParamType = paramEncoded[1].lastIndexOf(40);
                if (startParamType == -1) {
                    value.setContent(paramEncoded[1]);
                    value.setType("string");
                    value.setEncoding("text");
                } else {
                    value.setContent(paramEncoded[1].substring(0, startParamType));
                    String paramType = paramEncoded[1].substring(startParamType + 1);
                    String[] typeAndEncode = paramType.split(Character.toString(','));
                    if (typeAndEncode != null && typeAndEncode.length == 2) {
                        value.setType(typeAndEncode[0]);
                        value.setEncoding(typeAndEncode[1].split("\\)")[0]);
                    } else {
                        value.setType("string");
                        value.setEncoding("text");
                    }
                }
                parm.setValue(value);
                parms.add(parm);
            }
        }
        return parms;
    }

    public static Map<String, Parm> normalize(List<Parm> parmList) {
        return parmList.stream().collect(Collectors.toMap(Parm::getParmName, Function.identity(), (p1, p2) -> p2));
    }

    public static List<Parm> normalizePreserveOrder(List<Parm> parmList) {
        Objects.requireNonNull(parmList);
        HashSet<String> existingNames = new HashSet<String>();
        LinkedList<Parm> filteredList = new LinkedList<Parm>();
        for (int i = parmList.size() - 1; i >= 0; --i) {
            Parm parm = parmList.get(i);
            if (existingNames.contains(parm.getParmName())) continue;
            filteredList.addFirst(parm);
            existingNames.add(parm.getParmName());
        }
        return filteredList;
    }
}

