/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.features.apilayer.events;

import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Consumer;
import org.opennms.features.apilayer.utils.ModelMappers;
import org.opennms.integration.api.v1.events.EventListener;
import org.opennms.netmgt.events.api.EventSubscriptionService;
import org.opennms.netmgt.events.api.ThreadAwareEventListener;
import org.opennms.netmgt.events.api.model.IEvent;
import org.opennms.netmgt.xml.event.Event;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EventSubscriptionServiceImpl
implements org.opennms.integration.api.v1.events.EventSubscriptionService {
    private static final Logger LOG = LoggerFactory.getLogger(EventSubscriptionServiceImpl.class);
    private final EventSubscriptionService delegate;
    private final Map<EventListener, EventListenerAdapter> eventListenerToAdapterMap = new LinkedHashMap<EventListener, EventListenerAdapter>();

    public EventSubscriptionServiceImpl(EventSubscriptionService delegate) {
        this.delegate = delegate;
    }

    public void addEventListener(EventListener listener) {
        this.addListener(listener, arg_0 -> ((EventSubscriptionService)this.delegate).addEventListener(arg_0));
    }

    public void addEventListener(EventListener listener, Collection<String> ueis) {
        this.addListener(listener, l -> this.delegate.addEventListener((org.opennms.netmgt.events.api.EventListener)l, ueis));
    }

    public void addEventListener(EventListener listener, String uei) {
        this.addListener(listener, l -> this.delegate.addEventListener((org.opennms.netmgt.events.api.EventListener)l, uei));
    }

    public void removeEventListener(EventListener listener) {
        this.removeListener(listener, arg_0 -> ((EventSubscriptionService)this.delegate).removeEventListener(arg_0));
    }

    public void removeEventListener(EventListener listener, Collection<String> ueis) {
        this.removeListener(listener, l -> this.delegate.removeEventListener((org.opennms.netmgt.events.api.EventListener)l, ueis));
    }

    public void removeEventListener(EventListener listener, String uei) {
        this.removeListener(listener, l -> this.delegate.removeEventListener((org.opennms.netmgt.events.api.EventListener)l, uei));
    }

    public boolean hasEventListener(String uei) {
        return this.delegate.hasEventListener(uei);
    }

    private void addListener(EventListener listener, Consumer<EventListenerAdapter> addition) {
        EventListenerAdapter adapter = this.getOrCreateAdapter(listener);
        addition.accept(adapter);
        adapter.incrementReferenceCount();
    }

    private void removeListener(EventListener listener, Consumer<EventListenerAdapter> removal) {
        EventListenerAdapter adapter = this.eventListenerToAdapterMap.get(listener);
        if (adapter != null) {
            removal.accept(adapter);
            if (adapter.decrementReferenceCount() <= 0L) {
                this.eventListenerToAdapterMap.remove(listener);
                this.delegate.removeEventListener((org.opennms.netmgt.events.api.EventListener)adapter);
            }
        }
    }

    private EventListenerAdapter getOrCreateAdapter(EventListener listener) {
        return this.eventListenerToAdapterMap.computeIfAbsent(listener, EventListenerAdapter::new);
    }

    private static class EventListenerAdapter
    implements org.opennms.netmgt.events.api.EventListener,
    ThreadAwareEventListener {
        private final EventListener delegate;
        private final AtomicLong references = new AtomicLong(0L);

        EventListenerAdapter(EventListener delegate) {
            this.delegate = Objects.requireNonNull(delegate);
        }

        public String getName() {
            return this.delegate.getName();
        }

        public int getNumThreads() {
            return this.delegate.getNumThreads();
        }

        public void onEvent(IEvent event) {
            if (event == null || event.getUei() == null) {
                return;
            }
            try {
                this.delegate.onEvent(ModelMappers.toEvent((Event)Event.copyFrom((IEvent)event)));
            }
            catch (Exception e) {
                LOG.error("Error occurred while handling event with UEI='{}' on: {}. Error: {}", new Object[]{event.getUei(), this, e.getMessage(), e});
            }
        }

        public void incrementReferenceCount() {
            this.references.incrementAndGet();
        }

        public long decrementReferenceCount() {
            return this.references.decrementAndGet();
        }

        public String toString() {
            return "EventListenerAdapter{delegate=" + this.delegate + ", references=" + this.references + "}";
        }
    }
}

