/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.features.apilayer.config;

import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.opennms.core.config.api.ConfigurationProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ConfigExtensionManager<E, C>
implements ConfigurationProvider {
    private static final Logger LOG = LoggerFactory.getLogger(ConfigExtensionManager.class);
    private final ReadWriteLock rwLock = new ReentrantReadWriteLock();
    private final Set<E> extensions = new LinkedHashSet();
    private final Class<C> clazz;
    private volatile C configObject;
    private volatile long lastUpdate = System.currentTimeMillis();

    public ConfigExtensionManager(Class<C> clazz, C initialObject) {
        this.clazz = Objects.requireNonNull(clazz);
        this.configObject = Objects.requireNonNull(initialObject);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onBind(E extension, Map properties) {
        boolean didUpdate = false;
        this.rwLock.writeLock().lock();
        try {
            LOG.debug("bind called with {}: {}", extension, (Object)properties);
            if (extension != null) {
                this.extensions.add(extension);
                this.configObject = this.getConfigForExtensions(this.extensions);
                this.lastUpdate = System.currentTimeMillis();
                didUpdate = true;
            }
        }
        finally {
            this.rwLock.writeLock().unlock();
        }
        if (didUpdate) {
            this.triggerReload();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onUnbind(E extension, Map properties) {
        boolean didUpdate = false;
        this.rwLock.writeLock().lock();
        try {
            LOG.debug("unbind called with {}: {}", extension, (Object)properties);
            if (extension != null) {
                this.extensions.remove(extension);
                this.configObject = this.getConfigForExtensions(this.extensions);
                this.lastUpdate = System.currentTimeMillis();
                didUpdate = true;
            }
        }
        finally {
            this.rwLock.writeLock().unlock();
        }
        if (didUpdate) {
            this.triggerReload();
        }
    }

    public void registeredToConfigReloadContainer() {
        LOG.debug("registeredToConfigReloadContainer - class: {}; clazz: {}", (Object)this.getClass().getCanonicalName(), (Object)this.clazz.getCanonicalName());
        this.triggerReload();
    }

    public void deregisteredFromConfigReloadContainer() {
        LOG.debug("registeredToConfigReloadContainer - class: {}; clazz: {}", (Object)this.getClass().getCanonicalName(), (Object)this.clazz.getCanonicalName());
        this.triggerReload();
    }

    protected abstract C getConfigForExtensions(Set<E> var1);

    protected abstract void triggerReload();

    public Class<?> getType() {
        return this.clazz;
    }

    public C getObject() {
        this.rwLock.readLock().lock();
        try {
            C c = this.configObject;
            return c;
        }
        finally {
            this.rwLock.readLock().unlock();
        }
    }

    public long getLastUpdate() {
        this.rwLock.readLock().lock();
        try {
            long l = this.lastUpdate;
            return l;
        }
        finally {
            this.rwLock.readLock().unlock();
        }
    }
}

