/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.features.deviceconfig.rest.impl;

import com.google.common.base.Strings;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.zip.GZIPInputStream;
import org.apache.commons.compress.archivers.tar.TarArchiveEntry;
import org.apache.commons.compress.archivers.tar.TarArchiveInputStream;
import org.apache.commons.compress.archivers.tar.TarArchiveOutputStream;
import org.apache.commons.compress.compressors.gzip.GzipCompressorOutputStream;

public class CompressionUtils {
    public static byte[] tarGzipMultipleFiles(Map<String, byte[]> fileNameToDataMap) throws IOException {
        if (fileNameToDataMap == null || fileNameToDataMap.isEmpty()) {
            return null;
        }
        byte[] tarBytes = CompressionUtils.tarMultipleFiles(fileNameToDataMap);
        ByteArrayOutputStream byteOutputStream = new ByteArrayOutputStream();
        try (GzipCompressorOutputStream gzipOut = new GzipCompressorOutputStream((OutputStream)byteOutputStream);){
            gzipOut.write(tarBytes);
        }
        return byteOutputStream.toByteArray();
    }

    public static Map<String, byte[]> unTarGzipMultipleFiles(byte[] tarGzipData) throws IOException {
        if (tarGzipData == null) {
            return new HashMap<String, byte[]>();
        }
        HashMap<String, byte[]> result = new HashMap<String, byte[]>();
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(tarGzipData);
        GZIPInputStream gzipInputStream = new GZIPInputStream(byteArrayInputStream);
        try (TarArchiveInputStream tarInputStream = new TarArchiveInputStream((InputStream)gzipInputStream);){
            TarArchiveEntry tarEntry = null;
            int BUFLEN = 1024;
            byte[] buffer = new byte[1024];
            while ((tarEntry = tarInputStream.getNextTarEntry()) != null) {
                if (!tarEntry.isFile()) continue;
                String fileName = tarEntry.getName();
                ByteArrayOutputStream byteOutput = new ByteArrayOutputStream();
                try (BufferedOutputStream bufOut = new BufferedOutputStream(byteOutput);){
                    int len = 0;
                    while ((len = tarInputStream.read(buffer)) != -1) {
                        bufOut.write(buffer, 0, len);
                    }
                }
                byte[] bytesRead = byteOutput.toByteArray();
                result.put(fileName, bytesRead);
            }
        }
        return result;
    }

    public static byte[] tarMultipleFiles(Map<String, byte[]> fileNameToDataMap) throws IOException {
        ByteArrayOutputStream byteOutputStream = new ByteArrayOutputStream();
        try (TarArchiveOutputStream tarOut = new TarArchiveOutputStream((OutputStream)byteOutputStream);){
            for (Map.Entry<String, byte[]> entry : fileNameToDataMap.entrySet()) {
                if (Strings.isNullOrEmpty((String)entry.getKey()) || entry.getValue() == null) continue;
                TarArchiveEntry archiveEntry = new TarArchiveEntry(entry.getKey());
                archiveEntry.setName(entry.getKey());
                archiveEntry.setSize((long)entry.getValue().length);
                tarOut.putArchiveEntry(archiveEntry);
                tarOut.write(entry.getValue());
                tarOut.closeArchiveEntry();
            }
        }
        return byteOutputStream.toByteArray();
    }
}

