/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.reporting.datablock;

import java.util.ArrayList;
import java.util.List;
import org.opennms.reporting.datablock.Service;
import org.opennms.reporting.datablock.StandardNamedObject;

public class Interface
extends StandardNamedObject {
    private List<Service> m_services;

    public Interface() {
        this.m_services = new ArrayList<Service>();
    }

    public Interface(String name, List<Service> services) {
        this.setName(name);
        this.m_services = services == null ? new ArrayList<Service>() : services;
    }

    public Interface(String name, String service) {
        this.setName(name);
        this.m_services = new ArrayList<Service>();
        if (service != null) {
            Service svc = new Service(service);
            this.m_services.add(svc);
        }
    }

    public Interface(String name, String service, long losttime) {
        this.setName(name);
        this.m_services = new ArrayList<Service>();
        if (service != null) {
            Service svc = new Service(service);
            if (losttime > 0L) {
                svc.addOutage(losttime);
            }
            this.m_services.add(svc);
        }
    }

    public Interface(String name, String service, long losttime, long regainedtime) {
        this.setName(name);
        this.m_services = new ArrayList<Service>();
        if (service != null) {
            Service svc = new Service(service);
            if (losttime > 0L) {
                if (regainedtime > 0L) {
                    svc.addOutage(losttime, regainedtime);
                } else {
                    svc.addOutage(losttime);
                }
            }
            this.m_services.add(svc);
        }
    }

    public Interface(String name) {
        this.m_services = new ArrayList<Service>();
        this.setName(name);
    }

    public Interface(List<Service> services) {
        this.m_services = services == null ? new ArrayList<Service>() : services;
    }

    public List<Service> getServices() {
        return this.m_services;
    }

    public Service getService(String svcname) {
        int ndx = this.m_services.indexOf(ServiceComparator.make(svcname));
        if (ndx != -1) {
            return this.m_services.get(ndx);
        }
        return null;
    }

    public void addService(Service service) {
        if (service != null) {
            this.m_services.add(service);
        }
    }

    public void addService(String service) {
        int ndx = this.m_services.indexOf(ServiceComparator.make(service));
        if (ndx != -1) {
            return;
        }
        if (service != null) {
            Service svc = new Service(service);
            this.m_services.add(svc);
        }
    }

    public void addService(String service, long losttime) {
        int ndx = this.m_services.indexOf(ServiceComparator.make(service));
        if (ndx != -1) {
            Service svc = this.m_services.get(ndx);
            if (svc != null && losttime > 0L) {
                svc.addOutage(losttime);
            }
            return;
        }
        if (service != null) {
            Service svc = new Service(service);
            if (losttime > 0L) {
                svc.addOutage(losttime);
            }
            this.m_services.add(svc);
        }
    }

    public void addService(String service, long losttime, long regainedtime) {
        if (service == null) {
            return;
        }
        int ndx = this.m_services.indexOf(ServiceComparator.make(service));
        if (ndx != -1) {
            Service svc = this.m_services.get(ndx);
            if (svc != null && losttime > 0L) {
                if (regainedtime > 0L) {
                    svc.addOutage(losttime, regainedtime);
                } else {
                    svc.addOutage(losttime);
                }
            }
            return;
        }
        Service svc = new Service(service);
        if (losttime > 0L) {
            if (regainedtime > 0L) {
                svc.addOutage(losttime, regainedtime);
            } else {
                svc.addOutage(losttime);
            }
        }
        this.m_services.add(svc);
    }

    public long getDownTime(long currentTime, long rollingWindow) {
        long outageTime = 0L;
        if (this.m_services != null && this.m_services.size() > 0) {
            for (Service service : this.m_services) {
                long down = service.getDownTime(currentTime, rollingWindow);
                if (down <= 0L) continue;
                outageTime += down;
            }
        }
        return outageTime;
    }

    public int getServiceCount() {
        if (this.m_services != null && this.m_services.size() > 0) {
            return this.m_services.size();
        }
        return -1;
    }

    public int getServiceAffectCount() {
        int count = 0;
        if (this.m_services != null && this.m_services.size() > 0) {
            for (Service service : this.m_services) {
                if (service.getOutages().size() <= 0) continue;
                ++count;
            }
        }
        return count;
    }

    public boolean equals(Object obj) {
        if (obj != null) {
            if (obj instanceof String) {
                return ((String)obj).equals(this.getName());
            }
            if (obj instanceof Interface) {
                return obj == this;
            }
        }
        return false;
    }

    private static class ServiceComparator {
        private String m_svcname;

        private ServiceComparator(String svc) {
            this.m_svcname = svc;
        }

        static ServiceComparator make(String name) {
            return new ServiceComparator(name);
        }

        static ServiceComparator make(Service svc) {
            return new ServiceComparator(svc.getName());
        }

        public boolean equals(Object o) {
            boolean rc = false;
            if (o != null) {
                if (o == this) {
                    rc = true;
                } else if (o instanceof Service) {
                    rc = this.m_svcname.equals(((Service)o).getName());
                } else if (o instanceof String) {
                    rc = this.m_svcname.equals(o);
                }
            }
            return rc;
        }
    }
}

