/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.core.schema;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URI;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.charset.StandardCharsets;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Map;
import java.util.function.Predicate;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.sql.DataSource;
import liquibase.database.DatabaseConnection;
import liquibase.exception.DatabaseException;
import liquibase.integration.spring.SpringLiquibase;
import org.opennms.core.schema.MigrationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.core.io.Resource;
import org.springframework.core.io.ResourceLoader;

public class Migrator {
    public static final String LIQUIBASE_CHANGELOG_FILENAME = "changelog.xml";
    public static final String LIQUIBASE_CHANGELOG_LOCATION_PATTERN = "classpath*:/changelog.xml";
    private static final Logger LOG = LoggerFactory.getLogger(Migrator.class);
    private static final Pattern POSTGRESQL_VERSION_PATTERN = Pattern.compile("^(?:PostgreSQL|EnterpriseDB) (\\d+\\.\\d+)");
    private static final float POSTGRESQL_MIN_VERSION_INCLUSIVE = Float.parseFloat(System.getProperty("opennms.postgresql.minVersion", "10.0"));
    private static final float POSTGRESQL_MAX_VERSION_EXCLUSIVE = Float.parseFloat(System.getProperty("opennms.postgresql.maxVersion", "17.0"));
    private static final String IPLIKE_SQL_RESOURCE = "iplike.sql";
    private DataSource m_dataSource;
    private DataSource m_adminDataSource;
    private Float m_databaseVersion;
    private boolean m_validateDatabaseVersion = true;
    private boolean m_createUser = true;
    private boolean m_createDatabase = true;
    private Predicate<Resource> m_liquibaseChangelogFilter = Migrator.createProductionLiquibaseChangelogFilter();
    private String m_databaseName;
    private String m_schemaName;
    private String m_databaseUser;
    private String m_databasePassword;
    private String m_adminUser;
    private String m_adminPassword;
    private ApplicationContext m_context;

    public static Predicate<Resource> createProductionLiquibaseChangelogFilter() {
        return r -> {
            try {
                URI uri = r.getURI();
                return uri.getScheme().equals("file") && uri.toString().contains("core/schema") || uri.getScheme().equals("jar") && uri.toString().contains("core.schema");
            }
            catch (IOException e) {
                return false;
            }
        };
    }

    public DataSource getDataSource() {
        return this.m_dataSource;
    }

    public void setDataSource(DataSource dataSource) {
        this.m_dataSource = dataSource;
    }

    public DataSource getAdminDataSource() {
        return this.m_adminDataSource;
    }

    public void setAdminDataSource(DataSource dataSource) {
        this.m_adminDataSource = dataSource;
    }

    public void setValidateDatabaseVersion(boolean validate) {
        this.m_validateDatabaseVersion = validate;
    }

    public void setCreateUser(boolean createUser) {
        this.m_createUser = createUser;
    }

    public void setCreateDatabase(boolean createDatabase) {
        this.m_createDatabase = createDatabase;
    }

    public void setLiquibaseChangelogFilter(Predicate<Resource> tester) {
        this.m_liquibaseChangelogFilter = tester;
    }

    public String getDatabaseName() {
        return this.m_databaseName;
    }

    public void setDatabaseName(String databaseName) {
        this.m_databaseName = databaseName;
    }

    public String getSchemaName() {
        return this.m_schemaName;
    }

    public void setSchemaName(String schemaName) {
        this.m_schemaName = schemaName;
    }

    public String getDatabaseUser() {
        return this.m_databaseUser;
    }

    public void setDatabaseUser(String databaseUser) {
        this.m_databaseUser = databaseUser;
    }

    public String getDatabasePassword() {
        return this.m_databasePassword;
    }

    public void setDatabasePassword(String databasePassword) {
        this.m_databasePassword = databasePassword;
    }

    public String getAdminUser() {
        return this.m_adminUser;
    }

    public void setAdminUser(String adminUser) {
        this.m_adminUser = adminUser;
    }

    public String getAdminPassword() {
        return this.m_adminPassword;
    }

    public void setAdminPassword(String adminPassword) {
        this.m_adminPassword = adminPassword;
    }

    public Float getDatabaseVersion() throws MigrationException {
        if (this.m_databaseVersion == null) {
            String versionString = null;
            Statement st = null;
            ResultSet rs = null;
            Connection c = null;
            try {
                c = this.m_adminDataSource.getConnection();
                st = c.createStatement();
                rs = st.executeQuery("SELECT version()");
                if (!rs.next()) {
                    throw new MigrationException("Database didn't return any rows for 'SELECT version()'");
                }
                versionString = rs.getString(1);
                rs.close();
                st.close();
                this.cleanUpDatabase(c, null, st, rs);
            }
            catch (SQLException e) {
                try {
                    throw new MigrationException("an error occurred getting the version from the database", e);
                }
                catch (Throwable throwable) {
                    this.cleanUpDatabase(c, null, st, rs);
                    throw throwable;
                }
            }
            Matcher m = POSTGRESQL_VERSION_PATTERN.matcher(versionString);
            if (!m.find()) {
                throw new MigrationException("Could not parse version number out of version string: " + versionString);
            }
            this.m_databaseVersion = Float.valueOf(Float.parseFloat(m.group(1)));
        }
        return this.m_databaseVersion;
    }

    public void validateDatabaseVersion() throws MigrationException {
        if (!this.m_validateDatabaseVersion) {
            LOG.info("skipping database version validation");
            return;
        }
        LOG.info("validating database version");
        Float dbv = this.getDatabaseVersion();
        if (dbv == null) {
            throw new MigrationException("unable to determine database version");
        }
        String message = String.format("Unsupported database version \"%f\" -- you need at least %f and less than %f.  Use the \"-Q\" option to disable this check if you feel brave and are willing to find and fix bugs found yourself.", dbv, Float.valueOf(POSTGRESQL_MIN_VERSION_INCLUSIVE), Float.valueOf(POSTGRESQL_MAX_VERSION_EXCLUSIVE));
        if (dbv.floatValue() < POSTGRESQL_MIN_VERSION_INCLUSIVE || dbv.floatValue() >= POSTGRESQL_MAX_VERSION_EXCLUSIVE) {
            throw new MigrationException(message);
        }
    }

    private String getSharedObjectExtension(boolean jni) {
        String osName = System.getProperty("os.name").toLowerCase();
        if (osName.startsWith("windows")) {
            return "dll";
        }
        if (osName.startsWith("mac")) {
            if (jni) {
                return "jnilib";
            }
            return "so";
        }
        return "so";
    }

    public void createLangPlPgsql() throws MigrationException {
        LOG.info("adding PL/PgSQL support to the database, if necessary");
        Statement st = null;
        ResultSet rs = null;
        Connection c = null;
        try {
            c = this.m_dataSource.getConnection();
            st = c.createStatement();
            rs = st.executeQuery("SELECT oid FROM pg_proc WHERE proname='plpgsql_call_handler' AND proargtypes = ''");
            if (rs.next()) {
                LOG.info("PL/PgSQL call handler exists");
            } else {
                LOG.info("adding PL/PgSQL call handler");
                st.execute("CREATE FUNCTION plpgsql_call_handler () RETURNS OPAQUE AS '$libdir/plpgsql." + this.getSharedObjectExtension(false) + "' LANGUAGE 'c'");
            }
            rs.close();
            rs = st.executeQuery("SELECT pg_language.oid FROM pg_language, pg_proc WHERE pg_proc.proname='plpgsql_call_handler' AND pg_proc.proargtypes = '' AND pg_proc.oid = pg_language.lanplcallfoid AND pg_language.lanname = 'plpgsql'");
            if (rs.next()) {
                LOG.info("PL/PgSQL language exists");
            } else {
                LOG.info("adding PL/PgSQL language");
                st.execute("CREATE TRUSTED PROCEDURAL LANGUAGE 'plpgsql' HANDLER plpgsql_call_handler LANCOMPILER 'PL/pgSQL'");
            }
            this.cleanUpDatabase(c, null, st, rs);
        }
        catch (SQLException e) {
            try {
                throw new MigrationException("an error occurred getting the version from the database", e);
            }
            catch (Throwable throwable) {
                this.cleanUpDatabase(c, null, st, rs);
                throw throwable;
            }
        }
    }

    public boolean databaseUserExists() throws MigrationException {
        Connection c;
        ResultSet rs;
        Statement st;
        block6: {
            block7: {
                st = null;
                rs = null;
                c = null;
                c = this.m_adminDataSource.getConnection();
                st = c.createStatement();
                rs = st.executeQuery("SELECT usename FROM pg_user WHERE usename = '" + this.getUserForONMSDB() + "'");
                if (!rs.next()) break block6;
                String datname = rs.getString("usename");
                if (datname == null || !datname.equalsIgnoreCase(this.getUserForONMSDB())) break block7;
                boolean bl = true;
                this.cleanUpDatabase(c, null, st, rs);
                return bl;
            }
            boolean bl = false;
            this.cleanUpDatabase(c, null, st, rs);
            return bl;
        }
        try {
            boolean datname = rs.next();
            this.cleanUpDatabase(c, null, st, rs);
            return datname;
        }
        catch (SQLException e) {
            try {
                throw new MigrationException("an error occurred determining whether the OpenNMS user exists", e);
            }
            catch (Throwable throwable) {
                this.cleanUpDatabase(c, null, st, rs);
                throw throwable;
            }
        }
    }

    public void createUser() throws MigrationException {
        if (!this.m_createUser || this.databaseUserExists()) {
            return;
        }
        LOG.info("creating OpenNMS user, if necessary");
        Statement st = null;
        ResultSet rs = null;
        Connection c = null;
        try {
            c = this.m_adminDataSource.getConnection();
            st = c.createStatement();
            st.execute("CREATE USER " + this.getUserForONMSDB() + " WITH PASSWORD '" + this.getDatabasePassword() + "'");
            st.execute("GRANT USAGE, CREATE ON SCHEMA public TO " + this.getUserForONMSDB());
        }
        catch (SQLException e) {
            throw new MigrationException("an error occurred creating the OpenNMS user", e);
        }
        finally {
            this.cleanUpDatabase(c, null, st, rs);
        }
    }

    protected String getUserForONMSDB() {
        String user = this.getDatabaseUser();
        user = user.indexOf("@") > 0 ? user.substring(0, user.indexOf("@")) : user;
        return user;
    }

    public boolean databaseExists() throws MigrationException {
        return this.databaseExists(this.getDatabaseName());
    }

    public boolean databaseExists(String databaseName) throws MigrationException {
        Connection c;
        ResultSet rs;
        Statement st;
        block6: {
            block7: {
                st = null;
                rs = null;
                c = null;
                c = this.m_adminDataSource.getConnection();
                st = c.createStatement();
                rs = st.executeQuery("SELECT datname from pg_database WHERE datname = '" + databaseName + "'");
                if (!rs.next()) break block6;
                String datname = rs.getString("datname");
                if (datname == null || !datname.equalsIgnoreCase(databaseName)) break block7;
                boolean bl = true;
                this.cleanUpDatabase(c, null, st, rs);
                return bl;
            }
            boolean bl = false;
            this.cleanUpDatabase(c, null, st, rs);
            return bl;
        }
        try {
            boolean datname = rs.next();
            this.cleanUpDatabase(c, null, st, rs);
            return datname;
        }
        catch (SQLException e) {
            try {
                throw new MigrationException("an error occurred determining whether the OpenNMS database exists", e);
            }
            catch (Throwable throwable) {
                this.cleanUpDatabase(c, null, st, rs);
                throw throwable;
            }
        }
    }

    public void createSchema() throws MigrationException {
        if (!this.m_createDatabase || this.schemaExists()) {
            return;
        }
    }

    public boolean schemaExists() throws MigrationException {
        return true;
    }

    public void createDatabase() throws MigrationException {
        if (!this.m_createDatabase || this.databaseExists()) {
            return;
        }
        LOG.info("creating OpenNMS database, if necessary");
        if (!this.databaseUserExists()) {
            throw new MigrationException(String.format("database will not be created: unable to grant access (user %s does not exist)", this.getDatabaseUser()));
        }
        Statement st = null;
        ResultSet rs = null;
        Connection c = null;
        try {
            c = this.m_adminDataSource.getConnection();
            st = c.createStatement();
            st.execute("CREATE DATABASE \"" + this.getDatabaseName() + "\" WITH ENCODING='UNICODE'");
            st.execute("GRANT ALL ON DATABASE \"" + this.getDatabaseName() + "\" TO \"" + this.getUserForONMSDB() + "\"");
        }
        catch (SQLException e) {
            throw new MigrationException("an error occurred creating the OpenNMS database: " + e, e);
        }
        finally {
            this.cleanUpDatabase(c, null, st, rs);
        }
    }

    public void checkUnicode() throws Exception {
        block3: {
            LOG.info("checking if database \"" + this.getDatabaseName() + "\" is unicode");
            Statement st = null;
            ResultSet rs = null;
            Connection c = null;
            try {
                c = this.m_adminDataSource.getConnection();
                st = c.createStatement();
                rs = st.executeQuery("SELECT encoding FROM pg_database WHERE LOWER(datname)='" + this.getDatabaseName().toLowerCase() + "'");
                if (!rs.next() || rs.getInt(1) != 5 && rs.getInt(1) != 6) break block3;
                this.cleanUpDatabase(c, null, st, rs);
                return;
            }
            catch (Throwable throwable) {
                this.cleanUpDatabase(c, null, st, rs);
                throw throwable;
            }
        }
        throw new MigrationException("OpenNMS requires a Unicode database.  Please delete and recreate your\ndatabase and try again.");
    }

    public void databaseSetOwner() throws MigrationException {
        PreparedStatement st = null;
        ResultSet rs = null;
        Connection c = null;
        try {
            c = this.m_adminDataSource.getConnection();
            String[] tableTypes = new String[]{"TABLE"};
            rs = c.getMetaData().getTables(null, "public", "%", tableTypes);
            HashSet<String> objects = new HashSet<String>();
            while (rs.next()) {
                objects.add(rs.getString("TABLE_NAME"));
            }
            st = c.prepareStatement("ALTER TABLE ? OWNER TO ?");
            for (String objName : objects) {
                st.setString(1, objName);
                st.setString(2, this.getDatabaseUser());
                st.execute();
            }
            this.cleanUpDatabase(c, null, st, rs);
        }
        catch (SQLException e) {
            try {
                throw new MigrationException("an error occurred setting table ownership " + st, e);
            }
            catch (Throwable throwable) {
                this.cleanUpDatabase(c, null, st, rs);
                throw throwable;
            }
        }
    }

    public void vacuumDatabase(boolean full) throws MigrationException {
        Connection c = null;
        Statement st = null;
        try {
            c = this.m_dataSource.getConnection();
            st = c.createStatement();
            LOG.info("optimizing database (VACUUM ANALYZE)");
            st.execute("VACUUM ANALYZE");
            if (full) {
                LOG.info("recovering database disk space (VACUUM FULL)");
                st.execute("VACUUM FULL");
            }
        }
        catch (SQLException e) {
            throw new MigrationException("an error occurred vacuuming the databse", e);
        }
        finally {
            this.cleanUpDatabase(c, null, st, null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateIplike() throws MigrationException {
        block8: {
            boolean insert_iplike;
            boolean bl = insert_iplike = !this.isIpLikeUsable();
            if (insert_iplike) {
                this.dropExistingIpLike();
                if (!this.installCIpLike("foo")) {
                    this.setupPlPgsqlIplike();
                }
            }
            LOG.info("checking for stale eventtime.so references");
            Connection c = null;
            Statement st = null;
            try {
                c = this.m_dataSource.getConnection();
                st = c.createStatement();
                st.execute("DROP FUNCTION eventtime(text)");
            }
            catch (SQLException e) {
                if (e.toString().indexOf("does not exist") != -1) break block8;
                if ("42883".equals(e.getSQLState())) {
                    break block8;
                }
                throw new MigrationException("error checking for stale eventtime.so references", e);
            }
            finally {
                this.cleanUpDatabase(c, null, st, null);
            }
        }
    }

    public boolean isIpLikeUsable() throws MigrationException {
        Connection c = null;
        Statement st = null;
        LOG.info("checking if iplike is usable");
        c = this.m_dataSource.getConnection();
        st = c.createStatement();
        try {
            st.execute("SELECT IPLIKE('127.0.0.1', '*.*.*.*')");
        }
        catch (SQLException selectException) {
            boolean bl = false;
            this.cleanUpDatabase(c, null, st, null);
            return bl;
        }
        try {
            st.close();
            LOG.info("checking if iplike supports IPv6");
            st = c.createStatement();
            st.execute("SELECT IPLIKE('fe80:0000:5ab0:35ff:feee:cecd', 'fe80:*::cecd')");
            this.cleanUpDatabase(c, null, st, null);
        }
        catch (SQLException e) {
            try {
                throw new MigrationException("error checking if iplike is usable", e);
            }
            catch (Throwable throwable) {
                this.cleanUpDatabase(c, null, st, null);
                throw throwable;
            }
        }
        return true;
    }

    private boolean installCIpLike(String pgIplikeLocation) throws MigrationException {
        if (pgIplikeLocation == null) {
            LOG.info("Skipped inserting C iplike function (location of iplike function not set)");
            return false;
        }
        LOG.info("inserting C iplike function");
        Statement st = null;
        Connection c = null;
        try {
            c = this.m_dataSource.getConnection();
            st = c.createStatement();
            try {
                st.execute("CREATE FUNCTION iplike(text,text) RETURNS bool AS '" + pgIplikeLocation + "' LANGUAGE 'c' WITH(isstrict)");
                boolean bl = true;
                return bl;
            }
            catch (SQLException e) {
                try {
                    boolean bl = false;
                    this.cleanUpDatabase(c, null, st, null);
                    return bl;
                }
                catch (SQLException e2) {
                    throw new MigrationException("error installing C iplike function", e2);
                }
                catch (Throwable throwable) {
                    throw throwable;
                }
            }
        }
        finally {
            this.cleanUpDatabase(c, null, st, null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dropExistingIpLike() throws MigrationException {
        block6: {
            Connection c = null;
            Statement st = null;
            LOG.info("removing existing iplike definition (if any)");
            try {
                c = this.m_dataSource.getConnection();
                st = c.createStatement();
                st.execute("DROP FUNCTION iplike(text,text)");
            }
            catch (SQLException dropException) {
                if (dropException.toString().contains("does not exist")) break block6;
                if ("42883".equals(dropException.getSQLState())) {
                    break block6;
                }
                throw new MigrationException("could not remove existing iplike definition (if it exists)", dropException);
            }
            finally {
                this.cleanUpDatabase(c, null, st, null);
            }
        }
    }

    public void setupPlPgsqlIplike() throws MigrationException {
        LOG.info("inserting PL/pgSQL iplike function");
        InputStream sqlfile = null;
        StringBuffer createFunction = new StringBuffer();
        try {
            String line;
            sqlfile = this.getClass().getResourceAsStream(IPLIKE_SQL_RESOURCE);
            if (sqlfile == null) {
                throw new MigrationException("unable to locate iplike.sql from class " + this.getClass());
            }
            BufferedReader in = new BufferedReader(new InputStreamReader(sqlfile, StandardCharsets.UTF_8));
            while ((line = in.readLine()) != null) {
                createFunction.append(line).append("\n");
            }
        }
        catch (IOException e) {
            throw new MigrationException("error reading PL/pgSQL iplike function from file iplike.sql", e);
        }
        finally {
            try {
                if (sqlfile != null) {
                    sqlfile.close();
                }
            }
            catch (IOException iOException) {}
        }
        Connection c = null;
        Statement st = null;
        try {
            c = this.m_dataSource.getConnection();
            st = c.createStatement();
            st.execute(createFunction.toString());
        }
        catch (SQLException e) {
            throw new MigrationException("could not insert PL/pgSQL iplike function", e);
        }
        finally {
            this.cleanUpDatabase(c, null, st, null);
        }
    }

    public void dropDatabase() throws MigrationException {
        LOG.info("removing database '" + this.getDatabaseName() + "'");
        Connection c = null;
        Statement st = null;
        try {
            c = this.m_adminDataSource.getConnection();
            st = c.createStatement();
            st.execute("DROP DATABASE \"" + this.getDatabaseName() + "\"");
        }
        catch (SQLException e) {
            throw new MigrationException("could not drop database " + this.getDatabaseName(), e);
        }
        finally {
            this.cleanUpDatabase(c, null, st, null);
        }
    }

    public void addTimescaleDBExtension(boolean isNewDatabase) throws MigrationException {
        LOG.info("adding timescaledb extension in template db");
        Connection c = null;
        Statement st = null;
        try {
            c = isNewDatabase ? this.m_adminDataSource.getConnection() : this.m_dataSource.getConnection();
            st = c.createStatement();
            st.execute("CREATE EXTENSION IF NOT EXISTS timescaledb CASCADE");
            this.cleanUpDatabase(c, null, st, null);
        }
        catch (SQLException e) {
            try {
                throw new MigrationException("could not add timescaledb extension", e);
            }
            catch (Throwable throwable) {
                this.cleanUpDatabase(c, null, st, null);
                throw throwable;
            }
        }
    }

    public void addTimescaleDBExtensionOnDatabase() throws MigrationException {
        LOG.info("adding timescaledb extension in db");
        Connection c = null;
        Statement st = null;
        try {
            c = this.m_adminDataSource.getConnection();
            st = c.createStatement();
            st.execute("ALTER ROLE " + this.getDatabaseUser() + " WITH SUPERUSER");
            this.addTimescaleDBExtension(false);
            st.execute("ALTER ROLE " + this.getDatabaseUser() + " WITH NOSUPERUSER");
            this.addTimescaleDBExtension(true);
        }
        catch (SQLException e) {
            throw new MigrationException("could not add timescaledb extension", e);
        }
        finally {
            this.cleanUpDatabase(c, null, st, null);
        }
    }

    public void prepareDatabase() throws MigrationException {
        this.validateDatabaseVersion();
        this.createUser();
        this.createSchema();
        this.createDatabase();
        this.createLangPlPgsql();
    }

    public void migrate(Resource changelog) throws MigrationException {
        Connection connection = null;
        try {
            connection = this.m_dataSource.getConnection();
            SpringLiquibase lb = new SpringLiquibase();
            lb.setResourceLoader((ResourceLoader)this.m_context);
            lb.setChangeLog(changelog.getURI().toString());
            lb.setDataSource(this.m_dataSource);
            lb.setChangeLogParameters(this.getChangeLogParameters());
            lb.setDefaultSchema(this.getSchemaName());
            lb.setContexts(Migrator.getLiquibaseContexts());
            lb.afterPropertiesSet();
        }
        catch (Throwable e) {
            throw new MigrationException("unable to migrate the database: " + e.getMessage(), e);
        }
        finally {
            this.cleanUpDatabase(connection, null, null, null);
        }
    }

    public static String getLiquibaseContexts() {
        return System.getProperty("opennms.contexts", "production");
    }

    private Map<String, String> getChangeLogParameters() {
        HashMap<String, String> parameters = new HashMap<String, String>();
        parameters.put("install.database.admin.user", this.getAdminUser());
        parameters.put("install.database.admin.password", this.getAdminPassword());
        parameters.put("install.database.user", this.getDatabaseUser());
        return parameters;
    }

    private void cleanUpDatabase(Connection c, DatabaseConnection dbc, Statement st, ResultSet rs) {
        if (rs != null) {
            try {
                rs.close();
            }
            catch (SQLException e) {
                LOG.warn("Failed to close result set.", (Throwable)e);
            }
        }
        if (st != null) {
            try {
                st.close();
            }
            catch (SQLException e) {
                LOG.warn("Failed to close statement.", (Throwable)e);
            }
        }
        if (dbc != null) {
            try {
                dbc.close();
            }
            catch (DatabaseException e) {
                LOG.warn("Failed to close database connection.", (Throwable)e);
            }
        }
        if (c != null) {
            try {
                c.close();
            }
            catch (SQLException e) {
                LOG.warn("Failed to close connection.", (Throwable)e);
            }
        }
    }

    public void checkTime() throws Exception {
        LOG.info("checking if time of database \"" + this.getDatabaseName() + "\" is matching system time");
        try (Statement st = this.m_adminDataSource.getConnection().createStatement();){
            long beforeQueryTime = System.currentTimeMillis();
            try (ResultSet rs = st.executeQuery("SELECT NOW()");){
                if (rs.next()) {
                    Timestamp currentDatabaseTime = rs.getTimestamp(1);
                    long currentSystemTime = System.currentTimeMillis();
                    long diff = currentDatabaseTime.getTime() - currentSystemTime;
                    long queryExecuteDelta = Math.abs(currentSystemTime - beforeQueryTime);
                    if (Math.abs(diff) > 1000L + queryExecuteDelta) {
                        LOG.info("NOT OK");
                        SimpleDateFormat simpleDateFormat = new SimpleDateFormat();
                        String databaseDateString = simpleDateFormat.format(new Date(currentDatabaseTime.getTime()));
                        String systemTimeDateString = simpleDateFormat.format(new Date(currentSystemTime));
                        throw new Exception("Database time and system time differ.System time: " + systemTimeDateString + ", database time: " + databaseDateString + ", diff: " + Math.abs(diff) + "ms. The maximum allowed difference is 1000ms. Please update either the database time or system time");
                    }
                    LOG.info("OK");
                }
            }
        }
    }

    public void setupDatabase(boolean updateDatabase, boolean vacuum, boolean fullVacuum, boolean iplike, boolean timescaleDB) throws MigrationException, Exception, IOException {
        this.validateDatabaseVersion();
        if (updateDatabase) {
            this.prepareDatabase();
        }
        if (timescaleDB) {
            if (this.databaseExists()) {
                this.addTimescaleDBExtensionOnDatabase();
            } else {
                this.addTimescaleDBExtension(true);
            }
        }
        this.checkUnicode();
        this.checkTime();
        if (updateDatabase) {
            this.databaseSetOwner();
            for (Resource resource : this.getLiquibaseChangelogs(true)) {
                LOG.info("- Running migration for changelog: {}", (Object)resource.getDescription());
                this.migrate(resource);
            }
        }
        if (vacuum) {
            this.vacuumDatabase(fullVacuum);
        }
        if (iplike) {
            this.updateIplike();
        }
    }

    public Collection<Resource> getLiquibaseChangelogs(boolean required) throws IOException, Exception {
        LinkedList<Resource> filtered = new LinkedList<Resource>();
        for (Resource resource : this.m_context.getResources(LIQUIBASE_CHANGELOG_LOCATION_PATTERN)) {
            if (this.m_liquibaseChangelogFilter != null && !this.m_liquibaseChangelogFilter.test(resource)) {
                LOG.debug("Skipping Liquibase changelog that doesn't pass filter: {}", (Object)resource);
                continue;
            }
            filtered.add(resource);
        }
        if (required && filtered.size() == 0) {
            throw new MigrationException("Could not find any 'changelog.xml' files in our classpath using 'classpath*:/changelog.xml'. Combined ClassPath:" + this.getContextClassLoaderUrls() + "\nAnd system class loader for fun:" + Migrator.getSystemClassLoaderUrls());
        }
        return filtered;
    }

    public String getContextClassLoaderUrls() {
        StringBuffer urls = new StringBuffer();
        for (ApplicationContext c = this.m_context; c != null; c = c.getParent()) {
            for (ClassLoader cl = c.getClassLoader(); cl != null; cl = cl.getParent()) {
                if (cl instanceof URLClassLoader) {
                    for (URL url : ((URLClassLoader)cl).getURLs()) {
                        urls.append("\n\t");
                        urls.append(url);
                    }
                    continue;
                }
                urls.append("** Could not get URLs from this ClassLoader: " + cl);
            }
        }
        return urls.toString();
    }

    public static String getSystemClassLoaderUrls() {
        return Migrator.getClassLoaderUrls(ClassLoader.getSystemClassLoader());
    }

    public static String getResourceLoaderClassLoaderUrls(ResourceLoader resourceLoader) {
        return Migrator.getClassLoaderUrls(resourceLoader.getClassLoader());
    }

    public static String getClassLoaderUrls(ClassLoader classLoader) {
        StringBuffer urls = new StringBuffer();
        for (ClassLoader cl = classLoader; cl != null; cl = cl.getParent()) {
            if (cl instanceof URLClassLoader) {
                for (URL url : ((URLClassLoader)cl).getURLs()) {
                    urls.append("\n\t");
                    urls.append(url);
                }
                continue;
            }
            urls.append("** Could not get URLs from this ClassLoader: " + cl);
        }
        return urls.toString();
    }

    public void setApplicationContext(ApplicationContext context) {
        this.m_context = context;
    }

    public ApplicationContext getApplicationContext() {
        return this.m_context;
    }
}

