/*
 * Decompiled with CFR 0.152.
 */
package liquibase.ext.opennms.setsequence;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import liquibase.statement.SqlStatement;
import org.apache.commons.lang.builder.ToStringBuilder;

public class SetSequenceStatement
implements SqlStatement {
    private final String m_sequenceName;
    private final List<String> m_tables = new ArrayList<String>();
    private Map<String, String> m_columns = new LinkedHashMap<String, String>();
    private Map<String, String> m_schemas = new LinkedHashMap<String, String>();
    private Integer m_value;

    public SetSequenceStatement(String sequenceName) {
        this.m_sequenceName = sequenceName;
    }

    public boolean skipOnUnsupported() {
        return true;
    }

    public boolean continueOnError() {
        return false;
    }

    public String getSequenceName() {
        return this.m_sequenceName;
    }

    public List<String> getTables() {
        return this.m_tables;
    }

    public Map<String, String> getColumns() {
        return this.m_columns;
    }

    public Map<String, String> getSchemas() {
        return this.m_schemas;
    }

    public Integer getValue() {
        return this.m_value;
    }

    public SetSequenceStatement setValue(Integer value) {
        this.m_value = value;
        return this;
    }

    SetSequenceStatement addTable(String name, String column) {
        this.getTables().add(name);
        this.getColumns().put(name, column);
        return this;
    }

    SetSequenceStatement addTable(String name, String schemaName, String column) {
        this.getTables().add(name);
        this.getColumns().put(name, column);
        this.getSchemas().put(name, schemaName);
        return this;
    }

    public String toString() {
        return new ToStringBuilder((Object)this).append("sequenceName", (Object)this.m_sequenceName).append("value", (Object)this.m_value).append("tables", this.m_tables).append("columns", this.m_columns).append("schemas", this.m_schemas).toString();
    }
}

