/*
 * Decompiled with CFR 0.152.
 */
package edu.uci.ics.jung.visualization.control;

import com.google.common.base.Supplier;
import edu.uci.ics.jung.algorithms.layout.Layout;
import edu.uci.ics.jung.graph.Graph;
import edu.uci.ics.jung.visualization.BasicVisualizationServer;
import edu.uci.ics.jung.visualization.control.VertexSupport;
import java.awt.geom.Point2D;

public class SimpleVertexSupport<V, E>
implements VertexSupport<V, E> {
    protected Supplier<V> vertexFactory;

    public SimpleVertexSupport(Supplier<V> vertexFactory) {
        this.vertexFactory = vertexFactory;
    }

    @Override
    public void startVertexCreate(BasicVisualizationServer<V, E> vv, Point2D point) {
        Object newVertex = this.vertexFactory.get();
        Layout<V, E> layout = vv.getGraphLayout();
        Graph graph = layout.getGraph();
        graph.addVertex(newVertex);
        layout.setLocation(newVertex, vv.getRenderContext().getMultiLayerTransformer().inverseTransform(point));
        vv.repaint();
    }

    @Override
    public void midVertexCreate(BasicVisualizationServer<V, E> vv, Point2D point) {
    }

    @Override
    public void endVertexCreate(BasicVisualizationServer<V, E> vv, Point2D point) {
    }

    public Supplier<V> getVertexFactory() {
        return this.vertexFactory;
    }

    public void setVertexFactory(Supplier<V> vertexFactory) {
        this.vertexFactory = vertexFactory;
    }
}

