/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.webconsole.internal.servlet;

import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.security.GeneralSecurityException;
import java.security.Principal;
import java.util.Dictionary;
import java.util.Hashtable;
import javax.security.auth.Subject;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.auth.login.AccountException;
import javax.security.auth.login.FailedLoginException;
import javax.security.auth.login.LoginContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.felix.webconsole.WebConsoleSecurityProvider2;
import org.apache.felix.webconsole.internal.servlet.Base64;
import org.apache.karaf.jaas.boot.principal.ClientPrincipal;
import org.osgi.service.cm.ManagedService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JaasSecurityProvider
implements WebConsoleSecurityProvider2,
ManagedService {
    private static final Logger LOG = LoggerFactory.getLogger(JaasSecurityProvider.class);
    private static final String HEADER_WWW_AUTHENTICATE = "WWW-Authenticate";
    private static final String HEADER_AUTHORIZATION = "Authorization";
    private static final String AUTHENTICATION_SCHEME_BASIC = "Basic";
    private String realm;
    private String role;
    private int sessionTimeout;

    public JaasSecurityProvider() {
        this.updated(null);
    }

    public String getRealm() {
        return this.realm;
    }

    public void setRealm(String realm) {
        this.realm = realm;
    }

    public String getRole() {
        return this.role;
    }

    public void setRole(String role) {
        this.role = role;
    }

    @Override
    public Object authenticate(String username, String password) {
        return this.doAuthenticate("?", username, password);
    }

    public void updated(Dictionary<String, ?> properties) {
        if (properties == null) {
            properties = new Hashtable();
        }
        this.realm = this.getString(properties, "realm", "karaf");
        this.role = this.getString(properties, "role", "admin");
        this.sessionTimeout = Integer.parseInt(this.getString(properties, "sessionTimeout", "0"));
    }

    private String getString(Dictionary<String, ?> properties, String key, String def) {
        Object val;
        if (properties != null && (val = properties.get(key)) != null) {
            return val.toString();
        }
        return def;
    }

    public Subject doAuthenticate(String address, String username, String password) {
        try {
            Subject subject = new Subject();
            subject.getPrincipals().add((Principal)new ClientPrincipal("webconsole", address));
            LoginContext loginContext = new LoginContext(this.realm, subject, callbacks -> {
                for (Callback callback : callbacks) {
                    if (callback instanceof NameCallback) {
                        ((NameCallback)callback).setName(username);
                        continue;
                    }
                    if (callback instanceof PasswordCallback) {
                        ((PasswordCallback)callback).setPassword(password.toCharArray());
                        continue;
                    }
                    throw new UnsupportedCallbackException(callback);
                }
            });
            loginContext.login();
            if (this.role != null && this.role.length() > 0) {
                String clazz = "org.apache.karaf.jaas.boot.principal.RolePrincipal";
                String name = this.role;
                int idx = this.role.indexOf(58);
                if (idx > 0) {
                    clazz = this.role.substring(0, idx);
                    name = this.role.substring(idx + 1);
                }
                boolean found = false;
                for (Principal p : subject.getPrincipals()) {
                    if (!p.getClass().getName().equals(clazz) || !p.getName().equals(name)) continue;
                    found = true;
                    break;
                }
                if (!found) {
                    throw new FailedLoginException("User does not have the required role " + this.role);
                }
            }
            return subject;
        }
        catch (FailedLoginException e) {
            LOG.debug("Login failed", (Throwable)e);
            return null;
        }
        catch (AccountException e) {
            LOG.warn("Account failure", (Throwable)e);
            return null;
        }
        catch (GeneralSecurityException e) {
            LOG.error("General Security Exception", (Throwable)e);
            return null;
        }
    }

    @Override
    public boolean authorize(Object o, String s) {
        return true;
    }

    @Override
    public boolean authenticate(HttpServletRequest request, HttpServletResponse response) {
        block11: {
            int blank;
            String authHeader = request.getHeader(HEADER_AUTHORIZATION);
            if (authHeader != null && authHeader.length() > 0 && (blank = (authHeader = authHeader.trim()).indexOf(32)) > 0) {
                String authType = authHeader.substring(0, blank);
                String authInfo = authHeader.substring(blank).trim();
                if (authType.equalsIgnoreCase(AUTHENTICATION_SCHEME_BASIC)) {
                    try {
                        HttpSession session2;
                        String srcString = JaasSecurityProvider.base64Decode(authInfo);
                        int i = srcString.indexOf(58);
                        String username = srcString.substring(0, i);
                        String password = srcString.substring(i + 1);
                        Subject subject = null;
                        try {
                            session2 = request.getSession(false);
                            if (session2 != null) {
                                subject = (Subject)session2.getAttribute("karaf.subject.runas");
                            }
                        }
                        catch (Throwable session2) {
                            // empty catch block
                        }
                        if (subject == null) {
                            String addr = request.getRemoteHost() + ":" + request.getRemotePort();
                            subject = this.doAuthenticate(addr, username, password);
                        }
                        if (subject == null) break block11;
                        request.setAttribute("org.osgi.service.http.authentication.type", (Object)"BASIC");
                        request.setAttribute("org.osgi.service.http.authentication.remote.user", (Object)username);
                        request.setAttribute("org.apache.felix.webconsole.user", (Object)username);
                        request.setAttribute("karaf.subject.runas", (Object)subject);
                        try {
                            session2 = request.getSession(true);
                            if (this.sessionTimeout != 0) {
                                session2.setMaxInactiveInterval(this.sessionTimeout);
                            }
                            session2.setAttribute("karaf.subject.runas", (Object)subject);
                        }
                        catch (Throwable throwable) {
                            // empty catch block
                        }
                        return true;
                    }
                    catch (Exception e) {
                        LOG.warn("Error during authentication", (Throwable)e);
                    }
                }
            }
        }
        this.requireAuthentication(response);
        return false;
    }

    private void requireAuthentication(HttpServletResponse response) {
        response.setHeader(HEADER_WWW_AUTHENTICATE, "Basic realm=\"" + this.realm + "\"");
        response.setStatus(401);
        response.setContentLength(0);
        try {
            response.flushBuffer();
        }
        catch (IOException e) {
            LOG.debug("Error flushing after sending auth required", (Throwable)e);
        }
    }

    private static String base64Decode(String srcString) {
        byte[] transformed = Base64.decodeBase64(srcString);
        return new String(transformed, StandardCharsets.ISO_8859_1);
    }
}

