/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.rrd;

import org.opennms.netmgt.rrd.RrdStrategy;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;

public class RrdStrategyFactory
implements ApplicationContextAware {
    private ApplicationContext m_context;

    public void setApplicationContext(ApplicationContext context) {
        this.m_context = context;
    }

    public <D, F> RrdStrategy<D, F> getStrategy() {
        RrdStrategy rrdStrategy = null;
        boolean useQueue = (Boolean)this.m_context.getBean("useQueue", Boolean.class);
        boolean useTcp = (Boolean)this.m_context.getBean("useTcp", Boolean.class);
        try {
            rrdStrategy = useQueue ? (useTcp ? (RrdStrategy)this.m_context.getBean(StrategyName.tcpAndQueuingRrdStrategy.toString(), RrdStrategy.class) : (RrdStrategy)this.m_context.getBean(StrategyName.queuingRrdStrategy.toString(), RrdStrategy.class)) : (useTcp ? (RrdStrategy)this.m_context.getBean(StrategyName.tcpAndBasicRrdStrategy.toString(), RrdStrategy.class) : (RrdStrategy)this.m_context.getBean(StrategyName.basicRrdStrategy.toString(), RrdStrategy.class));
        }
        catch (BeansException e) {
            throw new IllegalStateException(String.format("Invalid RRD configuration useQueue: %s, useTcp: %s", useQueue, useTcp), e);
        }
        return rrdStrategy;
    }

    private static enum StrategyName {
        basicRrdStrategy,
        queuingRrdStrategy,
        tcpAndBasicRrdStrategy,
        tcpAndQueuingRrdStrategy;

    }
}

