/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.web.charts;

import java.awt.Color;
import java.awt.Paint;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.sql.Connection;
import java.sql.SQLException;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.ChartTheme;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.StandardChartTheme;
import org.jfree.chart.axis.CategoryAxis;
import org.jfree.chart.axis.ExtendedCategoryAxis;
import org.jfree.chart.axis.ValueAxis;
import org.jfree.chart.labels.CategoryItemLabelGenerator;
import org.jfree.chart.labels.StandardCategoryItemLabelGenerator;
import org.jfree.chart.plot.CategoryPlot;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.renderer.category.BarRenderer;
import org.jfree.chart.title.TextTitle;
import org.jfree.data.category.CategoryDataset;
import org.jfree.data.category.DefaultCategoryDataset;
import org.jfree.data.jdbc.JDBCCategoryDataset;
import org.opennms.core.db.DataSourceFactory;
import org.opennms.netmgt.config.ChartConfigFactory;
import org.opennms.netmgt.config.charts.BarChart;
import org.opennms.netmgt.config.charts.Blue;
import org.opennms.netmgt.config.charts.ChartBackgroundColor;
import org.opennms.netmgt.config.charts.Green;
import org.opennms.netmgt.config.charts.ImageSize;
import org.opennms.netmgt.config.charts.PlotBackgroundColor;
import org.opennms.netmgt.config.charts.Red;
import org.opennms.netmgt.config.charts.Rgb;
import org.opennms.netmgt.config.charts.SeriesDef;
import org.opennms.netmgt.config.charts.SubTitle;
import org.opennms.netmgt.config.charts.Title;
import org.opennms.web.charts.ChartException;
import org.opennms.web.charts.CustomSeriesColors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ChartUtils {
    private static final Logger LOG = LoggerFactory.getLogger(ChartUtils.class);
    private static final int DEFAULT_IMAGE_SIZE = 400;
    private static final int PNG_COMPRESSION_LEVEL = 6;
    private static final double RANGE_MARGIN = 0.1;

    private ChartUtils() {
    }

    public static JFreeChart getBarChart(String chartName) throws ChartException {
        BarChart chartConfig = null;
        chartConfig = ChartUtils.getBarChartConfigByName(chartName);
        if (chartConfig == null) {
            throw new IllegalArgumentException("getBarChart: Invalid chart name.");
        }
        DefaultCategoryDataset baseDataSet = ChartUtils.buildCategoryDataSet(chartConfig);
        JFreeChart barChart = ChartUtils.createBarChart(chartConfig, baseDataSet);
        ChartUtils.addSubTitles(chartConfig, barChart);
        Optional subLabelClassOptional = chartConfig.getSubLabelClass();
        if (subLabelClassOptional.isPresent()) {
            ChartUtils.addSubLabels(barChart, (String)subLabelClassOptional.get());
        }
        ChartUtils.customizeSeries(barChart, chartConfig);
        return barChart;
    }

    private static void addSubLabels(JFreeChart barChart, String subLabelClass) {
        CategoryPlot plot = barChart.getCategoryPlot();
        try {
            Class<?> clazz = Class.forName(subLabelClass);
            Constructor<?> constructor = clazz.getDeclaredConstructor(String.class);
            ExtendedCategoryAxis subLabels = (ExtendedCategoryAxis)constructor.newInstance(new Object[]{null});
            List cats = plot.getCategories();
            for (int i = 0; i < cats.size(); ++i) {
                subLabels.addSubLabel((Comparable)cats.get(i), cats.get(i).toString());
            }
            plot.setDomainAxis((CategoryAxis)subLabels);
        }
        catch (ClassNotFoundException | IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
            LOG.error("getBarChart: Couldn't instantiate configured CategorySubLabels class: {}", (Object)subLabelClass, (Object)e);
        }
    }

    private static void customizeSeries(JFreeChart barChart, BarChart chartConfig) {
        StandardCategoryItemLabelGenerator itemLabelGenerator = new StandardCategoryItemLabelGenerator("{2}", (NumberFormat)new DecimalFormat("0"));
        SeriesDef[] seriesDefs = chartConfig.getSeriesDef();
        CustomSeriesColors seriesColors = null;
        Optional seriesColorClassOpt = chartConfig.getSeriesColorClass();
        if (seriesColorClassOpt.isPresent()) {
            try {
                Class<?> clazz = Class.forName((String)seriesColorClassOpt.get());
                Constructor<?> constructor = clazz.getDeclaredConstructor(new Class[0]);
                seriesColors = (CustomSeriesColors)constructor.newInstance(new Object[0]);
            }
            catch (ClassNotFoundException | IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
                LOG.error("getBarChart: Couldn't instantiate configured CustomSeriesColors class: {}", seriesColors, (Object)e);
            }
        }
        for (int i = 0; i < seriesDefs.length; ++i) {
            Paint paint;
            SeriesDef seriesDef = seriesDefs[i];
            if (seriesColors != null) {
                Comparable cat = (Comparable)((BarRenderer)barChart.getCategoryPlot().getRenderer()).getPlot().getCategories().get(i);
                paint = seriesColors.getPaint(cat);
            } else {
                Optional rgbOptional = seriesDef.getRgb();
                if (rgbOptional.isPresent()) {
                    Rgb rgb = (Rgb)rgbOptional.get();
                    paint = new Color(rgb.getRed().getRgbColor(), rgb.getGreen().getRgbColor(), rgb.getBlue().getRgbColor());
                } else {
                    paint = Color.BLACK;
                }
            }
            ((BarRenderer)barChart.getCategoryPlot().getRenderer()).setSeriesPaint(i, paint);
            ((BarRenderer)barChart.getCategoryPlot().getRenderer()).setSeriesItemLabelsVisible(i, seriesDef.getUseLabels());
            ((BarRenderer)barChart.getCategoryPlot().getRenderer()).setSeriesItemLabelGenerator(i, (CategoryItemLabelGenerator)itemLabelGenerator);
        }
    }

    private static void addSubTitles(BarChart chartConfig, JFreeChart barChart) {
        for (SubTitle subTitle : chartConfig.getSubTitleCollection()) {
            Title title = subTitle.getTitle();
            String value = title.getValue();
            barChart.addSubtitle((org.jfree.chart.title.Title)new TextTitle(value));
        }
    }

    private static JFreeChart createBarChart(BarChart chartConfig, DefaultCategoryDataset baseDataSet) {
        JFreeChart barChart;
        ValueAxis rangeAxis;
        PlotOrientation po;
        PlotOrientation plotOrientation = po = "horizontal".equals(chartConfig.getPlotOrientation().orElse(null)) ? PlotOrientation.HORIZONTAL : PlotOrientation.VERTICAL;
        if ("3d".equalsIgnoreCase(chartConfig.getVariation().orElse(null))) {
            LOG.warn("3d charts no longer supported, using standard JFreeChart bar chart");
        }
        if ((rangeAxis = (barChart = ChartFactory.createBarChart((String)chartConfig.getTitle().getValue(), (String)chartConfig.getDomainAxisLabel(), (String)chartConfig.getRangeAxisLabel(), (CategoryDataset)baseDataSet, (PlotOrientation)po, (boolean)chartConfig.getShowLegend(), (boolean)chartConfig.getShowToolTips(), (boolean)chartConfig.getShowUrls())).getCategoryPlot().getRangeAxis()).getUpperMargin() < 0.1) {
            rangeAxis.setUpperMargin(0.1);
        }
        return barChart;
    }

    private static DefaultCategoryDataset buildCategoryDataSet(BarChart chartConfig) throws ChartException {
        DefaultCategoryDataset baseDataSet = new DefaultCategoryDataset();
        try (Connection conn = DataSourceFactory.getInstance().getConnection();){
            for (SeriesDef def : chartConfig.getSeriesDefCollection()) {
                JDBCCategoryDataset dataSet = new JDBCCategoryDataset(conn, def.getJdbcDataSet().getSql());
                for (int i = 0; i < dataSet.getRowCount(); ++i) {
                    for (int j = 0; j < dataSet.getColumnCount(); ++j) {
                        baseDataSet.addValue(dataSet.getValue(i, j), (Comparable)((Object)def.getSeriesName()), dataSet.getColumnKey(j));
                    }
                }
            }
        }
        catch (SQLException e) {
            throw new ChartException("error while building category dataset", e);
        }
        return baseDataSet;
    }

    public static void getBarChart(String chartName, OutputStream out) throws ChartException {
        int vtPixels;
        int hzPixels;
        ImageSize imageSize;
        BarChart chartConfig = ChartUtils.getBarChartConfigByName(chartName);
        if (chartConfig == null) {
            throw new IllegalStateException("unable to get chart config from name: " + chartName);
        }
        JFreeChart chart = ChartUtils.getBarChart(chartName);
        ImageSize imageSize2 = imageSize = chartConfig == null ? null : chartConfig.getImageSize();
        if (imageSize == null) {
            hzPixels = 400;
            vtPixels = 400;
        } else {
            hzPixels = imageSize.getHzSize().getPixels();
            vtPixels = imageSize.getVtSize().getPixels();
        }
        try {
            org.jfree.chart.ChartUtils.writeChartAsJPEG((OutputStream)out, (JFreeChart)chart, (int)hzPixels, (int)vtPixels);
        }
        catch (IOException e) {
            throw new ChartException("failed to generate JPEG", e);
        }
    }

    public static void getBarChartPNG(String chartName, OutputStream out) throws ChartException {
        int vtPixels;
        int hzPixels;
        ImageSize imageSize;
        ChartFactory.setChartTheme((ChartTheme)StandardChartTheme.createLegacyTheme());
        BarChart chartConfig = ChartUtils.getBarChartConfigByName(chartName);
        JFreeChart chart = ChartUtils.getBarChart(chartName);
        if (chartConfig == null) {
            throw new ChartException("failed to determine chart config for " + chartName);
        }
        if (chartConfig.getChartBackgroundColor().isPresent()) {
            ChartUtils.setChartBackgroundColor(chartConfig, chart);
        }
        if (chartConfig.getPlotBackgroundColor().isPresent()) {
            ChartUtils.setPlotBackgroundColor(chartConfig, chart);
        }
        ImageSize imageSize2 = imageSize = chartConfig == null ? null : chartConfig.getImageSize();
        if (imageSize == null) {
            hzPixels = 400;
            vtPixels = 400;
        } else {
            hzPixels = imageSize.getHzSize().getPixels();
            vtPixels = imageSize.getVtSize().getPixels();
        }
        try {
            org.jfree.chart.ChartUtils.writeChartAsPNG((OutputStream)out, (JFreeChart)chart, (int)hzPixels, (int)vtPixels, (boolean)false, (int)6);
        }
        catch (IOException e) {
            throw new ChartException("failed to generate PNG", e);
        }
    }

    private static void setPlotBackgroundColor(BarChart chartConfig, JFreeChart chart) {
        PlotBackgroundColor bgColor;
        Optional rgb;
        Optional backgroundColorOpt = chartConfig.getPlotBackgroundColor();
        if (backgroundColorOpt.isPresent() && (rgb = (bgColor = (PlotBackgroundColor)backgroundColorOpt.get()).getRgb()).isPresent()) {
            Red red = ((Rgb)rgb.get()).getRed();
            Blue blue = ((Rgb)rgb.get()).getBlue();
            Green green = ((Rgb)rgb.get()).getGreen();
            chart.getPlot().setBackgroundPaint((Paint)new Color(red.getRgbColor(), green.getRgbColor(), blue.getRgbColor()));
        }
    }

    private static void setChartBackgroundColor(BarChart chartConfig, JFreeChart chart) {
        Optional backgroundColorOpt = chartConfig.getChartBackgroundColor();
        if (backgroundColorOpt.isPresent()) {
            ChartBackgroundColor bgColor = (ChartBackgroundColor)backgroundColorOpt.get();
            Red red = bgColor.getRgb().getRed();
            Blue blue = bgColor.getRgb().getBlue();
            Green green = bgColor.getRgb().getGreen();
            chart.setBackgroundPaint((Paint)new Color(red.getRgbColor(), green.getRgbColor(), blue.getRgbColor()));
        }
    }

    public static byte[] getBarChartAsPNGByteArray(String chartName) throws ChartException {
        int vtPixels;
        int hzPixels;
        ImageSize imageSize;
        BarChart chartConfig = ChartUtils.getBarChartConfigByName(chartName);
        JFreeChart chart = ChartUtils.getBarChart(chartName);
        ImageSize imageSize2 = imageSize = chartConfig == null ? null : chartConfig.getImageSize();
        if (imageSize == null) {
            hzPixels = 400;
            vtPixels = 400;
        } else {
            hzPixels = imageSize.getHzSize().getPixels();
            vtPixels = imageSize.getVtSize().getPixels();
        }
        try {
            return org.jfree.chart.ChartUtils.encodeAsPNG((BufferedImage)chart.createBufferedImage(hzPixels, vtPixels));
        }
        catch (IOException e) {
            throw new ChartException("failed to generate PNG", e);
        }
    }

    public static BufferedImage getChartAsBufferedImage(String chartName) throws ChartException {
        int vtPixels;
        int hzPixels;
        ImageSize imageSize;
        BarChart chartConfig = ChartUtils.getBarChartConfigByName(chartName);
        JFreeChart chart = ChartUtils.getBarChart(chartName);
        ImageSize imageSize2 = imageSize = chartConfig == null ? null : chartConfig.getImageSize();
        if (imageSize == null) {
            hzPixels = 400;
            vtPixels = 400;
        } else {
            hzPixels = imageSize.getHzSize().getPixels();
            vtPixels = imageSize.getVtSize().getPixels();
        }
        return chart.createBufferedImage(hzPixels, vtPixels);
    }

    public static BarChart getBarChartConfigByName(String chartName) throws ChartException {
        Iterator<BarChart> it = ChartUtils.getChartCollectionIterator();
        BarChart chart = null;
        while (it.hasNext()) {
            chart = it.next();
            if (!chart.getName().equals(chartName)) continue;
            return chart;
        }
        return null;
    }

    public static Collection<BarChart> getChartCollection() throws IOException {
        return ChartConfigFactory.getInstance().getConfiguration().getBarChartCollection();
    }

    public static Iterator<BarChart> getChartCollectionIterator() throws ChartException {
        try {
            return ChartConfigFactory.getInstance().getConfiguration().getBarChartCollection().iterator();
        }
        catch (IOException e) {
            throw new ChartException("unable to get chart instance configuration", e);
        }
    }

    static {
        try {
            ChartConfigFactory.init();
        }
        catch (IOException e) {
            LOG.error("static initializer: Error initializing chart configuration.", (Throwable)e);
            throw new IllegalStateException("Error initializing chart configuration.", e);
        }
    }
}

