/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.threshd;

import java.io.File;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.opennms.core.utils.InetAddressUtils;
import org.opennms.netmgt.collectd.AliasedResource;
import org.opennms.netmgt.collectd.IfInfo;
import org.opennms.netmgt.collection.api.AttributeType;
import org.opennms.netmgt.collection.api.CollectionAttribute;
import org.opennms.netmgt.collection.api.CollectionResource;
import org.opennms.netmgt.collection.api.LatencyCollectionResource;
import org.opennms.netmgt.dao.api.IfLabel;
import org.opennms.netmgt.model.ResourceId;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CollectionResourceWrapper {
    private static final Logger LOG = LoggerFactory.getLogger(CollectionResourceWrapper.class);
    private final int m_nodeId;
    private final String m_hostAddress;
    private final String m_serviceName;
    private String m_dsLabel;
    private final String m_iflabel;
    private final String m_ifindex;
    private final CollectionResource m_resource;
    private final Map<String, CollectionAttribute> m_attributes;
    private final Long m_sequenceNumber;
    static final ConcurrentHashMap<String, CacheEntry> s_cache = new ConcurrentHashMap();
    private final Map<String, Double> m_localCache = new HashMap<String, Double>();
    private final Map<String, String> m_ifInfo = new HashMap<String, String>();
    private final Date m_collectionTimestamp;
    private boolean m_counterReset = false;

    public CollectionResourceWrapper(Date collectionTimestamp, int nodeId, String hostAddress, String serviceName, CollectionResource resource, Map<String, CollectionAttribute> attributes, IfLabel ifLabelDao, Long sequenceNumber) {
        if (collectionTimestamp == null) {
            throw new IllegalArgumentException(String.format("%s: Null collection timestamp when thresholding service %s on node %d (%s)", this.getClass().getSimpleName(), serviceName, nodeId, hostAddress));
        }
        this.m_collectionTimestamp = collectionTimestamp;
        this.m_nodeId = nodeId;
        this.m_hostAddress = hostAddress;
        this.m_serviceName = serviceName;
        this.m_resource = resource;
        this.m_attributes = attributes;
        this.m_sequenceNumber = sequenceNumber;
        if (this.isAnInterfaceResource()) {
            if (resource instanceof AliasedResource) {
                this.m_iflabel = ((AliasedResource)resource).getInterfaceLabel();
                this.m_ifInfo.putAll(((AliasedResource)resource).getIfInfo().getAttributesMap());
                this.m_ifInfo.put("domain", ((AliasedResource)resource).getDomain());
            } else if (resource instanceof IfInfo) {
                this.m_iflabel = ((IfInfo)resource).getInterfaceLabel();
                this.m_ifInfo.putAll(((IfInfo)resource).getAttributesMap());
            } else {
                LOG.info("Can't find ifInfo for {}", (Object)resource);
                this.m_iflabel = null;
            }
            this.m_ifindex = this.m_ifInfo.get("snmpifindex");
        } else if (this.isLatencyResource() && ifLabelDao != null) {
            String ipAddress = ((LatencyCollectionResource)resource).getIpAddress();
            this.m_iflabel = ifLabelDao.getIfLabel(this.getNodeId(), InetAddressUtils.addr((String)ipAddress));
            if (this.m_iflabel != null) {
                this.m_ifInfo.putAll(ifLabelDao.getInterfaceInfoFromIfLabel(this.getNodeId(), this.m_iflabel));
            } else {
                LOG.info("Can't find ifLabel for latency resource {} on node {}", (Object)resource.getInstance(), (Object)this.getNodeId());
            }
            this.m_ifindex = null;
        } else {
            this.m_ifindex = null;
            this.m_iflabel = null;
        }
    }

    public void setCounterReset(boolean counterReset) {
        this.m_counterReset = counterReset;
    }

    public int getNodeId() {
        return this.m_nodeId;
    }

    public String getHostAddress() {
        return this.m_hostAddress;
    }

    public String getServiceName() {
        return this.m_serviceName;
    }

    public String getDsLabel() {
        return this.m_dsLabel;
    }

    public void setDsLabel(String dsLabel) {
        this.m_dsLabel = dsLabel;
    }

    public String getInstance() {
        return this.m_resource != null ? this.m_resource.getInstance() : null;
    }

    public String getInstanceLabel() {
        return this.m_resource != null ? this.m_resource.getInterfaceLabel() : null;
    }

    public String getResourceTypeName() {
        return this.m_resource != null ? this.m_resource.getResourceTypeName() : null;
    }

    public ResourceId getResourceId() {
        String[] parts;
        if (this.m_resource == null) {
            return null;
        }
        String resourceType = this.getResourceTypeName();
        String resourceLabel = this.getInstanceLabel();
        if ("node".equals(resourceType)) {
            resourceType = "nodeSnmp";
            resourceLabel = "";
        }
        if ("if".equals(resourceType)) {
            resourceType = "interfaceSnmp";
        }
        String parentResourceTypeName = "node";
        Object parentResourceName = Integer.toString(this.getNodeId());
        if (this.m_resource.getParent() != null && this.m_resource.getParent().toString().startsWith("fs") && (parts = this.m_resource.getParent().toString().split(File.separatorChar == '\\' ? "\\\\" : File.separator)).length == 3) {
            parentResourceTypeName = "nodeSource";
            parentResourceName = parts[1] + ":" + parts[2];
        }
        return ResourceId.get((String)parentResourceTypeName, (String)parentResourceName).resolve(resourceType, resourceLabel);
    }

    public String getIfLabel() {
        return this.m_iflabel;
    }

    public String getIfIndex() {
        return this.m_ifindex;
    }

    protected String getIfInfoValue(String attribute) {
        if (this.m_ifInfo != null) {
            return this.m_ifInfo.get(attribute);
        }
        return null;
    }

    public boolean isLatencyResource() {
        return this.getResourceTypeName() != null && "latency".equals(this.getResourceTypeName());
    }

    public boolean isNodeResource() {
        return this.getResourceTypeName() != null && "node".equals(this.getResourceTypeName());
    }

    public boolean isAnInterfaceResource() {
        return this.getResourceTypeName() != null && "if".equals(this.getResourceTypeName());
    }

    public boolean isValidInterfaceResource() {
        try {
            if (this.m_ifindex == null) {
                return true;
            }
            if (Integer.parseInt(this.m_ifindex) < 0) {
                return false;
            }
        }
        catch (Throwable e) {
            return false;
        }
        return true;
    }

    public Double getAttributeValue(String ds) {
        String value;
        if (this.isAnInterfaceResource() && ("snmpifspeed".equalsIgnoreCase(ds) || "snmpiftype".equalsIgnoreCase(ds)) && (value = this.getIfInfoValue(ds)) != null) {
            try {
                return Double.parseDouble(value);
            }
            catch (Exception e) {
                return Double.NaN;
            }
        }
        if (this.m_attributes == null || this.m_attributes.get(ds) == null) {
            LOG.info("getAttributeValue: can't find attribute called {} on {}", (Object)ds, (Object)this.m_resource);
            return null;
        }
        Number numValue = this.m_attributes.get(ds).getNumericValue();
        if (numValue == null) {
            LOG.info("getAttributeValue: can't find numeric value for {} on {}", (Object)ds, (Object)this.m_resource);
            return null;
        }
        String id = "node[" + this.m_nodeId + "].resourceType[" + this.m_resource.getResourceTypeName() + "].instance[" + this.m_resource.getInterfaceLabel() + "].metric[" + ds + "]";
        Double current = numValue.doubleValue();
        if (!AttributeType.COUNTER.equals((Object)this.m_attributes.get(ds).getType())) {
            LOG.debug("getAttributeValue: id={}, value= {}", (Object)id, (Object)current);
            return current;
        }
        return this.getCounterValue(id, current);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Double getCounterValue(String id, Double current) {
        Map<String, Double> map = this.m_localCache;
        synchronized (map) {
            Double value;
            if (!this.m_localCache.containsKey(id)) {
                CacheEntry last = this.m_counterReset ? null : s_cache.put(id, new CacheEntry(this.m_collectionTimestamp, current));
                LOG.debug("getCounterValue: id={}, last={}, current={}", new Object[]{id, last == null ? last : last.m_value + "@" + last.m_timestamp, current});
                if (last == null) {
                    this.m_localCache.put(id, Double.NaN);
                    if (this.m_counterReset) {
                        s_cache.put(id, new CacheEntry(this.m_collectionTimestamp, current));
                    }
                    LOG.info("getCounterValue: unknown last value for {}, ignoring current", (Object)id);
                } else {
                    long interval;
                    Double delta = current - last.m_value;
                    if (delta < 0.0) {
                        double newDelta = delta;
                        if ((newDelta += Math.pow(2.0, 32.0)) < 0.0) {
                            newDelta += Math.pow(2.0, 64.0) - Math.pow(2.0, 32.0);
                        }
                        LOG.info("getCounterValue: {}(counter) wrapped counter adjusted last={}@{}, current={}, olddelta={}, newdelta={}", new Object[]{id, last.m_value, last.m_timestamp, current, delta, newDelta});
                        delta = newDelta;
                    }
                    if ((interval = (this.m_collectionTimestamp.getTime() - last.m_timestamp.getTime()) / 1000L) > 0L) {
                        Double value2 = delta / (double)interval;
                        LOG.debug("getCounterValue: id={}, value={}, delta={}, interval={}", new Object[]{id, value2, delta, interval});
                        this.m_localCache.put(id, value2);
                    } else {
                        LOG.info("getCounterValue: invalid zero-length rate interval for {}, returning rate of zero", (Object)id);
                        this.m_localCache.put(id, 0.0);
                        s_cache.put(id, last);
                    }
                }
            }
            if ((value = this.m_localCache.get(id)) == null) {
                LOG.error("getCounterValue: value was not calculated correctly for {}, using NaN", (Object)id);
                this.m_localCache.put(id, Double.NaN);
                return Double.NaN;
            }
            return value;
        }
    }

    public String getFieldValue(String ds) {
        if (ds == null || "".equals(ds)) {
            return null;
        }
        LOG.debug("getLabelValue: Getting Value for {}::{}", (Object)this.m_resource.getResourceTypeName(), (Object)ds);
        if ("nodeid".equalsIgnoreCase(ds)) {
            return Integer.toString(this.m_nodeId);
        }
        if ("ipaddress".equalsIgnoreCase(ds)) {
            return this.m_hostAddress;
        }
        if ("iflabel".equalsIgnoreCase(ds)) {
            return this.getIfLabel();
        }
        if ("id".equalsIgnoreCase(ds)) {
            return this.m_resource.getPath().getName().toString();
        }
        try {
            String retval = null;
            if (this.isAnInterfaceResource() && (retval = this.getIfInfoValue(ds)) != null) {
                return retval;
            }
            CollectionAttribute attr = this.m_attributes.get(ds);
            if (attr != null && attr.getType() == AttributeType.STRING) {
                return attr.getStringValue();
            }
        }
        catch (Throwable e) {
            LOG.info("getFieldValue: Can't get value for attribute {} for resource {}.", new Object[]{ds, this.m_resource, e});
        }
        LOG.debug("getFieldValue: The field {} is not a string property. Trying to parse it as numeric metric.", (Object)ds);
        Double d = this.getAttributeValue(ds);
        if (d != null) {
            return d.toString();
        }
        return null;
    }

    public Long getSequenceNumber() {
        return this.m_sequenceNumber;
    }

    public String toString() {
        return this.m_resource.toString();
    }

    public static class CacheEntry {
        private final Date m_timestamp;
        private final Double m_value;

        public CacheEntry(Date timestamp, Double value) {
            if (timestamp == null) {
                throw new IllegalArgumentException("Illegal null timestamp in cache value");
            }
            if (value == null) {
                throw new IllegalArgumentException("Illegal null value in cache value");
            }
            this.m_timestamp = timestamp;
            this.m_value = value;
        }

        public Date getTimestamp() {
            return this.m_timestamp;
        }

        public Double getValue() {
            return this.m_value;
        }
    }
}

