/*
 * Decompiled with CFR 0.152.
 */
package org.extremecomponents.table.core;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.extremecomponents.table.bean.Column;
import org.extremecomponents.table.bean.Export;
import org.extremecomponents.table.bean.Row;
import org.extremecomponents.table.bean.Table;
import org.extremecomponents.table.context.Context;
import org.extremecomponents.table.core.Messages;
import org.extremecomponents.table.core.Preferences;
import org.extremecomponents.table.core.Registry;
import org.extremecomponents.table.core.TableCache;
import org.extremecomponents.table.core.TableModel;
import org.extremecomponents.table.core.TableModelUtils;
import org.extremecomponents.table.core.TableProperties;
import org.extremecomponents.table.core.TableRegistry;
import org.extremecomponents.table.handler.ColumnHandler;
import org.extremecomponents.table.handler.ExportHandler;
import org.extremecomponents.table.handler.RowHandler;
import org.extremecomponents.table.handler.TableHandler;
import org.extremecomponents.table.handler.ViewHandler;
import org.extremecomponents.table.limit.Limit;
import org.extremecomponents.table.limit.ModelLimitFactory;
import org.extremecomponents.table.limit.TableLimit;

public final class TableModelImpl
implements TableModel {
    private static Log logger = LogFactory.getLog(TableModelImpl.class);
    private Context context;
    private Preferences preferences;
    private Messages messages;
    private Registry registry;
    private TableHandler tableHandler = new TableHandler(this);
    private RowHandler rowHandler = new RowHandler(this);
    private ColumnHandler columnHandler = new ColumnHandler(this);
    private ViewHandler viewHandler = new ViewHandler(this);
    private ExportHandler exportHandler = new ExportHandler(this);
    private Object currentRowBean;
    private Collection collectionOfBeans;
    private Collection collectionOfFilteredBeans;
    private Collection collectionOfPageBeans;
    private Limit limit;
    private Locale locale;

    public TableModelImpl(Context context) {
        this(context, null);
    }

    public TableModelImpl(Context context, String locale) {
        this.context = context;
        this.preferences = new TableProperties();
        this.preferences.init(context, TableModelUtils.getPreferencesLocation(context));
        this.locale = TableModelUtils.getLocale(context, this.preferences, locale);
        this.messages = TableModelUtils.getMessages(this);
        this.messages.init(context, this.locale);
    }

    @Override
    public Context getContext() {
        return this.context;
    }

    @Override
    public Preferences getPreferences() {
        return this.preferences;
    }

    @Override
    public Messages getMessages() {
        return this.messages;
    }

    @Override
    public Registry getRegistry() {
        return this.registry;
    }

    @Override
    public Table getTableInstance() {
        return new Table(this);
    }

    @Override
    public Export getExportInstance() {
        return new Export(this);
    }

    @Override
    public Row getRowInstance() {
        return new Row(this);
    }

    @Override
    public Column getColumnInstance() {
        return new Column(this);
    }

    @Override
    public void addTable(Table table) {
        this.tableHandler.addTable(table);
        this.registry = new TableRegistry(this);
        ModelLimitFactory limitFactory = new ModelLimitFactory(this);
        this.limit = new TableLimit(limitFactory);
    }

    @Override
    public void addExport(Export export) {
        this.exportHandler.addExport(export);
    }

    @Override
    public void addRow(Row row) {
        this.rowHandler.addRow(row);
    }

    @Override
    public void addColumn(Column column) {
        this.columnHandler.addAutoGenerateColumn(column);
    }

    @Override
    public void addColumns(String autoGenerateColumns) {
        autoGenerateColumns = TableModelUtils.getAutoGenerateColumnsPreference(this, autoGenerateColumns);
        TableCache.getInstance().getAutoGenerateColumns(autoGenerateColumns).addColumns(this);
    }

    @Override
    public void addParameter(String name, Object value) {
        this.registry.addParameter(name, value);
    }

    @Override
    public TableHandler getTableHandler() {
        return this.tableHandler;
    }

    @Override
    public RowHandler getRowHandler() {
        return this.rowHandler;
    }

    @Override
    public ColumnHandler getColumnHandler() {
        return this.columnHandler;
    }

    @Override
    public ViewHandler getViewHandler() {
        return this.viewHandler;
    }

    @Override
    public ExportHandler getExportHandler() {
        return this.exportHandler;
    }

    @Override
    public Object getCurrentRowBean() {
        return this.currentRowBean;
    }

    @Override
    public void setCurrentRowBean(Object bean) {
        int rowcount = this.rowHandler.increaseRowCount();
        this.currentRowBean = bean;
        this.context.setPageAttribute("ROWCOUNT", String.valueOf(rowcount));
        this.context.setPageAttribute(this.tableHandler.getTable().getVar(), bean);
    }

    @Override
    public Collection getCollectionOfBeans() {
        return this.collectionOfBeans;
    }

    @Override
    public void setCollectionOfBeans(Collection collectionOfBeans) {
        this.collectionOfBeans = collectionOfBeans;
    }

    @Override
    public Collection getCollectionOfFilteredBeans() {
        return this.collectionOfFilteredBeans;
    }

    @Override
    public void setCollectionOfFilteredBeans(Collection collectionOfFilteredBeans) {
        this.collectionOfFilteredBeans = collectionOfFilteredBeans;
    }

    @Override
    public Collection getCollectionOfPageBeans() {
        return this.collectionOfPageBeans;
    }

    @Override
    public void setCollectionOfPageBeans(Collection collectionOfPageBeans) {
        this.collectionOfPageBeans = collectionOfPageBeans;
    }

    @Override
    public Limit getLimit() {
        return this.limit;
    }

    @Override
    public void setLimit(Limit limit) {
        this.limit = limit;
    }

    @Override
    public Locale getLocale() {
        return this.locale;
    }

    @Override
    public Collection execute() throws Exception {
        Collection rows = TableModelUtils.retrieveRows(this);
        rows = new ArrayList(rows);
        this.collectionOfBeans = rows;
        rows = TableModelUtils.filterRows(this, rows);
        this.collectionOfFilteredBeans = rows = TableModelUtils.sortRows(this, rows);
        Integer totalRows = this.getTableHandler().getTotalRows();
        int defaultRowsDisplayed = this.getTableHandler().getTable().getRowsDisplayed();
        if (totalRows != null) {
            this.limit.setRowAttributes(totalRows, defaultRowsDisplayed);
        } else {
            this.limit.setRowAttributes(rows.size(), defaultRowsDisplayed);
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)this.limit.toString());
        }
        this.collectionOfPageBeans = rows = TableModelUtils.getCurrentRows(this, rows);
        this.viewHandler.setView();
        return rows;
    }

    @Override
    public void setColumnValues() throws Exception {
        List<Column> columns = this.columnHandler.getColumns();
        for (Column column : columns) {
            if (!"true".equals(column.getAttribute("isAutoGenerateColumn"))) continue;
            String property = column.getProperty();
            Object propertyValue = TableModelUtils.getColumnPropertyValue(this.currentRowBean, property);
            column.setValue(propertyValue);
            column.setPropertyValue(propertyValue);
            this.columnHandler.modifyColumnAttributes(column);
            this.viewHandler.addColumnValueToView(column);
        }
    }

    @Override
    public Object getViewData() throws Exception {
        Object viewData = this.viewHandler.getView().afterBody(this);
        if (this.limit.isExported()) {
            this.context.setRequestAttribute("viewData", viewData);
            this.context.setRequestAttribute("viewResolver", this.exportHandler.getCurrentExport().getViewResolver());
            this.context.setRequestAttribute("efn", this.exportHandler.getCurrentExport().getFileName());
            return "";
        }
        return viewData;
    }

    @Override
    public Object assemble() throws Exception {
        Iterator iterator;
        Iterator iter = iterator = this.execute().iterator();
        while (iter.hasNext()) {
            Object bean = iterator.next();
            this.setCurrentRowBean(bean);
            this.getRowHandler().modifyRowAttributes();
            this.setColumnValues();
        }
        return this.getViewData();
    }
}

