/*
 * Decompiled with CFR 0.152.
 */
package org.extremecomponents.table.bean;

import org.apache.commons.lang3.StringUtils;
import org.extremecomponents.table.core.TableModel;
import org.extremecomponents.table.core.TableModelUtils;

final class TableDefaults {
    TableDefaults() {
    }

    static String getTableId(String tableId) {
        if (StringUtils.isNotEmpty((CharSequence)tableId)) {
            return tableId;
        }
        return "ec";
    }

    static String getVar(String var, String tableId) {
        if (StringUtils.isNotEmpty((CharSequence)var)) {
            return var;
        }
        return tableId;
    }

    static String getStyleClass(TableModel model, String styleClass) {
        if (StringUtils.isBlank((CharSequence)styleClass)) {
            return model.getPreferences().getPreference("table.styleClass");
        }
        return styleClass;
    }

    static String getBorder(TableModel model, String border) {
        if (StringUtils.isBlank((CharSequence)border)) {
            return model.getPreferences().getPreference("table.border");
        }
        return border;
    }

    static Boolean isBufferView(TableModel model, Boolean bufferView) {
        if (bufferView == null) {
            return Boolean.valueOf(model.getPreferences().getPreference("table.bufferView"));
        }
        return bufferView;
    }

    static String getCellpadding(TableModel model, String cellpadding) {
        if (StringUtils.isBlank((CharSequence)cellpadding)) {
            return model.getPreferences().getPreference("table.cellpadding");
        }
        return cellpadding;
    }

    static String getCellspacing(TableModel model, String cellspacing) {
        if (StringUtils.isBlank((CharSequence)cellspacing)) {
            return model.getPreferences().getPreference("table.cellspacing");
        }
        return cellspacing;
    }

    static int getRowsDisplayed(TableModel model, int rowsDisplayed) {
        if (rowsDisplayed == 0) {
            return new Integer(model.getPreferences().getPreference("table.rowsDisplayed"));
        }
        return rowsDisplayed;
    }

    static int getMedianRowsDisplayed(TableModel model) {
        return new Integer(model.getPreferences().getPreference("table.medianRowsDisplayed"));
    }

    static int getMaxRowsDisplayed(TableModel model) {
        return new Integer(model.getPreferences().getPreference("table.maxRowsDisplayed"));
    }

    static Boolean isSortable(TableModel model, Boolean sortable) {
        if (sortable == null) {
            return Boolean.valueOf(model.getPreferences().getPreference("table.sortable"));
        }
        return sortable;
    }

    static Boolean isFilterable(TableModel model, Boolean filterable) {
        if (filterable == null) {
            return Boolean.valueOf(model.getPreferences().getPreference("table.filterable"));
        }
        return filterable;
    }

    static Boolean isShowPagination(TableModel model, Boolean showPagination) {
        if (showPagination == null) {
            return Boolean.valueOf(model.getPreferences().getPreference("table.showPagination"));
        }
        return showPagination;
    }

    static Boolean isShowExports(TableModel model, Boolean showExports) {
        if (showExports == null) {
            return Boolean.valueOf(model.getPreferences().getPreference("table.showExports"));
        }
        return showExports;
    }

    static Boolean isShowStatusBar(TableModel model, Boolean showStatusBar) {
        if (showStatusBar == null) {
            return Boolean.valueOf(model.getPreferences().getPreference("table.showStatusBar"));
        }
        return showStatusBar;
    }

    static Boolean isShowTitle(TableModel model, Boolean showTitle) {
        if (showTitle == null) {
            return Boolean.valueOf(model.getPreferences().getPreference("table.showTitle"));
        }
        return showTitle;
    }

    static Boolean isShowTooltips(TableModel model, Boolean showTooltips) {
        if (showTooltips == null) {
            return Boolean.valueOf(model.getPreferences().getPreference("table.showTooltips"));
        }
        return showTooltips;
    }

    static String getImagePath(TableModel model, String imagePath) {
        if (StringUtils.isNotBlank((CharSequence)imagePath)) {
            return imagePath;
        }
        String contextPath = model.getContext().getContextPath();
        String results = TableDefaults.retrieveImagePath(model);
        if (results != null && results.startsWith("/") && !results.startsWith(contextPath)) {
            return contextPath + results;
        }
        return results;
    }

    static String retrieveImagePath(TableModel model) {
        String resourceValue = model.getMessages().getMessage("table.imagePath");
        if (resourceValue != null) {
            return resourceValue;
        }
        return model.getPreferences().getPreference("table.imagePath");
    }

    static String getTitle(TableModel model, String title) {
        String resourceValue;
        if (TableModelUtils.isResourceBundleProperty(title) && (resourceValue = model.getMessages().getMessage(title)) != null) {
            return resourceValue;
        }
        return title;
    }

    static String getWidth(TableModel model, String width) {
        if (StringUtils.isBlank((CharSequence)width)) {
            return model.getPreferences().getPreference("table.width");
        }
        return width;
    }

    static Boolean getAutoIncludeParameters(TableModel model, Boolean autoIncludeParameters) {
        if (autoIncludeParameters == null) {
            return Boolean.valueOf(model.getPreferences().getPreference("table.autoIncludeParameters"));
        }
        return autoIncludeParameters;
    }

    static String getFilterRowsCallback(TableModel model, String filterRowsCallback) {
        String result;
        if (StringUtils.isNotBlank((CharSequence)filterRowsCallback)) {
            result = model.getPreferences().getPreference("table.filterRowsCallback." + filterRowsCallback);
            if (StringUtils.isBlank((CharSequence)result)) {
                result = filterRowsCallback;
            }
        } else {
            result = model.getPreferences().getPreference("table.filterRowsCallback.default");
        }
        return result;
    }

    static String getRetrieveRowsCallback(TableModel model, String retrieveRowsCallback) {
        String result;
        if (StringUtils.isNotBlank((CharSequence)retrieveRowsCallback)) {
            result = model.getPreferences().getPreference("table.retrieveRowsCallback." + retrieveRowsCallback);
            if (StringUtils.isBlank((CharSequence)result)) {
                result = retrieveRowsCallback;
            }
        } else {
            result = model.getPreferences().getPreference("table.retrieveRowsCallback.default");
        }
        return result;
    }

    static String getSortRowsCallback(TableModel model, String sortRowsCallback) {
        String result;
        if (StringUtils.isNotBlank((CharSequence)sortRowsCallback)) {
            result = model.getPreferences().getPreference("table.sortRowsCallback." + sortRowsCallback);
            if (StringUtils.isBlank((CharSequence)result)) {
                result = sortRowsCallback;
            }
        } else {
            result = model.getPreferences().getPreference("table.sortRowsCallback.default");
        }
        return result;
    }

    static String getState(TableModel model, String state) {
        String result;
        if (StringUtils.isNotBlank((CharSequence)state)) {
            result = model.getPreferences().getPreference("table.state." + state);
            if (StringUtils.isBlank((CharSequence)result)) {
                result = state;
            }
        } else {
            result = model.getPreferences().getPreference("table.state.default");
        }
        return result;
    }

    static String getStateAttr(TableModel model, String stateAttr) {
        if (StringUtils.isBlank((CharSequence)stateAttr)) {
            return model.getPreferences().getPreference("table.stateAttr");
        }
        return stateAttr;
    }

    static String getView(String view) {
        if (StringUtils.isBlank((CharSequence)view)) {
            return "html";
        }
        return view;
    }

    static String getMethod(TableModel model, String method) {
        if (StringUtils.isBlank((CharSequence)method)) {
            return model.getPreferences().getPreference("table.method");
        }
        return method;
    }

    static String getTheme(TableModel model, String theme) {
        if (StringUtils.isEmpty((CharSequence)theme)) {
            return model.getPreferences().getPreference("table.theme");
        }
        return theme;
    }
}

