/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.snmp.commands;

import com.google.common.base.Strings;
import java.net.InetAddress;
import org.apache.karaf.shell.api.action.Action;
import org.apache.karaf.shell.api.action.Argument;
import org.apache.karaf.shell.api.action.Command;
import org.apache.karaf.shell.api.action.Option;
import org.apache.karaf.shell.api.action.lifecycle.Reference;
import org.apache.karaf.shell.api.action.lifecycle.Service;
import org.opennms.netmgt.config.api.SnmpAgentConfigFactory;

@Command(scope="opennms", name="snmp-remove-from-definition", description="Remove an IP address from a definition")
@Service
public class RemoveFromDefinitionsCommand
implements Action {
    @Reference
    private SnmpAgentConfigFactory snmpAgentConfigFactory;
    @Option(name="-l", aliases={"--location"}, description="Location")
    String location;
    @Argument(name="ipAddress", description="IP address to remove from definition", required=true)
    String ipAddress;

    public Object execute() throws Exception {
        boolean succeeded = this.snmpAgentConfigFactory.removeFromDefinition(InetAddress.getByName(this.ipAddress), this.location, "karaf-shell");
        if (Strings.isNullOrEmpty((String)this.location)) {
            this.location = "Default";
        }
        if (succeeded) {
            System.out.printf("IP address '%s' at location '%s' removed from SNMP Definitions \n", this.ipAddress, this.location);
        } else {
            System.out.printf("Failed to remove IP address '%s' at location '%s' from SNMP Definitions \n ", this.ipAddress, this.location);
        }
        return null;
    }
}

