/*
 * Decompiled with CFR 0.152.
 */
package org.jrobin.inspector;

import java.io.File;
import java.io.IOException;
import java.util.Date;
import javax.swing.table.AbstractTableModel;
import org.jrobin.core.Header;
import org.jrobin.core.RrdDb;
import org.jrobin.core.RrdException;
import org.jrobin.inspector.Util;

class HeaderTableModel
extends AbstractTableModel {
    private static final long serialVersionUID = 1L;
    private static final Object[] DESCRIPTIONS = new Object[]{"path", "signature", "step", "last timestamp", "datasources", "archives", "size"};
    private static final String[] COLUMN_NAMES = new String[]{"description", "value"};
    private Object[] values;

    HeaderTableModel() {
    }

    @Override
    public int getRowCount() {
        return DESCRIPTIONS.length;
    }

    @Override
    public int getColumnCount() {
        return COLUMN_NAMES.length;
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        if (columnIndex == 0) {
            return DESCRIPTIONS[rowIndex];
        }
        if (columnIndex == 1) {
            if (this.values != null) {
                return this.values[rowIndex];
            }
            return "--";
        }
        return null;
    }

    @Override
    public String getColumnName(int column) {
        return COLUMN_NAMES[column];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setFile(File file) {
        try {
            this.values = null;
            String path = file.getAbsolutePath();
            RrdDb rrd = new RrdDb(path, true);
            try {
                Header header = rrd.getHeader();
                String signature = header.getSignature();
                String step = "" + header.getStep();
                String lastTimestamp = header.getLastUpdateTime() + " [" + new Date(header.getLastUpdateTime() * 1000L) + "]";
                String datasources = "" + header.getDsCount();
                String archives = "" + header.getArcCount();
                String size = rrd.getRrdBackend().getLength() + " bytes";
                this.values = new Object[]{path, signature, step, lastTimestamp, datasources, archives, size};
            }
            finally {
                rrd.close();
            }
            this.fireTableDataChanged();
        }
        catch (IOException e) {
            Util.error(null, e);
        }
        catch (RrdException e) {
            Util.error(null, e);
        }
    }
}

