/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.poller.monitors;

import com.google.common.base.Strings;
import java.io.IOException;
import java.net.InetAddress;
import java.nio.channels.UnresolvedAddressException;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.rmi.RemoteException;
import java.security.GeneralSecurityException;
import java.security.KeyPair;
import java.security.PublicKey;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.sshd.client.SshClient;
import org.apache.sshd.client.auth.UserAuthFactory;
import org.apache.sshd.client.auth.password.UserAuthPasswordFactory;
import org.apache.sshd.client.auth.pubkey.UserAuthPublicKeyFactory;
import org.apache.sshd.client.config.hosts.HostConfigEntry;
import org.apache.sshd.client.future.ConnectFuture;
import org.apache.sshd.client.keyverifier.DefaultKnownHostsServerKeyVerifier;
import org.apache.sshd.client.keyverifier.ServerKeyVerifier;
import org.apache.sshd.client.session.ClientSession;
import org.apache.sshd.common.SshException;
import org.apache.sshd.common.config.keys.KeyUtils;
import org.apache.sshd.common.config.keys.loader.KeyPairResourceParser;
import org.apache.sshd.common.util.security.SecurityUtils;
import org.opennms.core.utils.InetAddressUtils;
import org.opennms.core.utils.ParameterMap;
import org.opennms.core.utils.TimeoutTracker;
import org.opennms.netmgt.poller.MonitoredService;
import org.opennms.netmgt.poller.PollStatus;
import org.opennms.netmgt.poller.support.AbstractServiceMonitor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class MinaSshMonitor
extends AbstractServiceMonitor {
    private static final Logger LOG = LoggerFactory.getLogger(MinaSshMonitor.class);
    private static final int DEFAULT_RETRY = 0;
    public static final int DEFAULT_TIMEOUT = 3000;
    public static final int DEFAULT_PORT = 22;
    public static final List<UserAuthFactory> NONINTERACTIVE_USER_AUTH_FACTORIES = Collections.unmodifiableList(Arrays.asList(UserAuthPublicKeyFactory.INSTANCE, UserAuthPasswordFactory.INSTANCE));

    public PollStatus poll(MonitoredService svc, Map<String, Object> parameters) {
        PollStatus status = PollStatus.unknown((String)"polling never attempted");
        if (parameters == null) {
            throw new NullPointerException("parameter cannot be null");
        }
        int port = ParameterMap.getKeyedInteger(parameters, (String)"port", (int)22);
        String userName = ParameterMap.getKeyedString(parameters, (String)"username", null);
        String password = ParameterMap.getKeyedString(parameters, (String)"password", null);
        String identifyFileName = ParameterMap.getKeyedString(parameters, (String)"identity-file", null);
        String remoteCommand = ParameterMap.getKeyedString(parameters, (String)"remote-command", null);
        String knownHostsFileName = ParameterMap.getKeyedString(parameters, (String)"known-hosts-file", null);
        String host = svc.getNodeLabel();
        String hostAddress = InetAddressUtils.str((InetAddress)svc.getAddress());
        Collection<Object> keys = null;
        if (Strings.isNullOrEmpty((String)hostAddress)) {
            throw new IllegalArgumentException("node is missing an ip address");
        }
        if (Strings.isNullOrEmpty((String)host)) {
            throw new IllegalArgumentException("node is missing a nodelabel");
        }
        try (SshClient client = SshClient.setUpDefaultClient();){
            client.setUserAuthFactories(NONINTERACTIVE_USER_AUTH_FACTORIES);
            if (!Strings.isNullOrEmpty((String)knownHostsFileName)) {
                ServerKeyVerifier current = client.getServerKeyVerifier();
                current = new DefaultKnownHostsServerKeyVerifier(current, false, Paths.get(knownHostsFileName, new String[0]), new LinkOption[0]);
                client.setServerKeyVerifier(current);
            }
            client.start();
            LOG.info("mina-ssh client started: client={}", (Object)client);
            if (!Strings.isNullOrEmpty((String)identifyFileName)) {
                try {
                    KeyPairResourceParser loader = SecurityUtils.getKeyPairResourceParser();
                    keys = loader.loadKeyPairs(null, Paths.get(identifyFileName, new String[0]), client.getFilePasswordProvider(), new OpenOption[0]);
                    for (KeyPair keyPair : keys) {
                        String fp = KeyUtils.getFingerPrint((PublicKey)keyPair.getPublic());
                        LOG.info("loaded key with fingerprint {} from file {}", (Object)fp, (Object)identifyFileName);
                    }
                }
                catch (GeneralSecurityException e) {
                    LOG.warn("GeneralSecurityException loading ssh identity keypair file", (Throwable)e);
                }
                catch (IOException e) {
                    LOG.warn("IOException loading ssh identity keypair file", (Throwable)e);
                }
            }
            if (keys == null) {
                keys = Collections.emptySet();
            }
            if (Strings.isNullOrEmpty((String)password) && keys.isEmpty()) {
                throw new IllegalArgumentException("Both password and identity-files are not defined");
            }
            HostConfigEntry hostConfig = new HostConfigEntry();
            hostConfig.setHost(hostAddress);
            hostConfig.setHostName(hostAddress);
            hostConfig.setUsername(userName);
            hostConfig.setPort(port);
            TimeoutTracker tracker = new TimeoutTracker(parameters, 0, 3000);
            tracker.reset();
            while (tracker.shouldRetry() && !status.isAvailable()) {
                block38: {
                    tracker.startAttempt();
                    status = PollStatus.unknown((String)"polling never attempted");
                    try {
                        ClientSession clientSession;
                        block37: {
                            clientSession = (ClientSession)((ConnectFuture)client.connect(hostConfig, null, null).verify((long)tracker.getConnectionTimeout())).getSession();
                            LOG.info("mina-ssh client session started: session={}", (Object)clientSession);
                            if (!Strings.isNullOrEmpty((String)password)) {
                                clientSession.addPasswordIdentity(password);
                            }
                            for (KeyPair keyPair : keys) {
                                clientSession.addPublicKeyIdentity(keyPair);
                            }
                            clientSession.auth().verify((long)tracker.getConnectionTimeout());
                            if (Strings.isNullOrEmpty((String)remoteCommand)) break block37;
                            try {
                                String cmdOutput = clientSession.executeRemoteCommand(remoteCommand);
                                LOG.info("mina-ssh client remote command output: '{}'", (Object)cmdOutput);
                            }
                            catch (RemoteException e) {
                                status = PollStatus.unavailable((String)e.getMessage());
                                if (clientSession != null) {
                                    clientSession.close();
                                }
                                break block38;
                            }
                        }
                        try {
                            status = PollStatus.available((Double)tracker.elapsedTimeInMillis());
                            LOG.info("mina-ssh client session ended: session={}", (Object)clientSession);
                            break;
                        }
                        finally {
                            if (clientSession != null) {
                                clientSession.close();
                            }
                        }
                    }
                    catch (UnresolvedAddressException unresolvedAddressException) {
                        status = PollStatus.unavailable((String)("invalid hostname '" + host + "'"));
                        break;
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        LOG.warn("service configuration issue", (Throwable)illegalArgumentException);
                    }
                    catch (SshException sshException) {
                        LOG.info("ssh exception while connecting to host '{}'", (Object)host, (Object)sshException);
                        status = PollStatus.unavailable((String)sshException.getMessage());
                    }
                    catch (IOException iOException) {
                        LOG.warn("ioexception while connecting to host '{}'", (Object)host, (Object)iOException);
                        status = PollStatus.unavailable((String)iOException.getMessage());
                    }
                }
                tracker.nextAttempt();
            }
            client.stop();
            LOG.info("mina-ssh client ended: client={}", (Object)client);
        }
        catch (IOException e) {
            LOG.error("ioexception from client", (Throwable)e);
        }
        return status;
    }
}

