/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.integration.api.sample;

import java.util.concurrent.TimeUnit;
import org.opennms.integration.api.v1.distributed.KeyValueStore;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KeyValueStoreClient {
    private static final Logger LOG = LoggerFactory.getLogger(KeyValueStoreClient.class);
    private final KeyValueStore<String> store;
    private String value = "{\"company\": \"OpenNMS\", \"location\": \"Canada\"}";
    private String context1 = "OIA-Test-one";

    public KeyValueStoreClient(KeyValueStore store) {
        this.store = store;
        LOG.debug("KeyValue store is {}", (Object)store.getName());
        this.keyValueOperation();
    }

    public void keyValueOperation() {
        this.testPutWithoutTTL();
        this.testPUtWithTTL();
    }

    private void testPutWithoutTTL() {
        String result;
        long now = System.currentTimeMillis();
        long tmp = this.store.put("k1", (Object)this.value, this.context1);
        if (tmp < now) {
            LOG.warn("Wrong timestamp when put the key value");
        }
        if (!this.value.equals(result = (String)this.store.get("k1", this.context1).orElse(null))) {
            LOG.warn("Wrong value retrieved from key-value store {}, {}", (Object)"k1", (Object)result);
        }
    }

    private void testPUtWithTTL() {
        this.store.put("k1", (Object)this.value, this.context1, Integer.valueOf(1));
        String result = this.store.get("k1", this.context1).orElse(null);
        if (!this.value.equals(result)) {
            LOG.warn("Wrong value retrieved from key-value store {}, {}", (Object)"k1", (Object)result);
        }
        try {
            TimeUnit.SECONDS.sleep(1L);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        result = this.store.get("k1", this.context1).orElse(null);
        if (result != null) {
            LOG.warn("Value should be null {}, {}", (Object)"k1", (Object)result);
        }
    }
}

