/*
 * Decompiled with CFR 0.152.
 */
package org.iq80.leveldb.impl;

import com.google.common.base.Preconditions;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import java.util.concurrent.atomic.AtomicBoolean;
import org.iq80.leveldb.impl.LogChunkType;
import org.iq80.leveldb.impl.LogWriter;
import org.iq80.leveldb.impl.Logs;
import org.iq80.leveldb.util.ByteBufferSupport;
import org.iq80.leveldb.util.Closeables;
import org.iq80.leveldb.util.Slice;
import org.iq80.leveldb.util.SliceInput;
import org.iq80.leveldb.util.SliceOutput;
import org.iq80.leveldb.util.Slices;

public class MMapLogWriter
implements LogWriter {
    private static final int PAGE_SIZE = 0x100000;
    private final File file;
    private final long fileNumber;
    private final FileChannel fileChannel;
    private final AtomicBoolean closed = new AtomicBoolean();
    private MappedByteBuffer mappedByteBuffer;
    private long fileOffset;
    private int blockOffset;

    public MMapLogWriter(File file, long fileNumber) throws IOException {
        Preconditions.checkNotNull(file, "file is null");
        Preconditions.checkArgument(fileNumber >= 0L, "fileNumber is negative");
        this.file = file;
        this.fileNumber = fileNumber;
        this.fileChannel = new RandomAccessFile(file, "rw").getChannel();
        this.mappedByteBuffer = this.fileChannel.map(FileChannel.MapMode.READ_WRITE, 0L, 0x100000L);
    }

    @Override
    public boolean isClosed() {
        return this.closed.get();
    }

    @Override
    public synchronized void close() throws IOException {
        this.closed.set(true);
        this.destroyMappedByteBuffer();
        if (this.fileChannel.isOpen()) {
            this.fileChannel.truncate(this.fileOffset);
        }
        Closeables.closeQuietly(this.fileChannel);
    }

    @Override
    public synchronized void delete() throws IOException {
        this.close();
        this.file.delete();
    }

    private void destroyMappedByteBuffer() {
        if (this.mappedByteBuffer != null) {
            this.fileOffset += (long)this.mappedByteBuffer.position();
            this.unmap();
        }
        this.mappedByteBuffer = null;
    }

    @Override
    public File getFile() {
        return this.file;
    }

    @Override
    public long getFileNumber() {
        return this.fileNumber;
    }

    @Override
    public synchronized void addRecord(Slice record, boolean force2) throws IOException {
        Preconditions.checkState(!this.closed.get(), "Log has been closed");
        SliceInput sliceInput = record.input();
        boolean begin = true;
        do {
            int fragmentLength;
            boolean end;
            int bytesAvailableInBlock;
            int bytesRemainingInBlock;
            Preconditions.checkState((bytesRemainingInBlock = 32768 - this.blockOffset) >= 0);
            if (bytesRemainingInBlock < 7) {
                if (bytesRemainingInBlock > 0) {
                    this.ensureCapacity(bytesRemainingInBlock);
                    this.mappedByteBuffer.put(new byte[bytesRemainingInBlock]);
                }
                this.blockOffset = 0;
                bytesRemainingInBlock = 32768 - this.blockOffset;
            }
            Preconditions.checkState((bytesAvailableInBlock = bytesRemainingInBlock - 7) >= 0);
            if (sliceInput.available() > bytesAvailableInBlock) {
                end = false;
                fragmentLength = bytesAvailableInBlock;
            } else {
                end = true;
                fragmentLength = sliceInput.available();
            }
            LogChunkType type = begin && end ? LogChunkType.FULL : (begin ? LogChunkType.FIRST : (end ? LogChunkType.LAST : LogChunkType.MIDDLE));
            this.writeChunk(type, sliceInput.readBytes(fragmentLength));
            begin = false;
        } while (sliceInput.isReadable());
        if (force2) {
            this.mappedByteBuffer.force();
        }
    }

    private void writeChunk(LogChunkType type, Slice slice) throws IOException {
        Preconditions.checkArgument(slice.length() <= 65535, "length %s is larger than two bytes", new Object[]{slice.length()});
        Preconditions.checkArgument(this.blockOffset + 7 <= 32768);
        Slice header = MMapLogWriter.newLogRecordHeader(type, slice);
        this.ensureCapacity(header.length() + slice.length());
        header.getBytes(0, this.mappedByteBuffer);
        slice.getBytes(0, this.mappedByteBuffer);
        this.blockOffset += 7 + slice.length();
    }

    private void ensureCapacity(int bytes) throws IOException {
        if (this.mappedByteBuffer.remaining() < bytes) {
            this.fileOffset += (long)this.mappedByteBuffer.position();
            this.unmap();
            this.mappedByteBuffer = this.fileChannel.map(FileChannel.MapMode.READ_WRITE, this.fileOffset, 0x100000L);
        }
    }

    private void unmap() {
        ByteBufferSupport.unmap(this.mappedByteBuffer);
    }

    private static Slice newLogRecordHeader(LogChunkType type, Slice slice) {
        int crc = Logs.getChunkChecksum(type.getPersistentId(), slice.getRawArray(), slice.getRawOffset(), slice.length());
        Slice header = Slices.allocate(7);
        SliceOutput sliceOutput = header.output();
        sliceOutput.writeInt(crc);
        sliceOutput.writeByte((byte)(slice.length() & 0xFF));
        sliceOutput.writeByte((byte)(slice.length() >>> 8));
        sliceOutput.writeByte((byte)type.getPersistentId());
        return header;
    }
}

