/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.features.topology.plugins.topo.asset;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import org.opennms.features.topology.plugins.topo.asset.GeneratorConfig;

@XmlRootElement(name="configs")
@XmlAccessorType(value=XmlAccessType.NONE)
public class GeneratorConfigList {
    @XmlElement(name="config")
    private List<GeneratorConfig> configs = new ArrayList<GeneratorConfig>();

    public GeneratorConfigList() {
    }

    public GeneratorConfigList(List<GeneratorConfig> configs) {
        this.configs.clear();
        this.configs.addAll(configs);
    }

    public List<GeneratorConfig> getConfigs() {
        return this.configs;
    }

    public void setConfigs(List<GeneratorConfig> configs) {
        this.configs = configs;
    }

    public GeneratorConfig getConfig(String providerId) {
        return this.configs.stream().filter(config -> config.getProviderId().equals(providerId)).findFirst().orElse(null);
    }

    public void removeConfig(String providerId) {
        Optional.ofNullable(this.getConfig(providerId)).ifPresent(config -> this.configs.remove(config));
    }

    public void addConfig(GeneratorConfig newConfig) {
        GeneratorConfig oldConfig = this.getConfig(newConfig.getProviderId());
        if (oldConfig != null) {
            this.configs.remove(oldConfig);
        }
        this.configs.add(newConfig);
    }

    public int size() {
        return this.configs.size();
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        if (obj instanceof GeneratorConfigList) {
            GeneratorConfigList other = (GeneratorConfigList)obj;
            boolean equals = Objects.equals(this.configs, other.configs);
            return equals;
        }
        return false;
    }

    public int hashCode() {
        return Objects.hashCode(this.configs);
    }

    public String toString() {
        return "GeneratorConfigList [configs=" + this.configs + "]";
    }
}

