/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.features.topology.plugins.topo.asset;

import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Objects;
import org.opennms.core.xml.JaxbUtils;
import org.opennms.features.topology.plugins.topo.asset.AssetGraphDefinitionRepository;
import org.opennms.features.topology.plugins.topo.asset.GeneratorConfig;
import org.opennms.features.topology.plugins.topo.asset.GeneratorConfigList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AssetGraphDefinitionRepositoryImpl
implements AssetGraphDefinitionRepository {
    private static final String FILE_NAME = "org.opennms.features.topology.plugins.topo.asset.xml";
    private static final Logger LOG = LoggerFactory.getLogger(AssetGraphDefinitionRepositoryImpl.class);

    @Override
    public GeneratorConfig getConfigDefinition(String providerId) {
        return this.readGeneratorConfigList().getConfig(providerId);
    }

    @Override
    public boolean exists(String providerId) {
        return this.getConfigDefinition(providerId) != null;
    }

    @Override
    public GeneratorConfigList getAllConfigDefinitions() {
        return new GeneratorConfigList(this.readGeneratorConfigList().getConfigs());
    }

    @Override
    public void removeConfigDefinition(String providerId) {
        GeneratorConfigList generatorConfigList = this.readGeneratorConfigList();
        generatorConfigList.removeConfig(providerId);
        this.persist(generatorConfigList);
    }

    @Override
    public void addConfigDefinition(GeneratorConfig generatorConfig) {
        GeneratorConfigList generatorConfigList = this.readGeneratorConfigList();
        generatorConfigList.addConfig(generatorConfig);
        this.persist(generatorConfigList);
    }

    private GeneratorConfigList readGeneratorConfigList() {
        File configFile = this.getConfigFile();
        if (configFile.exists()) {
            return (GeneratorConfigList)JaxbUtils.unmarshal(GeneratorConfigList.class, (File)configFile);
        }
        return new GeneratorConfigList();
    }

    private void persist(GeneratorConfigList generatorConfigList) {
        File configFile = this.getConfigFile();
        try {
            JaxbUtils.marshal((Object)generatorConfigList, (File)configFile);
        }
        catch (IOException e) {
            LOG.error("Unable to write graph definition to {}", (Object)configFile, (Object)e);
            throw new IllegalStateException("Failed to write graph definition to " + configFile, e);
        }
    }

    private File getConfigFile() {
        String parent = Objects.requireNonNull(System.getProperty("opennms.home"));
        Path configFilePath = Paths.get(parent, "etc", FILE_NAME);
        return configFilePath.toFile();
    }
}

