/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.agent.prometheus.types;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.hawkular.agent.prometheus.types.Counter;
import org.hawkular.agent.prometheus.types.Gauge;
import org.hawkular.agent.prometheus.types.Histogram;
import org.hawkular.agent.prometheus.types.Metric;
import org.hawkular.agent.prometheus.types.MetricType;
import org.hawkular.agent.prometheus.types.Summary;

public class MetricFamily {
    private final String name;
    private final String help;
    private final MetricType type;
    private final List<Metric> metrics;

    protected MetricFamily(Builder builder) {
        Class expectedMetricClassType;
        if (builder.name == null) {
            throw new IllegalArgumentException("Need to set name");
        }
        if (builder.type == null) {
            builder.setType(MetricType.GAUGE);
        }
        switch (builder.type) {
            case COUNTER: {
                expectedMetricClassType = Counter.class;
                break;
            }
            case GAUGE: {
                expectedMetricClassType = Gauge.class;
                break;
            }
            case SUMMARY: {
                expectedMetricClassType = Summary.class;
                break;
            }
            case HISTOGRAM: {
                expectedMetricClassType = Histogram.class;
                break;
            }
            case UNTYPED: {
                expectedMetricClassType = Gauge.class;
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid type: " + builder.type);
            }
        }
        if (builder.metrics != null && !builder.metrics.isEmpty()) {
            for (Metric metric : builder.metrics) {
                if (expectedMetricClassType.isInstance(metric)) continue;
                throw new IllegalArgumentException(String.format("Metric type is [%s] so instances of class [%s] are expected, but got metric object of type [%s]", new Object[]{builder.type, expectedMetricClassType.getName(), metric.getClass().getName()}));
            }
        }
        this.name = builder.name;
        this.help = builder.help;
        this.type = builder.type;
        this.metrics = builder.metrics;
    }

    public String getName() {
        return this.name;
    }

    public String getHelp() {
        return this.help;
    }

    public MetricType getType() {
        return this.type;
    }

    public List<Metric> getMetrics() {
        if (this.metrics == null) {
            return Collections.emptyList();
        }
        return this.metrics;
    }

    public static class Builder {
        private String name;
        private String help;
        private MetricType type;
        private List<Metric> metrics;

        public Builder setName(String name) {
            this.name = name;
            return this;
        }

        public Builder setHelp(String help) {
            this.help = help;
            return this;
        }

        public Builder setType(MetricType type) {
            this.type = type;
            return this;
        }

        public Builder addMetric(Metric metric) {
            if (this.metrics == null) {
                this.metrics = new ArrayList<Metric>();
            }
            this.metrics.add(metric);
            return this;
        }

        public MetricFamily build() {
            return new MetricFamily(this);
        }
    }
}

