/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.oai.validator.schema.format;

import com.github.fge.jackson.NodeType;
import com.github.fge.jsonschema.core.exceptions.ProcessingException;
import com.github.fge.jsonschema.core.report.ProcessingReport;
import com.github.fge.jsonschema.format.AbstractFormatAttribute;
import com.github.fge.jsonschema.format.FormatAttribute;
import com.github.fge.jsonschema.processors.data.FullData;
import com.github.fge.msgsimple.bundle.MessageBundle;

public class Base64Attribute
extends AbstractFormatAttribute {
    private static final FormatAttribute INSTANCE = new Base64Attribute();
    private static final boolean[] BASE64_CHARACTERS = Base64Attribute.initBase64Characters();

    public static FormatAttribute getInstance() {
        return INSTANCE;
    }

    private static boolean[] initBase64Characters() {
        int i;
        boolean[] chars = new boolean[65535];
        chars[43] = true;
        chars[47] = true;
        for (i = 48; i <= 57; ++i) {
            chars[i] = true;
        }
        for (i = 65; i <= 90; ++i) {
            chars[i] = true;
        }
        for (i = 97; i <= 122; ++i) {
            chars[i] = true;
        }
        return chars;
    }

    private Base64Attribute() {
        super("byte", NodeType.STRING, new NodeType[0]);
    }

    public void validate(ProcessingReport report, MessageBundle bundle, FullData data) throws ProcessingException {
        String value = data.getInstance().getNode().textValue();
        int length = value.length();
        if (length == 0) {
            return;
        }
        if (length % 4 != 0) {
            report.error(this.newMsg(data, bundle, "err.format.base64.invalidLength").putArgument("length", length).put("key", "err.format.base64.invalidLength"));
            return;
        }
        int end = value.charAt(length - 1) != '=' ? length : (value.charAt(length - 2) != '=' ? length - 1 : length - 2);
        for (int i = 0; i < end; ++i) {
            if (BASE64_CHARACTERS[value.charAt(i)]) continue;
            report.error(this.newMsg(data, bundle, "err.format.base64.invalid").putArgument("character", (Object)Character.toString(value.charAt(i))).putArgument("index", i).put("key", "err.format.base64.invalid"));
            return;
        }
    }
}

