/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.oai.validator.report;

import com.atlassian.oai.validator.report.ImmutableMessage;
import com.atlassian.oai.validator.report.LevelResolver;
import com.atlassian.oai.validator.report.ValidationReport;
import java.util.Objects;
import java.util.ResourceBundle;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MessageResolver {
    private static final Logger log = LoggerFactory.getLogger(MessageResolver.class);
    private final ResourceBundle messages = ResourceBundle.getBundle("swagger/validation/messages");
    private final LevelResolver levelResolver;

    public MessageResolver() {
        this(LevelResolver.defaultResolver());
    }

    public MessageResolver(LevelResolver levelResolver) {
        this.levelResolver = levelResolver == null ? LevelResolver.defaultResolver() : levelResolver;
    }

    @Nullable
    public ValidationReport.Message get(@Nonnull String key, Object ... args) {
        Objects.requireNonNull(key, "A message key is required.");
        ValidationReport.Level level = this.levelResolver.getLevel(key);
        if (!this.messages.containsKey(key)) {
            log.warn("No message key found for '{}'", (Object)key);
            return null;
        }
        return new ImmutableMessage(key, level, String.format(this.messages.getString(key), args), new String[0]);
    }

    public ValidationReport.Message create(@Nonnull String key, String message, String ... additionalInfo) {
        Objects.requireNonNull(key, "A message key is required.");
        ValidationReport.Level level = this.levelResolver.getLevel(key);
        return new ImmutableMessage(key, level, message, additionalInfo);
    }

    public ValidationReport.Level getLevel(@Nonnull String key) {
        return this.levelResolver.getLevel(key);
    }

    public boolean isIgnored(@Nonnull String key) {
        return this.getLevel(key) == ValidationReport.Level.IGNORE;
    }
}

