/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.dao.hibernate;

import com.google.common.collect.ComparisonChain;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimaps;
import com.google.common.collect.SortedSetMultimap;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import java.net.InetAddress;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.SortedSet;
import java.util.Timer;
import java.util.TimerTask;
import java.util.TreeSet;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.stream.Collectors;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import org.opennms.core.criteria.CriteriaBuilder;
import org.opennms.core.utils.InetAddressUtils;
import org.opennms.core.utils.LocationUtils;
import org.opennms.netmgt.dao.api.AbstractInterfaceToNodeCache;
import org.opennms.netmgt.dao.api.InterfaceToNodeCache;
import org.opennms.netmgt.dao.api.IpInterfaceDao;
import org.opennms.netmgt.dao.api.NodeDao;
import org.opennms.netmgt.model.OnmsIpInterface;
import org.opennms.netmgt.model.OnmsNode;
import org.opennms.netmgt.model.PrimaryType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.transaction.support.TransactionOperations;
import org.springframework.transaction.support.TransactionSynchronizationManager;

public class InterfaceToNodeCacheDaoImpl
extends AbstractInterfaceToNodeCache
implements InterfaceToNodeCache {
    private static final Logger LOG = LoggerFactory.getLogger(InterfaceToNodeCacheDaoImpl.class);
    private final ThreadFactory threadFactory = new ThreadFactoryBuilder().setNameFormat("sync-interface-to-node-cache").build();
    private final ExecutorService executorService = Executors.newSingleThreadExecutor(this.threadFactory);
    private final CountDownLatch initialNodeSyncDone = new CountDownLatch(1);
    @Autowired
    private NodeDao m_nodeDao;
    @Autowired
    private IpInterfaceDao m_ipInterfaceDao;
    @Autowired
    private TransactionOperations transactionOperations;
    private final ReadWriteLock m_lock = new ReentrantReadWriteLock();
    private SortedSetMultimap<Key, Value> m_managedAddresses = Multimaps.newSortedSetMultimap((Map)Maps.newHashMap(), TreeSet::new);
    private final Timer refreshTimer = new Timer(this.getClass().getSimpleName());
    private final long refreshRate;

    public InterfaceToNodeCacheDaoImpl() {
        this(-1L);
    }

    public InterfaceToNodeCacheDaoImpl(long refreshRate) {
        this.refreshRate = refreshRate;
    }

    @PostConstruct
    public void init() {
        this.syncDataSourceAsynchronously().whenComplete((result, ex) -> {
            this.initialNodeSyncDone.countDown();
            if (this.refreshRate > 0L) {
                this.refreshTimer.schedule(new TimerTask(){

                    @Override
                    public void run() {
                        try {
                            InterfaceToNodeCacheDaoImpl.this.dataSourceSync();
                        }
                        catch (Exception ex) {
                            LOG.error("An error occurred while synchronizing the datasource: {}", (Object)ex.getMessage(), (Object)ex);
                        }
                    }
                }, this.refreshRate, this.refreshRate);
            }
        });
    }

    @PreDestroy
    public void destroy() {
        this.initialNodeSyncDone.countDown();
        this.executorService.shutdownNow();
    }

    public NodeDao getNodeDao() {
        return this.m_nodeDao;
    }

    public void setNodeDao(NodeDao nodeDao) {
        this.m_nodeDao = nodeDao;
    }

    public IpInterfaceDao getIpInterfaceDao() {
        return this.m_ipInterfaceDao;
    }

    public void setIpInterfaceDao(IpInterfaceDao ipInterfaceDao) {
        this.m_ipInterfaceDao = ipInterfaceDao;
    }

    @Override
    @Transactional
    public void dataSourceSync() {
        if (TransactionSynchronizationManager.isActualTransactionActive()) {
            this.dataSourceSyncWithinTransaction();
        } else {
            this.transactionOperations.execute(status -> {
                this.dataSourceSyncWithinTransaction();
                return null;
            });
        }
    }

    private CompletableFuture<Void> syncDataSourceAsynchronously() {
        return CompletableFuture.runAsync(this::dataSourceSync, this.executorService);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void dataSourceSyncWithinTransaction() {
        SortedSetMultimap newAlreadyDiscovered = Multimaps.newSortedSetMultimap((Map)Maps.newHashMap(), TreeSet::new);
        CriteriaBuilder builder = new CriteriaBuilder(OnmsNode.class);
        builder.ne("type", (Object)String.valueOf(OnmsNode.NodeType.DELETED.value()));
        for (OnmsNode node : this.m_nodeDao.findMatching(builder.toCriteria())) {
            for (OnmsIpInterface iface : node.getIpInterfaces()) {
                if ("D".equals(iface.getIsManaged())) continue;
                LOG.debug("Adding entry: {}:{} -> {}", new Object[]{node.getLocation().getLocationName(), iface.getIpAddress(), node.getId()});
                newAlreadyDiscovered.put((Object)new Key(node.getLocation().getLocationName(), iface.getIpAddress()), (Object)new Value(node.getId(), iface.getId(), iface.getIsSnmpPrimary()));
            }
        }
        try {
            this.m_lock.writeLock().lock();
            this.m_managedAddresses = newAlreadyDiscovered;
        }
        finally {
            this.m_lock.writeLock().unlock();
        }
        LOG.info("dataSourceSync: initialized list of managed IP addresses with {} members", (Object)this.m_managedAddresses.size());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Optional<InterfaceToNodeCache.Entry> getFirst(String location, InetAddress ipAddr) {
        if (ipAddr == null) {
            return Optional.empty();
        }
        this.waitForInitialNodeSync();
        this.m_lock.readLock().lock();
        try {
            SortedSet values = this.m_managedAddresses.get((Object)new Key(location, ipAddr));
            Optional<InterfaceToNodeCache.Entry> optional = values.isEmpty() ? Optional.empty() : Optional.of(new InterfaceToNodeCache.Entry(((Value)values.first()).nodeId, ((Value)values.first()).interfaceId));
            return optional;
        }
        finally {
            this.m_lock.readLock().unlock();
        }
    }

    private void waitForInitialNodeSync() {
        try {
            this.initialNodeSyncDone.await();
        }
        catch (InterruptedException e) {
            LOG.warn("Wait for node cache sync interrupted", (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Transactional
    public boolean setNodeId(String location, InetAddress addr, int nodeid) {
        if (addr == null || nodeid == -1) {
            return false;
        }
        OnmsIpInterface iface = this.m_ipInterfaceDao.findByNodeIdAndIpAddress(nodeid, InetAddressUtils.str((InetAddress)addr));
        if (iface == null) {
            return false;
        }
        LOG.debug("setNodeId: adding IP address to cache: {}:{} -> {}", new Object[]{location, InetAddressUtils.str((InetAddress)addr), nodeid});
        this.m_lock.writeLock().lock();
        try {
            boolean bl = this.m_managedAddresses.put((Object)new Key(location, addr), (Object)new Value(nodeid, iface.getId(), iface.getIsSnmpPrimary()));
            return bl;
        }
        finally {
            this.m_lock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean removeNodeId(String location, InetAddress address, int nodeId) {
        if (address == null) {
            LOG.warn("removeNodeId: null IP address");
            return false;
        }
        LOG.debug("removeNodeId: removing IP address from cache: {}:{}", (Object)location, (Object)InetAddressUtils.str((InetAddress)address));
        this.m_lock.writeLock().lock();
        try {
            Key key = new Key(location, address);
            boolean bl = this.m_managedAddresses.get((Object)key).removeIf(e -> e.nodeId == nodeId);
            return bl;
        }
        finally {
            this.m_lock.writeLock().unlock();
        }
    }

    @Override
    public int size() {
        this.waitForInitialNodeSync();
        this.m_lock.readLock().lock();
        try {
            int n = this.m_managedAddresses.size();
            return n;
        }
        finally {
            this.m_lock.readLock().unlock();
        }
    }

    @Override
    public void clear() {
        this.m_lock.writeLock().lock();
        try {
            this.m_managedAddresses.clear();
        }
        finally {
            this.m_lock.writeLock().unlock();
        }
    }

    @Override
    public void removeInterfacesForNode(int nodeId) {
        this.m_lock.writeLock().lock();
        try {
            List<Map.Entry> keyValues = this.m_managedAddresses.entries().stream().filter(keyValueEntry -> ((Value)keyValueEntry.getValue()).getNodeId() == nodeId).collect(Collectors.toList());
            keyValues.forEach(keyValue -> {
                boolean succeeded = this.m_managedAddresses.remove(keyValue.getKey(), keyValue.getValue());
                if (succeeded) {
                    LOG.debug("removeInterfacesForNode: removed IP address from cache: {}", (Object)InetAddressUtils.str((InetAddress)((Key)keyValue.getKey()).getIpAddress()));
                }
            });
        }
        finally {
            this.m_lock.writeLock().unlock();
        }
    }

    private static class Value
    implements Comparable<Value> {
        private final int nodeId;
        private final int interfaceId;
        private final PrimaryType type;

        private Value(int nodeId, int interfaceId, PrimaryType type) {
            this.nodeId = nodeId;
            this.interfaceId = interfaceId;
            this.type = type;
        }

        public int getNodeId() {
            return this.nodeId;
        }

        public int getInterfaceId() {
            return this.interfaceId;
        }

        public PrimaryType getType() {
            return this.type;
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (obj == this) {
                return true;
            }
            if (obj.getClass() != this.getClass()) {
                return false;
            }
            Value that = (Value)obj;
            return Objects.equals(this.nodeId, that.nodeId) && Objects.equals(this.interfaceId, that.interfaceId) && Objects.equals(this.type, that.type);
        }

        public int hashCode() {
            return Objects.hash(this.nodeId, Character.valueOf(this.type.getCharCode()));
        }

        public String toString() {
            return String.format("Value[nodeId='%s', interfaceId='%s', type='%s']", this.nodeId, this.interfaceId, this.type);
        }

        @Override
        public int compareTo(Value that) {
            return ComparisonChain.start().compare((Comparable)this.type, (Comparable)that.type).compare(this.nodeId, that.nodeId).compare(this.interfaceId, that.interfaceId).result();
        }
    }

    private static class Key {
        private final String location;
        private final InetAddress ipAddress;

        public Key(String location, InetAddress ipAddress) {
            this.location = LocationUtils.getEffectiveLocationName((String)location);
            this.ipAddress = Objects.requireNonNull(ipAddress);
        }

        public InetAddress getIpAddress() {
            return this.ipAddress;
        }

        public String getLocation() {
            return this.location;
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (obj == this) {
                return true;
            }
            if (obj.getClass() != this.getClass()) {
                return false;
            }
            Key that = (Key)obj;
            return Objects.equals(this.ipAddress, that.ipAddress) && Objects.equals(this.location, that.location);
        }

        public int hashCode() {
            return Objects.hash(this.ipAddress, this.location);
        }

        public String toString() {
            return String.format("Key[location='%s', ipAddress='%s']", this.location, this.ipAddress);
        }
    }
}

