/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.telemetry.protocols.netflow.adapter.common;

import com.codahale.metrics.MetricRegistry;
import com.google.protobuf.InvalidProtocolBufferException;
import java.time.Instant;
import java.util.Collections;
import java.util.List;
import org.opennms.netmgt.flows.api.Flow;
import org.opennms.netmgt.flows.processing.Pipeline;
import org.opennms.netmgt.telemetry.api.adapter.TelemetryMessageLogEntry;
import org.opennms.netmgt.telemetry.config.api.AdapterDefinition;
import org.opennms.netmgt.telemetry.protocols.flows.AbstractFlowAdapter;
import org.opennms.netmgt.telemetry.protocols.netflow.adapter.common.NetflowMessage;
import org.opennms.netmgt.telemetry.protocols.netflow.transport.FlowMessage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NetflowAdapter
extends AbstractFlowAdapter<FlowMessage> {
    private static final Logger LOG = LoggerFactory.getLogger(NetflowAdapter.class);

    public NetflowAdapter(AdapterDefinition adapterConfig, MetricRegistry metricRegistry, Pipeline pipeline) {
        super(adapterConfig, metricRegistry, pipeline);
    }

    protected FlowMessage parse(TelemetryMessageLogEntry message) {
        try {
            return FlowMessage.parseFrom((byte[])message.getByteArray());
        }
        catch (InvalidProtocolBufferException e) {
            LOG.error("Unable to parse message from proto", (Throwable)e);
            return null;
        }
    }

    public List<Flow> convert(FlowMessage packet, Instant receivedAt) {
        return Collections.singletonList(new NetflowMessage(packet, receivedAt));
    }
}

