/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.utils;

import java.net.Inet4Address;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Iterator;
import org.xbill.DNS.AAAARecord;
import org.xbill.DNS.ARecord;
import org.xbill.DNS.Lookup;
import org.xbill.DNS.Record;
import org.xbill.DNS.TextParseException;

public abstract class DnsUtils {
    public static InetAddress resolveHostname(String hostname) throws UnknownHostException {
        return DnsUtils.resolveHostname(hostname, false);
    }

    public static InetAddress resolveHostname(String hostname, boolean preferInet6Address) throws UnknownHostException {
        return DnsUtils.resolveHostname(hostname, preferInet6Address, true);
    }

    public static InetAddress resolveHostname(String hostname, boolean preferInet6Address, boolean throwException) throws UnknownHostException {
        InetAddress retval = null;
        if ("localhost".equals(hostname)) {
            return preferInet6Address ? InetAddress.getByName("::1") : InetAddress.getByName("127.0.0.1");
        }
        try {
            ArrayList<InetAddress> v4Addresses = new ArrayList<InetAddress>();
            try {
                Record[] aRecs = new Lookup(hostname, 1).run();
                if (aRecs != null) {
                    for (Record aRec : aRecs) {
                        if (!(aRec instanceof ARecord)) continue;
                        InetAddress addr = ((ARecord)aRec).getAddress();
                        if (addr instanceof Inet4Address) {
                            v4Addresses.add(addr);
                            continue;
                        }
                        throw new UnknownHostException("Non-IPv4 address found via A record DNS lookup of host: " + hostname + ": " + addr.toString());
                    }
                }
            }
            catch (TextParseException e) {
                UnknownHostException ex = new UnknownHostException("Could not perform A record lookup for host: " + hostname);
                ex.initCause(e);
                throw ex;
            }
            ArrayList<InetAddress> v6Addresses = new ArrayList<InetAddress>();
            try {
                Record[] quadARecs = new Lookup(hostname, 28).run();
                if (quadARecs != null) {
                    for (Record quadARec : quadARecs) {
                        InetAddress addr = ((AAAARecord)quadARec).getAddress();
                        if (!(addr instanceof Inet6Address)) {
                            throw new UnknownHostException("Non-IPv6 address found via AAAA record DNS lookup of host: " + hostname + ": " + addr.toString());
                        }
                        v6Addresses.add(addr);
                    }
                }
            }
            catch (TextParseException e) {
                UnknownHostException ex = new UnknownHostException("Could not perform AAAA record lookup for host: " + hostname);
                ex.initCause(e);
                throw ex;
            }
            ArrayList<InetAddress> addresses = new ArrayList<InetAddress>();
            if (preferInet6Address) {
                addresses.addAll(v6Addresses);
                addresses.addAll(v4Addresses);
            } else {
                addresses.addAll(v4Addresses);
                addresses.addAll(v6Addresses);
            }
            Iterator iterator = addresses.iterator();
            while (iterator.hasNext()) {
                InetAddress address;
                retval = address = (InetAddress)iterator.next();
                if ((preferInet6Address || !(retval instanceof Inet4Address)) && (!preferInet6Address || !(retval instanceof Inet6Address))) continue;
                break;
            }
            if (preferInet6Address && !(retval instanceof Inet6Address)) {
                throw new UnknownHostException("No IPv6 address could be found for the hostname: " + hostname);
            }
        }
        catch (UnknownHostException e) {
            if (throwException) {
                throw e;
            }
            return null;
        }
        return retval;
    }
}

