/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.telemetry.protocols.netflow.parser;

import com.codahale.metrics.Counter;
import com.codahale.metrics.Meter;
import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.Timer;
import com.google.common.base.Joiner;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.Lists;
import com.google.common.util.concurrent.RateLimiter;
import com.swrve.ratelimitedlogger.RateLimitedLog;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.nio.ByteBuffer;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.opennms.core.concurrent.LogPreservingThreadFactory;
import org.opennms.core.ipc.sink.api.AsyncDispatcher;
import org.opennms.core.ipc.sink.api.Message;
import org.opennms.distributed.core.api.Identity;
import org.opennms.netmgt.dnsresolver.api.DnsResolver;
import org.opennms.netmgt.events.api.EventForwarder;
import org.opennms.netmgt.model.events.EventBuilder;
import org.opennms.netmgt.telemetry.api.receiver.Parser;
import org.opennms.netmgt.telemetry.api.receiver.TelemetryMessage;
import org.opennms.netmgt.telemetry.protocols.netflow.parser.Protocol;
import org.opennms.netmgt.telemetry.protocols.netflow.parser.RecordEnricher;
import org.opennms.netmgt.telemetry.protocols.netflow.parser.RecordEnrichment;
import org.opennms.netmgt.telemetry.protocols.netflow.parser.ie.RecordProvider;
import org.opennms.netmgt.telemetry.protocols.netflow.parser.ie.Value;
import org.opennms.netmgt.telemetry.protocols.netflow.parser.session.SequenceNumberTracker;
import org.opennms.netmgt.telemetry.protocols.netflow.parser.session.Session;
import org.opennms.netmgt.telemetry.protocols.netflow.parser.transport.MessageBuilder;
import org.opennms.netmgt.telemetry.protocols.netflow.transport.FlowMessage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ParserBase
implements Parser {
    private static final Logger LOG = LoggerFactory.getLogger(ParserBase.class);
    private final RateLimitedLog SEQUENCE_ERRORS_LOGGER = RateLimitedLog.withRateLimit((Logger)LOG).maxRate(5).every(Duration.ofSeconds(30L)).build();
    private static final int DEFAULT_NUM_THREADS = Runtime.getRuntime().availableProcessors() * 2;
    private static final long DEFAULT_CLOCK_SKEW_EVENT_RATE_SECONDS = TimeUnit.HOURS.toSeconds(1L);
    private static final long DEFAULT_ILLEGAL_FLOW_EVENT_RATE_SECONDS = TimeUnit.HOURS.toSeconds(1L);
    public static final String CLOCK_SKEW_EVENT_UEI = "uei.opennms.org/internal/telemetry/clockSkewDetected";
    public static final String ILLEGAL_FLOW_EVENT_UEI = "uei.opennms.org/internal/telemetry/illegalFlowDetected";
    private final ThreadLocal<Boolean> isParserThread = new ThreadLocal();
    private final Protocol protocol;
    private final String name;
    private final AsyncDispatcher<TelemetryMessage> dispatcher;
    private final EventForwarder eventForwarder;
    private final Identity identity;
    private final DnsResolver dnsResolver;
    private final Meter recordsReceived;
    private final Meter recordsScheduled;
    private final Meter recordsDispatched;
    private final Meter recordsCompleted;
    private final Counter recordEnrichmentErrors;
    private final Counter recordDispatchErrors;
    private final Meter invalidFlows;
    private final Timer recordEnrichmentTimer;
    private final Counter sequenceErrors;
    private int threads = DEFAULT_NUM_THREADS;
    private long maxClockSkew = 0L;
    private long clockSkewEventRate = 0L;
    private long illegalFlowEventRate = 0L;
    private int sequenceNumberPatience = 32;
    private boolean dnsLookupsEnabled = true;
    private LoadingCache<InetAddress, RateLimiter> clockSkewEventLimiters;
    private LoadingCache<InetAddress, RateLimiter> illegalFlowEventLimiters;
    private ExecutorService executor;

    public ParserBase(Protocol protocol, String name, AsyncDispatcher<TelemetryMessage> dispatcher, EventForwarder eventForwarder, Identity identity, DnsResolver dnsResolver, MetricRegistry metricRegistry) {
        this.protocol = Objects.requireNonNull(protocol);
        this.name = Objects.requireNonNull(name);
        this.dispatcher = Objects.requireNonNull(dispatcher);
        this.eventForwarder = Objects.requireNonNull(eventForwarder);
        this.identity = Objects.requireNonNull(identity);
        this.dnsResolver = Objects.requireNonNull(dnsResolver);
        Objects.requireNonNull(metricRegistry);
        this.recordsReceived = metricRegistry.meter(MetricRegistry.name((String)"parsers", (String[])new String[]{name, "recordsReceived"}));
        this.recordsDispatched = metricRegistry.meter(MetricRegistry.name((String)"parsers", (String[])new String[]{name, "recordsDispatched"}));
        this.recordEnrichmentTimer = metricRegistry.timer(MetricRegistry.name((String)"parsers", (String[])new String[]{name, "recordEnrichment"}));
        this.recordEnrichmentErrors = metricRegistry.counter(MetricRegistry.name((String)"parsers", (String[])new String[]{name, "recordEnrichmentErrors"}));
        this.invalidFlows = metricRegistry.meter(MetricRegistry.name((String)"parsers", (String[])new String[]{name, "invalidFlows"}));
        this.recordsScheduled = metricRegistry.meter(MetricRegistry.name((String)"parsers", (String[])new String[]{name, "recordsScheduled"}));
        this.recordsCompleted = metricRegistry.meter(MetricRegistry.name((String)"parsers", (String[])new String[]{name, "recordsCompleted"}));
        this.recordDispatchErrors = metricRegistry.counter(MetricRegistry.name((String)"parsers", (String[])new String[]{name, "recordDispatchErrors"}));
        this.sequenceErrors = metricRegistry.counter(MetricRegistry.name((String)"parsers", (String[])new String[]{name, "sequenceErrors"}));
        this.setClockSkewEventRate(DEFAULT_CLOCK_SKEW_EVENT_RATE_SECONDS);
        this.setIllegalFlowEventRate(DEFAULT_ILLEGAL_FLOW_EVENT_RATE_SECONDS);
        this.setThreads(DEFAULT_NUM_THREADS);
    }

    protected abstract MessageBuilder getMessageBuilder();

    public void start(ScheduledExecutorService executorService) {
        this.executor = new ThreadPoolExecutor(1, this.threads, 60L, TimeUnit.SECONDS, new SynchronousQueue<Runnable>(), (ThreadFactory)new LogPreservingThreadFactory("Telemetryd-" + this.protocol + "-" + this.name, Integer.MAX_VALUE), (r, executor) -> {
            try {
                if (!executor.isShutdown()) {
                    executor.getQueue().put(r);
                }
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                throw new RejectedExecutionException("Executor interrupted while waiting for capacity in the work queue.", e);
            }
        });
    }

    public void stop() {
        this.executor.shutdown();
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.protocol.description;
    }

    public void setMaxClockSkew(long maxClockSkew) {
        this.maxClockSkew = maxClockSkew;
    }

    public long getMaxClockSkew() {
        return this.maxClockSkew;
    }

    public long getClockSkewEventRate() {
        return this.clockSkewEventRate;
    }

    public void setClockSkewEventRate(long clockSkewEventRate) {
        this.clockSkewEventRate = clockSkewEventRate;
        this.clockSkewEventLimiters = CacheBuilder.newBuilder().expireAfterWrite(this.clockSkewEventRate, TimeUnit.SECONDS).build(CacheLoader.from(() -> RateLimiter.create((double)(1.0 / (double)this.clockSkewEventRate))));
    }

    public void setIllegalFlowEventRate(long illegalFlowEventRate) {
        this.illegalFlowEventRate = illegalFlowEventRate;
        this.illegalFlowEventLimiters = CacheBuilder.newBuilder().expireAfterWrite(this.illegalFlowEventRate, TimeUnit.SECONDS).build(CacheLoader.from(() -> RateLimiter.create((double)(1.0 / (double)this.clockSkewEventRate))));
    }

    public long getIllegalFlowEventRate() {
        return this.illegalFlowEventRate;
    }

    public int getSequenceNumberPatience() {
        return this.sequenceNumberPatience;
    }

    public void setSequenceNumberPatience(int sequenceNumberPatience) {
        this.sequenceNumberPatience = sequenceNumberPatience;
    }

    public boolean getDnsLookupsEnabled() {
        return this.dnsLookupsEnabled;
    }

    public void setDnsLookupsEnabled(boolean dnsLookupsEnabled) {
        this.dnsLookupsEnabled = dnsLookupsEnabled;
    }

    public int getThreads() {
        return this.threads;
    }

    public void setThreads(int threads) {
        if (threads < 1) {
            throw new IllegalArgumentException("Threads must be >= 1");
        }
        this.threads = threads;
    }

    protected CompletableFuture<?> transmit(RecordProvider packet, Session session, InetSocketAddress remoteAddress) {
        if (!session.verifySequenceNumber(packet.getObservationDomainId(), packet.getSequenceNumber())) {
            this.SEQUENCE_ERRORS_LOGGER.warn("Error in flow sequence detected: from {}", (Object)session.getRemoteAddress());
            this.sequenceErrors.inc();
        }
        RecordEnricher recordEnricher = new RecordEnricher(this.dnsResolver, this.getDnsLookupsEnabled());
        CompletableFuture[] futures = (CompletableFuture[])packet.getRecords().map(record -> {
            this.recordsReceived.mark();
            Timer.Context timerContext = this.recordEnrichmentTimer.time();
            return ((CompletableFuture)((CompletableFuture)recordEnricher.enrich((Iterable<Value<?>>)record).whenComplete((enrichment, ex) -> {
                timerContext.close();
                if (ex != null) {
                    this.recordEnrichmentErrors.inc();
                }
            })).thenApplyAsync(enrichment -> {
                FlowMessage.Builder flowMessage;
                this.recordsScheduled.mark();
                try {
                    flowMessage = this.getMessageBuilder().buildMessage((Iterable<Value<?>>)record, (RecordEnrichment)enrichment);
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
                List<String> corrections = this.correctFlow(flowMessage);
                if (!corrections.isEmpty()) {
                    this.invalidFlows.mark();
                    if (((RateLimiter)this.illegalFlowEventLimiters.getUnchecked((Object)session.getRemoteAddress())).tryAcquire()) {
                        this.eventForwarder.sendNow(new EventBuilder().setUei(ILLEGAL_FLOW_EVENT_UEI).setTime(new Date()).setSource(this.getName()).setInterface(session.getRemoteAddress()).setDistPoller(this.identity.getId()).addParam("monitoringSystemId", this.identity.getId()).addParam("monitoringSystemLocation", this.identity.getLocation()).setParam("cause", Joiner.on((char)'\n').join(corrections)).setParam("protocol", this.protocol.name()).setParam("illegalFlowEventRate", (int)this.getIllegalFlowEventRate()).getEvent());
                        for (String correction : corrections) {
                            LOG.warn("Illegal flow detected from exporter {}: \n{}", (Object)session.getRemoteAddress().getAddress(), (Object)correction);
                        }
                    }
                }
                return new TelemetryMessage(remoteAddress, ByteBuffer.wrap(flowMessage.build().toByteArray()));
            }, (Executor)this.executor)).thenCompose(msg -> {
                this.recordsDispatched.mark();
                return this.dispatcher.send((Message)msg).whenComplete((b, exx) -> {
                    if (exx != null) {
                        this.recordDispatchErrors.inc();
                    } else {
                        this.recordsCompleted.mark();
                    }
                });
            });
        }).toArray(CompletableFuture[]::new);
        return CompletableFuture.allOf(futures).whenComplete((any, exx) -> {
            if (exx != null) {
                LOG.warn("One or more of the records were not successfully dispatched.", exx);
            }
        });
    }

    protected void detectClockSkew(long packetTimestampMs, InetAddress remoteAddress) {
        long deltaMs;
        if (this.getMaxClockSkew() > 0L && (deltaMs = Math.abs(packetTimestampMs - System.currentTimeMillis())) > this.getMaxClockSkew() * 1000L && ((RateLimiter)this.clockSkewEventLimiters.getUnchecked((Object)remoteAddress)).tryAcquire()) {
            this.eventForwarder.sendNow(new EventBuilder().setUei(CLOCK_SKEW_EVENT_UEI).setTime(new Date()).setSource(this.getName()).setInterface(remoteAddress).setDistPoller(this.identity.getId()).addParam("monitoringSystemId", this.identity.getId()).addParam("monitoringSystemLocation", this.identity.getLocation()).setParam("delta", (int)deltaMs).setParam("clockSkewEventRate", (int)this.getClockSkewEventRate()).setParam("maxClockSkew", (int)this.getMaxClockSkew()).getEvent());
        }
    }

    private List<String> correctFlow(FlowMessage.Builder flow) {
        ArrayList corrections = Lists.newArrayList();
        if (flow.getFirstSwitched().getValue() > flow.getLastSwitched().getValue()) {
            corrections.add(String.format("Malformed flow: lastSwitched must be greater than firstSwitched: srcAddress=%s, dstAddress=%s, firstSwitched=%d, lastSwitched=%d, duration=%d", flow.getSrcAddress(), flow.getDstAddress(), flow.getFirstSwitched().getValue(), flow.getLastSwitched().getValue(), flow.getLastSwitched().getValue() - flow.getFirstSwitched().getValue()));
            long timeout = flow.hasDeltaSwitched() && flow.getDeltaSwitched().getValue() != flow.getFirstSwitched().getValue() ? flow.getLastSwitched().getValue() - flow.getDeltaSwitched().getValue() : 0L;
            flow.getLastSwitchedBuilder().setValue(flow.getTimestamp());
            flow.getFirstSwitchedBuilder().setValue(flow.getTimestamp() - timeout);
            flow.getDeltaSwitchedBuilder().setValue(flow.getTimestamp() - timeout);
        }
        return corrections;
    }

    protected SequenceNumberTracker sequenceNumberTracker() {
        return new SequenceNumberTracker(this.sequenceNumberPatience);
    }
}

